<?php

namespace Gek\UyumBahceGet\StructType;

use InvalidArgumentException;
use WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for WherePropertyClause StructType
 * @subpackage Structs
 */
class WherePropertyClause extends AbstractStructBase
{
    /**
     * The PropertyName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $PropertyName;
    /**
     * The Value
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Value;

    /**
     * Constructor method for WherePropertyClause
     * @param string $propertyName
     * @param string $value
     * @uses WherePropertyClause::setPropertyName()
     * @uses WherePropertyClause::setValue()
     */
    public function __construct($propertyName = null, $value = null)
    {
        $this
            ->setPropertyName($propertyName)
            ->setValue($value);
    }

    /**
     * Get PropertyName value
     * @return string|null
     */
    public function getPropertyName()
    {
        return $this->PropertyName;
    }

    /**
     * Set PropertyName value
     * @param string $propertyName
     * @return WherePropertyClause
     */
    public function setPropertyName($propertyName = null)
    {
        // validation for constraint: string
        if (!is_null($propertyName) && !is_string($propertyName)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($propertyName, true), gettype($propertyName)), __LINE__);
        }
        $this->PropertyName = $propertyName;
        return $this;
    }

    /**
     * Get Value value
     * @return string|null
     */
    public function getValue()
    {
        return $this->Value;
    }

    /**
     * Set Value value
     * @param string $value
     * @return WherePropertyClause
     */
    public function setValue($value = null)
    {
        // validation for constraint: string
        if (!is_null($value) && !is_string($value)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($value, true), gettype($value)), __LINE__);
        }
        $this->Value = $value;
        return $this;
    }
}
