<?php

namespace Gek\UyumBahceGet\StructType;

use Gek\UyumBahceGet\EnumType\DbType;
use InvalidArgumentException;
use WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for WhereClause StructType
 * @subpackage Structs
 */
class WhereClause extends AbstractStructBase
{
    /**
     * The DType
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $DType;
    /**
     * The FieldName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $FieldName;
    /**
     * The Value
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Value;
    /**
     * The Operator
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Operator;

    /**
     * Constructor method for WhereClause
     * @param string $dType
     * @param string $fieldName
     * @param string $value
     * @param string $operator
     * @uses WhereClause::setDType()
     * @uses WhereClause::setFieldName()
     * @uses WhereClause::setValue()
     * @uses WhereClause::setOperator()
     */
    public function __construct($dType = null, $fieldName = null, $value = null, $operator = null)
    {
        $this
            ->setDType($dType)
            ->setFieldName($fieldName)
            ->setValue($value)
            ->setOperator($operator);
    }

    /**
     * Get DType value
     * @return string
     */
    public function getDType()
    {
        return $this->DType;
    }

    /**
     * Set DType value
     * @param string $dType
     * @return WhereClause
     * @throws InvalidArgumentException
     * @uses \Gek\UyumBahceGet\EnumType\DbType::getValidValues()
     * @uses \Gek\UyumBahceGet\EnumType\DbType::valueIsValid()
     */
    public function setDType($dType = null)
    {
        // validation for constraint: enumeration
        if (!DbType::valueIsValid($dType)) {
            throw new InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \Gek\UyumBahceGet\EnumType\DbType', is_array($dType) ? implode(', ', $dType) : var_export($dType, true), implode(', ', DbType::getValidValues())), __LINE__);
        }
        $this->DType = $dType;
        return $this;
    }

    /**
     * Get FieldName value
     * @return string|null
     */
    public function getFieldName()
    {
        return $this->FieldName;
    }

    /**
     * Set FieldName value
     * @param string $fieldName
     * @return WhereClause
     */
    public function setFieldName($fieldName = null)
    {
        // validation for constraint: string
        if (!is_null($fieldName) && !is_string($fieldName)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($fieldName, true), gettype($fieldName)), __LINE__);
        }
        $this->FieldName = $fieldName;
        return $this;
    }

    /**
     * Get Value value
     * @return string|null
     */
    public function getValue()
    {
        return $this->Value;
    }

    /**
     * Set Value value
     * @param string $value
     * @return WhereClause
     */
    public function setValue($value = null)
    {
        // validation for constraint: string
        if (!is_null($value) && !is_string($value)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($value, true), gettype($value)), __LINE__);
        }
        $this->Value = $value;
        return $this;
    }

    /**
     * Get Operator value
     * @return string|null
     */
    public function getOperator()
    {
        return $this->Operator;
    }

    /**
     * Set Operator value
     * @param string $operator
     * @return WhereClause
     */
    public function setOperator($operator = null)
    {
        // validation for constraint: string
        if (!is_null($operator) && !is_string($operator)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($operator, true), gettype($operator)), __LINE__);
        }
        $this->Operator = $operator;
        return $this;
    }
}
