<?php

namespace Gek\UyumBahceGet\StructType;

use DOMDocument;
use WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Value StructType
 * Meta information extracted from the WSDL
 * - type: s4:ValueType
 * @subpackage Structs
 */
class Value extends AbstractStructBase
{
    /**
     * The schema
     * Meta information extracted from the WSDL
     * - ref: s:schema
     * @var DOMDocument
     */
    public $schema;
    /**
     * The any
     * @var DOMDocument
     */
    public $any;

    /**
     * Constructor method for Value
     * @param DOMDocument $schema
     * @param DOMDocument $any
     * @uses Value::setSchema()
     * @uses Value::setAny()
     */
    public function __construct(DOMDocument $schema = null, DOMDocument $any = null)
    {
        $this
            ->setSchema($schema)
            ->setAny($any);
    }

    /**
     * Get schema value
     * @param bool $asString true: returns XML string, false: returns \DOMDocument
     * @return DOMDocument|null
     * @uses \DOMDocument::loadXML()
     */
    public function getSchema($asString = true)
    {
        $domDocument = null;
        if (!empty($this->schema) && !$asString) {
            $domDocument = new DOMDocument('1.0', 'UTF-8');
            $domDocument->loadXML($this->schema);
        }
        return $asString ? $this->schema : $domDocument;
    }

    /**
     * Set schema value
     * @param DOMDocument $schema
     * @return Value
     * @uses \DOMNode::item()
     * @uses \DOMDocument::hasChildNodes()
     * @uses \DOMDocument::saveXML()
     */
    public function setSchema(DOMDocument $schema = null)
    {
        $this->schema = ($schema instanceof DOMDocument) && $schema->hasChildNodes() ? $schema->saveXML($schema->childNodes->item(0)) : $schema;
        return $this;
    }

    /**
     * Get any value
     * @param bool $asString true: returns XML string, false: returns \DOMDocument
     * @return DOMDocument|null
     * @uses \DOMDocument::loadXML()
     */
    public function getAny($asString = true)
    {
        $domDocument = null;
        if (!empty($this->any) && !$asString) {
            $domDocument = new DOMDocument('1.0', 'UTF-8');
            $domDocument->loadXML($this->any);
        }
        return $asString ? $this->any : $domDocument;
    }

    /**
     * Set any value
     * @param DOMDocument $any
     * @return Value
     * @uses \DOMNode::item()
     * @uses \DOMDocument::hasChildNodes()
     * @uses \DOMDocument::saveXML()
     */
    public function setAny(DOMDocument $any = null)
    {
        $this->any = ($any instanceof DOMDocument) && $any->hasChildNodes() ? $any->saveXML($any->childNodes->item(0)) : $any;
        return $this;
    }
}
