<?php

namespace Gek\UyumBahceGet\StructType;

use InvalidArgumentException;
use WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for UPORequestOfGetSrvItemContext StructType
 * @subpackage Structs
 */
class UPORequestOfGetSrvItemContext extends AbstractStructBase
{
    /**
     * The PageNumber
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $PageNumber = 0;
    /**
     * The PageItemCount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $PageItemCount = 0;
    /**
     * The Username
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Username = null;
    /**
     * The Password
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Password = null;
    /**
     * The Value
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var GetSrvItemContext
     */
    public $Value;

    /**
     * Constructor method for UPORequestOfGetSrvItemContext
     * @param int $pageNumber
     * @param int $pageItemCount
     * @param string $username
     * @param string $password
     * @param GetSrvItemContext $value
     * @uses UPORequestOfGetSrvItemContext::setPageNumber()
     * @uses UPORequestOfGetSrvItemContext::setPageItemCount()
     * @uses UPORequestOfGetSrvItemContext::setUsername()
     * @uses UPORequestOfGetSrvItemContext::setPassword()
     * @uses UPORequestOfGetSrvItemContext::setValue()
     */
    public function __construct($pageNumber = null, $pageItemCount = null, $username = null, $password = null, GetSrvItemContext $value = null)
    {
        $this
            ->setPageNumber($pageNumber)
            ->setPageItemCount($pageItemCount)
            ->setUsername($username)
            ->setPassword($password)
            ->setValue($value);
    }

    /**
     * Get PageNumber value
     * @return int
     */
    public function getPageNumber()
    {
        return $this->PageNumber;
    }

    /**
     * Set PageNumber value
     * @param int $pageNumber
     * @return UPORequestOfGetSrvItemContext
     */
    public function setPageNumber($pageNumber = null)
    {
        // validation for constraint: int
        if (!is_null($pageNumber) && !(is_int($pageNumber) || ctype_digit($pageNumber))) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($pageNumber, true), gettype($pageNumber)), __LINE__);
        }
        $this->PageNumber = $pageNumber;
        return $this;
    }

    /**
     * Get PageItemCount value
     * @return int
     */
    public function getPageItemCount()
    {
        return $this->PageItemCount;
    }

    /**
     * Set PageItemCount value
     * @param int $pageItemCount
     * @return UPORequestOfGetSrvItemContext
     */
    public function setPageItemCount($pageItemCount = null)
    {
        // validation for constraint: int
        if (!is_null($pageItemCount) && !(is_int($pageItemCount) || ctype_digit($pageItemCount))) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($pageItemCount, true), gettype($pageItemCount)), __LINE__);
        }
        $this->PageItemCount = $pageItemCount;
        return $this;
    }

    /**
     * Get Username value
     * @return string|null
     */
    public function getUsername()
    {
        return $this->Username;
    }

    /**
     * Set Username value
     * @param string $username
     * @return UPORequestOfGetSrvItemContext
     */
    public function setUsername($username = null)
    {
        // validation for constraint: string
        if (!is_null($username) && !is_string($username)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($username, true), gettype($username)), __LINE__);
        }
        $this->Username = $username;
        return $this;
    }

    /**
     * Get Password value
     * @return string|null
     */
    public function getPassword()
    {
        return $this->Password;
    }

    /**
     * Set Password value
     * @param string $password
     * @return UPORequestOfGetSrvItemContext
     */
    public function setPassword($password = null)
    {
        // validation for constraint: string
        if (!is_null($password) && !is_string($password)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($password, true), gettype($password)), __LINE__);
        }
        $this->Password = $password;
        return $this;
    }

    /**
     * Get Value value
     * @return GetSrvItemContext|null
     */
    public function getValue()
    {
        return $this->Value;
    }

    /**
     * Set Value value
     * @param GetSrvItemContext $value
     * @return UPORequestOfGetSrvItemContext
     */
    public function setValue(GetSrvItemContext $value = null)
    {
        $this->Value = $value;
        return $this;
    }
}
