<?php

namespace Gek\UyumBahceGet\StructType;

use InvalidArgumentException;
use WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TransportHandlingUnitType StructType
 * @subpackage Structs
 */
class TransportHandlingUnitType extends AbstractStructBase
{
    /**
     * The ID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: s4:ID
     * @var IDType
     */
    public $ID;
    /**
     * The TransportHandlingUnitTypeCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: s4:TransportHandlingUnitTypeCode
     * @var TransportHandlingUnitTypeCodeType
     */
    public $TransportHandlingUnitTypeCode;
    /**
     * The HandlingCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: s4:HandlingCode
     * @var HandlingCodeType
     */
    public $HandlingCode;
    /**
     * The HandlingInstructions
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: s4:HandlingInstructions
     * @var HandlingInstructionsType
     */
    public $HandlingInstructions;
    /**
     * The HazardousRiskIndicator
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: s4:HazardousRiskIndicator
     * @var HazardousRiskIndicatorType
     */
    public $HazardousRiskIndicator;
    /**
     * The TotalGoodsItemQuantity
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: s4:TotalGoodsItemQuantity
     * @var TotalGoodsItemQuantityType
     */
    public $TotalGoodsItemQuantity;
    /**
     * The TotalPackageQuantity
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: s4:TotalPackageQuantity
     * @var TotalPackageQuantityType
     */
    public $TotalPackageQuantity;
    /**
     * The DamageRemarks
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - ref: s4:DamageRemarks
     * @var DamageRemarksType[]
     */
    public $DamageRemarks;
    /**
     * The TraceID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: s4:TraceID
     * @var TraceIDType
     */
    public $TraceID;
    /**
     * The ActualPackage
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var PackageType[]
     */
    public $ActualPackage;
    /**
     * The TransportEquipment
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var TransportEquipmentType[]
     */
    public $TransportEquipment;
    /**
     * The TransportMeans
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var TransportMeansType[]
     */
    public $TransportMeans;
    /**
     * The HazardousGoodsTransit
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var HazardousGoodsTransitType[]
     */
    public $HazardousGoodsTransit;
    /**
     * The MeasurementDimension
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var DimensionType[]
     */
    public $MeasurementDimension;
    /**
     * The MinimumTemperature
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var TemperatureType
     */
    public $MinimumTemperature;
    /**
     * The MaximumTemperature
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var TemperatureType
     */
    public $MaximumTemperature;
    /**
     * The FloorSpaceMeasurementDimension
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var DimensionType
     */
    public $FloorSpaceMeasurementDimension;
    /**
     * The PalletSpaceMeasurementDimension
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var DimensionType
     */
    public $PalletSpaceMeasurementDimension;
    /**
     * The ShipmentDocumentReference
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var DocumentReferenceType[]
     */
    public $ShipmentDocumentReference;
    /**
     * The CustomsDeclaration
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var CustomsDeclarationType[]
     */
    public $CustomsDeclaration;

    /**
     * Constructor method for TransportHandlingUnitType
     * @param IDType $iD
     * @param TransportHandlingUnitTypeCodeType $transportHandlingUnitTypeCode
     * @param HandlingCodeType $handlingCode
     * @param HandlingInstructionsType $handlingInstructions
     * @param HazardousRiskIndicatorType $hazardousRiskIndicator
     * @param TotalGoodsItemQuantityType $totalGoodsItemQuantity
     * @param TotalPackageQuantityType $totalPackageQuantity
     * @param DamageRemarksType[] $damageRemarks
     * @param TraceIDType $traceID
     * @param PackageType[] $actualPackage
     * @param TransportEquipmentType[] $transportEquipment
     * @param TransportMeansType[] $transportMeans
     * @param HazardousGoodsTransitType[] $hazardousGoodsTransit
     * @param DimensionType[] $measurementDimension
     * @param TemperatureType $minimumTemperature
     * @param TemperatureType $maximumTemperature
     * @param DimensionType $floorSpaceMeasurementDimension
     * @param DimensionType $palletSpaceMeasurementDimension
     * @param DocumentReferenceType[] $shipmentDocumentReference
     * @param CustomsDeclarationType[] $customsDeclaration
     * @uses TransportHandlingUnitType::setID()
     * @uses TransportHandlingUnitType::setTransportHandlingUnitTypeCode()
     * @uses TransportHandlingUnitType::setHandlingCode()
     * @uses TransportHandlingUnitType::setHandlingInstructions()
     * @uses TransportHandlingUnitType::setHazardousRiskIndicator()
     * @uses TransportHandlingUnitType::setTotalGoodsItemQuantity()
     * @uses TransportHandlingUnitType::setTotalPackageQuantity()
     * @uses TransportHandlingUnitType::setDamageRemarks()
     * @uses TransportHandlingUnitType::setTraceID()
     * @uses TransportHandlingUnitType::setActualPackage()
     * @uses TransportHandlingUnitType::setTransportEquipment()
     * @uses TransportHandlingUnitType::setTransportMeans()
     * @uses TransportHandlingUnitType::setHazardousGoodsTransit()
     * @uses TransportHandlingUnitType::setMeasurementDimension()
     * @uses TransportHandlingUnitType::setMinimumTemperature()
     * @uses TransportHandlingUnitType::setMaximumTemperature()
     * @uses TransportHandlingUnitType::setFloorSpaceMeasurementDimension()
     * @uses TransportHandlingUnitType::setPalletSpaceMeasurementDimension()
     * @uses TransportHandlingUnitType::setShipmentDocumentReference()
     * @uses TransportHandlingUnitType::setCustomsDeclaration()
     */
    public function __construct(IDType $iD = null, TransportHandlingUnitTypeCodeType $transportHandlingUnitTypeCode = null, HandlingCodeType $handlingCode = null, HandlingInstructionsType $handlingInstructions = null, HazardousRiskIndicatorType $hazardousRiskIndicator = null, TotalGoodsItemQuantityType $totalGoodsItemQuantity = null, TotalPackageQuantityType $totalPackageQuantity = null, array $damageRemarks = array(), TraceIDType $traceID = null, array $actualPackage = array(), array $transportEquipment = array(), array $transportMeans = array(), array $hazardousGoodsTransit = array(), array $measurementDimension = array(), TemperatureType $minimumTemperature = null, TemperatureType $maximumTemperature = null, DimensionType $floorSpaceMeasurementDimension = null, DimensionType $palletSpaceMeasurementDimension = null, array $shipmentDocumentReference = array(), array $customsDeclaration = array())
    {
        $this
            ->setID($iD)
            ->setTransportHandlingUnitTypeCode($transportHandlingUnitTypeCode)
            ->setHandlingCode($handlingCode)
            ->setHandlingInstructions($handlingInstructions)
            ->setHazardousRiskIndicator($hazardousRiskIndicator)
            ->setTotalGoodsItemQuantity($totalGoodsItemQuantity)
            ->setTotalPackageQuantity($totalPackageQuantity)
            ->setDamageRemarks($damageRemarks)
            ->setTraceID($traceID)
            ->setActualPackage($actualPackage)
            ->setTransportEquipment($transportEquipment)
            ->setTransportMeans($transportMeans)
            ->setHazardousGoodsTransit($hazardousGoodsTransit)
            ->setMeasurementDimension($measurementDimension)
            ->setMinimumTemperature($minimumTemperature)
            ->setMaximumTemperature($maximumTemperature)
            ->setFloorSpaceMeasurementDimension($floorSpaceMeasurementDimension)
            ->setPalletSpaceMeasurementDimension($palletSpaceMeasurementDimension)
            ->setShipmentDocumentReference($shipmentDocumentReference)
            ->setCustomsDeclaration($customsDeclaration);
    }

    /**
     * Get ID value
     * @return IDType|null
     */
    public function getID()
    {
        return $this->ID;
    }

    /**
     * Set ID value
     * @param IDType $iD
     * @return TransportHandlingUnitType
     */
    public function setID(IDType $iD = null)
    {
        $this->ID = $iD;
        return $this;
    }

    /**
     * Get TransportHandlingUnitTypeCode value
     * @return TransportHandlingUnitTypeCodeType|null
     */
    public function getTransportHandlingUnitTypeCode()
    {
        return $this->TransportHandlingUnitTypeCode;
    }

    /**
     * Set TransportHandlingUnitTypeCode value
     * @param TransportHandlingUnitTypeCodeType $transportHandlingUnitTypeCode
     * @return TransportHandlingUnitType
     */
    public function setTransportHandlingUnitTypeCode(TransportHandlingUnitTypeCodeType $transportHandlingUnitTypeCode = null)
    {
        $this->TransportHandlingUnitTypeCode = $transportHandlingUnitTypeCode;
        return $this;
    }

    /**
     * Get HandlingCode value
     * @return HandlingCodeType|null
     */
    public function getHandlingCode()
    {
        return $this->HandlingCode;
    }

    /**
     * Set HandlingCode value
     * @param HandlingCodeType $handlingCode
     * @return TransportHandlingUnitType
     */
    public function setHandlingCode(HandlingCodeType $handlingCode = null)
    {
        $this->HandlingCode = $handlingCode;
        return $this;
    }

    /**
     * Get HandlingInstructions value
     * @return HandlingInstructionsType|null
     */
    public function getHandlingInstructions()
    {
        return $this->HandlingInstructions;
    }

    /**
     * Set HandlingInstructions value
     * @param HandlingInstructionsType $handlingInstructions
     * @return TransportHandlingUnitType
     */
    public function setHandlingInstructions(HandlingInstructionsType $handlingInstructions = null)
    {
        $this->HandlingInstructions = $handlingInstructions;
        return $this;
    }

    /**
     * Get HazardousRiskIndicator value
     * @return HazardousRiskIndicatorType|null
     */
    public function getHazardousRiskIndicator()
    {
        return $this->HazardousRiskIndicator;
    }

    /**
     * Set HazardousRiskIndicator value
     * @param HazardousRiskIndicatorType $hazardousRiskIndicator
     * @return TransportHandlingUnitType
     */
    public function setHazardousRiskIndicator(HazardousRiskIndicatorType $hazardousRiskIndicator = null)
    {
        $this->HazardousRiskIndicator = $hazardousRiskIndicator;
        return $this;
    }

    /**
     * Get TotalGoodsItemQuantity value
     * @return TotalGoodsItemQuantityType|null
     */
    public function getTotalGoodsItemQuantity()
    {
        return $this->TotalGoodsItemQuantity;
    }

    /**
     * Set TotalGoodsItemQuantity value
     * @param TotalGoodsItemQuantityType $totalGoodsItemQuantity
     * @return TransportHandlingUnitType
     */
    public function setTotalGoodsItemQuantity(TotalGoodsItemQuantityType $totalGoodsItemQuantity = null)
    {
        $this->TotalGoodsItemQuantity = $totalGoodsItemQuantity;
        return $this;
    }

    /**
     * Get TotalPackageQuantity value
     * @return TotalPackageQuantityType|null
     */
    public function getTotalPackageQuantity()
    {
        return $this->TotalPackageQuantity;
    }

    /**
     * Set TotalPackageQuantity value
     * @param TotalPackageQuantityType $totalPackageQuantity
     * @return TransportHandlingUnitType
     */
    public function setTotalPackageQuantity(TotalPackageQuantityType $totalPackageQuantity = null)
    {
        $this->TotalPackageQuantity = $totalPackageQuantity;
        return $this;
    }

    /**
     * Get DamageRemarks value
     * @return DamageRemarksType[]|null
     */
    public function getDamageRemarks()
    {
        return $this->DamageRemarks;
    }

    /**
     * This method is responsible for validating the values passed to the setDamageRemarks method
     * This method is willingly generated in order to preserve the one-line inline validation within the setDamageRemarks method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateDamageRemarksForArrayConstraintsFromSetDamageRemarks(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $transportHandlingUnitTypeDamageRemarksItem) {
            // validation for constraint: itemType
            if (!$transportHandlingUnitTypeDamageRemarksItem instanceof DamageRemarksType) {
                $invalidValues[] = is_object($transportHandlingUnitTypeDamageRemarksItem) ? get_class($transportHandlingUnitTypeDamageRemarksItem) : sprintf('%s(%s)', gettype($transportHandlingUnitTypeDamageRemarksItem), var_export($transportHandlingUnitTypeDamageRemarksItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The DamageRemarks property can only contain items of type \Gek\UyumBahceGet\StructType\DamageRemarksType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }

    /**
     * Set DamageRemarks value
     * @param DamageRemarksType[] $damageRemarks
     * @return TransportHandlingUnitType
     * @throws InvalidArgumentException
     */
    public function setDamageRemarks(array $damageRemarks = array())
    {
        // validation for constraint: array
        if ('' !== ($damageRemarksArrayErrorMessage = self::validateDamageRemarksForArrayConstraintsFromSetDamageRemarks($damageRemarks))) {
            throw new InvalidArgumentException($damageRemarksArrayErrorMessage, __LINE__);
        }
        $this->DamageRemarks = $damageRemarks;
        return $this;
    }

    /**
     * Add item to DamageRemarks value
     * @param DamageRemarksType $item
     * @return TransportHandlingUnitType
     * @throws InvalidArgumentException
     */
    public function addToDamageRemarks(DamageRemarksType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof DamageRemarksType) {
            throw new InvalidArgumentException(sprintf('The DamageRemarks property can only contain items of type \Gek\UyumBahceGet\StructType\DamageRemarksType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->DamageRemarks[] = $item;
        return $this;
    }

    /**
     * Get TraceID value
     * @return TraceIDType|null
     */
    public function getTraceID()
    {
        return $this->TraceID;
    }

    /**
     * Set TraceID value
     * @param TraceIDType $traceID
     * @return TransportHandlingUnitType
     */
    public function setTraceID(TraceIDType $traceID = null)
    {
        $this->TraceID = $traceID;
        return $this;
    }

    /**
     * Get ActualPackage value
     * @return PackageType[]|null
     */
    public function getActualPackage()
    {
        return $this->ActualPackage;
    }

    /**
     * This method is responsible for validating the values passed to the setActualPackage method
     * This method is willingly generated in order to preserve the one-line inline validation within the setActualPackage method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateActualPackageForArrayConstraintsFromSetActualPackage(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $transportHandlingUnitTypeActualPackageItem) {
            // validation for constraint: itemType
            if (!$transportHandlingUnitTypeActualPackageItem instanceof PackageType) {
                $invalidValues[] = is_object($transportHandlingUnitTypeActualPackageItem) ? get_class($transportHandlingUnitTypeActualPackageItem) : sprintf('%s(%s)', gettype($transportHandlingUnitTypeActualPackageItem), var_export($transportHandlingUnitTypeActualPackageItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The ActualPackage property can only contain items of type \Gek\UyumBahceGet\StructType\PackageType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }

    /**
     * Set ActualPackage value
     * @param PackageType[] $actualPackage
     * @return TransportHandlingUnitType
     * @throws InvalidArgumentException
     */
    public function setActualPackage(array $actualPackage = array())
    {
        // validation for constraint: array
        if ('' !== ($actualPackageArrayErrorMessage = self::validateActualPackageForArrayConstraintsFromSetActualPackage($actualPackage))) {
            throw new InvalidArgumentException($actualPackageArrayErrorMessage, __LINE__);
        }
        $this->ActualPackage = $actualPackage;
        return $this;
    }

    /**
     * Add item to ActualPackage value
     * @param PackageType $item
     * @return TransportHandlingUnitType
     * @throws InvalidArgumentException
     */
    public function addToActualPackage(PackageType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof PackageType) {
            throw new InvalidArgumentException(sprintf('The ActualPackage property can only contain items of type \Gek\UyumBahceGet\StructType\PackageType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->ActualPackage[] = $item;
        return $this;
    }

    /**
     * Get TransportEquipment value
     * @return TransportEquipmentType[]|null
     */
    public function getTransportEquipment()
    {
        return $this->TransportEquipment;
    }

    /**
     * This method is responsible for validating the values passed to the setTransportEquipment method
     * This method is willingly generated in order to preserve the one-line inline validation within the setTransportEquipment method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateTransportEquipmentForArrayConstraintsFromSetTransportEquipment(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $transportHandlingUnitTypeTransportEquipmentItem) {
            // validation for constraint: itemType
            if (!$transportHandlingUnitTypeTransportEquipmentItem instanceof TransportEquipmentType) {
                $invalidValues[] = is_object($transportHandlingUnitTypeTransportEquipmentItem) ? get_class($transportHandlingUnitTypeTransportEquipmentItem) : sprintf('%s(%s)', gettype($transportHandlingUnitTypeTransportEquipmentItem), var_export($transportHandlingUnitTypeTransportEquipmentItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The TransportEquipment property can only contain items of type \Gek\UyumBahceGet\StructType\TransportEquipmentType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }

    /**
     * Set TransportEquipment value
     * @param TransportEquipmentType[] $transportEquipment
     * @return TransportHandlingUnitType
     * @throws InvalidArgumentException
     */
    public function setTransportEquipment(array $transportEquipment = array())
    {
        // validation for constraint: array
        if ('' !== ($transportEquipmentArrayErrorMessage = self::validateTransportEquipmentForArrayConstraintsFromSetTransportEquipment($transportEquipment))) {
            throw new InvalidArgumentException($transportEquipmentArrayErrorMessage, __LINE__);
        }
        $this->TransportEquipment = $transportEquipment;
        return $this;
    }

    /**
     * Add item to TransportEquipment value
     * @param TransportEquipmentType $item
     * @return TransportHandlingUnitType
     * @throws InvalidArgumentException
     */
    public function addToTransportEquipment(TransportEquipmentType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof TransportEquipmentType) {
            throw new InvalidArgumentException(sprintf('The TransportEquipment property can only contain items of type \Gek\UyumBahceGet\StructType\TransportEquipmentType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->TransportEquipment[] = $item;
        return $this;
    }

    /**
     * Get TransportMeans value
     * @return TransportMeansType[]|null
     */
    public function getTransportMeans()
    {
        return $this->TransportMeans;
    }

    /**
     * This method is responsible for validating the values passed to the setTransportMeans method
     * This method is willingly generated in order to preserve the one-line inline validation within the setTransportMeans method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateTransportMeansForArrayConstraintsFromSetTransportMeans(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $transportHandlingUnitTypeTransportMeansItem) {
            // validation for constraint: itemType
            if (!$transportHandlingUnitTypeTransportMeansItem instanceof TransportMeansType) {
                $invalidValues[] = is_object($transportHandlingUnitTypeTransportMeansItem) ? get_class($transportHandlingUnitTypeTransportMeansItem) : sprintf('%s(%s)', gettype($transportHandlingUnitTypeTransportMeansItem), var_export($transportHandlingUnitTypeTransportMeansItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The TransportMeans property can only contain items of type \Gek\UyumBahceGet\StructType\TransportMeansType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }

    /**
     * Set TransportMeans value
     * @param TransportMeansType[] $transportMeans
     * @return TransportHandlingUnitType
     * @throws InvalidArgumentException
     */
    public function setTransportMeans(array $transportMeans = array())
    {
        // validation for constraint: array
        if ('' !== ($transportMeansArrayErrorMessage = self::validateTransportMeansForArrayConstraintsFromSetTransportMeans($transportMeans))) {
            throw new InvalidArgumentException($transportMeansArrayErrorMessage, __LINE__);
        }
        $this->TransportMeans = $transportMeans;
        return $this;
    }

    /**
     * Add item to TransportMeans value
     * @param TransportMeansType $item
     * @return TransportHandlingUnitType
     * @throws InvalidArgumentException
     */
    public function addToTransportMeans(TransportMeansType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof TransportMeansType) {
            throw new InvalidArgumentException(sprintf('The TransportMeans property can only contain items of type \Gek\UyumBahceGet\StructType\TransportMeansType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->TransportMeans[] = $item;
        return $this;
    }

    /**
     * Get HazardousGoodsTransit value
     * @return HazardousGoodsTransitType[]|null
     */
    public function getHazardousGoodsTransit()
    {
        return $this->HazardousGoodsTransit;
    }

    /**
     * This method is responsible for validating the values passed to the setHazardousGoodsTransit method
     * This method is willingly generated in order to preserve the one-line inline validation within the setHazardousGoodsTransit method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateHazardousGoodsTransitForArrayConstraintsFromSetHazardousGoodsTransit(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $transportHandlingUnitTypeHazardousGoodsTransitItem) {
            // validation for constraint: itemType
            if (!$transportHandlingUnitTypeHazardousGoodsTransitItem instanceof HazardousGoodsTransitType) {
                $invalidValues[] = is_object($transportHandlingUnitTypeHazardousGoodsTransitItem) ? get_class($transportHandlingUnitTypeHazardousGoodsTransitItem) : sprintf('%s(%s)', gettype($transportHandlingUnitTypeHazardousGoodsTransitItem), var_export($transportHandlingUnitTypeHazardousGoodsTransitItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The HazardousGoodsTransit property can only contain items of type \Gek\UyumBahceGet\StructType\HazardousGoodsTransitType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }

    /**
     * Set HazardousGoodsTransit value
     * @param HazardousGoodsTransitType[] $hazardousGoodsTransit
     * @return TransportHandlingUnitType
     * @throws InvalidArgumentException
     */
    public function setHazardousGoodsTransit(array $hazardousGoodsTransit = array())
    {
        // validation for constraint: array
        if ('' !== ($hazardousGoodsTransitArrayErrorMessage = self::validateHazardousGoodsTransitForArrayConstraintsFromSetHazardousGoodsTransit($hazardousGoodsTransit))) {
            throw new InvalidArgumentException($hazardousGoodsTransitArrayErrorMessage, __LINE__);
        }
        $this->HazardousGoodsTransit = $hazardousGoodsTransit;
        return $this;
    }

    /**
     * Add item to HazardousGoodsTransit value
     * @param HazardousGoodsTransitType $item
     * @return TransportHandlingUnitType
     * @throws InvalidArgumentException
     */
    public function addToHazardousGoodsTransit(HazardousGoodsTransitType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof HazardousGoodsTransitType) {
            throw new InvalidArgumentException(sprintf('The HazardousGoodsTransit property can only contain items of type \Gek\UyumBahceGet\StructType\HazardousGoodsTransitType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->HazardousGoodsTransit[] = $item;
        return $this;
    }

    /**
     * Get MeasurementDimension value
     * @return DimensionType[]|null
     */
    public function getMeasurementDimension()
    {
        return $this->MeasurementDimension;
    }

    /**
     * This method is responsible for validating the values passed to the setMeasurementDimension method
     * This method is willingly generated in order to preserve the one-line inline validation within the setMeasurementDimension method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateMeasurementDimensionForArrayConstraintsFromSetMeasurementDimension(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $transportHandlingUnitTypeMeasurementDimensionItem) {
            // validation for constraint: itemType
            if (!$transportHandlingUnitTypeMeasurementDimensionItem instanceof DimensionType) {
                $invalidValues[] = is_object($transportHandlingUnitTypeMeasurementDimensionItem) ? get_class($transportHandlingUnitTypeMeasurementDimensionItem) : sprintf('%s(%s)', gettype($transportHandlingUnitTypeMeasurementDimensionItem), var_export($transportHandlingUnitTypeMeasurementDimensionItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The MeasurementDimension property can only contain items of type \Gek\UyumBahceGet\StructType\DimensionType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }

    /**
     * Set MeasurementDimension value
     * @param DimensionType[] $measurementDimension
     * @return TransportHandlingUnitType
     * @throws InvalidArgumentException
     */
    public function setMeasurementDimension(array $measurementDimension = array())
    {
        // validation for constraint: array
        if ('' !== ($measurementDimensionArrayErrorMessage = self::validateMeasurementDimensionForArrayConstraintsFromSetMeasurementDimension($measurementDimension))) {
            throw new InvalidArgumentException($measurementDimensionArrayErrorMessage, __LINE__);
        }
        $this->MeasurementDimension = $measurementDimension;
        return $this;
    }

    /**
     * Add item to MeasurementDimension value
     * @param DimensionType $item
     * @return TransportHandlingUnitType
     * @throws InvalidArgumentException
     */
    public function addToMeasurementDimension(DimensionType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof DimensionType) {
            throw new InvalidArgumentException(sprintf('The MeasurementDimension property can only contain items of type \Gek\UyumBahceGet\StructType\DimensionType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->MeasurementDimension[] = $item;
        return $this;
    }

    /**
     * Get MinimumTemperature value
     * @return TemperatureType|null
     */
    public function getMinimumTemperature()
    {
        return $this->MinimumTemperature;
    }

    /**
     * Set MinimumTemperature value
     * @param TemperatureType $minimumTemperature
     * @return TransportHandlingUnitType
     */
    public function setMinimumTemperature(TemperatureType $minimumTemperature = null)
    {
        $this->MinimumTemperature = $minimumTemperature;
        return $this;
    }

    /**
     * Get MaximumTemperature value
     * @return TemperatureType|null
     */
    public function getMaximumTemperature()
    {
        return $this->MaximumTemperature;
    }

    /**
     * Set MaximumTemperature value
     * @param TemperatureType $maximumTemperature
     * @return TransportHandlingUnitType
     */
    public function setMaximumTemperature(TemperatureType $maximumTemperature = null)
    {
        $this->MaximumTemperature = $maximumTemperature;
        return $this;
    }

    /**
     * Get FloorSpaceMeasurementDimension value
     * @return DimensionType|null
     */
    public function getFloorSpaceMeasurementDimension()
    {
        return $this->FloorSpaceMeasurementDimension;
    }

    /**
     * Set FloorSpaceMeasurementDimension value
     * @param DimensionType $floorSpaceMeasurementDimension
     * @return TransportHandlingUnitType
     */
    public function setFloorSpaceMeasurementDimension(DimensionType $floorSpaceMeasurementDimension = null)
    {
        $this->FloorSpaceMeasurementDimension = $floorSpaceMeasurementDimension;
        return $this;
    }

    /**
     * Get PalletSpaceMeasurementDimension value
     * @return DimensionType|null
     */
    public function getPalletSpaceMeasurementDimension()
    {
        return $this->PalletSpaceMeasurementDimension;
    }

    /**
     * Set PalletSpaceMeasurementDimension value
     * @param DimensionType $palletSpaceMeasurementDimension
     * @return TransportHandlingUnitType
     */
    public function setPalletSpaceMeasurementDimension(DimensionType $palletSpaceMeasurementDimension = null)
    {
        $this->PalletSpaceMeasurementDimension = $palletSpaceMeasurementDimension;
        return $this;
    }

    /**
     * Get ShipmentDocumentReference value
     * @return DocumentReferenceType[]|null
     */
    public function getShipmentDocumentReference()
    {
        return $this->ShipmentDocumentReference;
    }

    /**
     * This method is responsible for validating the values passed to the setShipmentDocumentReference method
     * This method is willingly generated in order to preserve the one-line inline validation within the setShipmentDocumentReference method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateShipmentDocumentReferenceForArrayConstraintsFromSetShipmentDocumentReference(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $transportHandlingUnitTypeShipmentDocumentReferenceItem) {
            // validation for constraint: itemType
            if (!$transportHandlingUnitTypeShipmentDocumentReferenceItem instanceof DocumentReferenceType) {
                $invalidValues[] = is_object($transportHandlingUnitTypeShipmentDocumentReferenceItem) ? get_class($transportHandlingUnitTypeShipmentDocumentReferenceItem) : sprintf('%s(%s)', gettype($transportHandlingUnitTypeShipmentDocumentReferenceItem), var_export($transportHandlingUnitTypeShipmentDocumentReferenceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The ShipmentDocumentReference property can only contain items of type \Gek\UyumBahceGet\StructType\DocumentReferenceType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }

    /**
     * Set ShipmentDocumentReference value
     * @param DocumentReferenceType[] $shipmentDocumentReference
     * @return TransportHandlingUnitType
     * @throws InvalidArgumentException
     */
    public function setShipmentDocumentReference(array $shipmentDocumentReference = array())
    {
        // validation for constraint: array
        if ('' !== ($shipmentDocumentReferenceArrayErrorMessage = self::validateShipmentDocumentReferenceForArrayConstraintsFromSetShipmentDocumentReference($shipmentDocumentReference))) {
            throw new InvalidArgumentException($shipmentDocumentReferenceArrayErrorMessage, __LINE__);
        }
        $this->ShipmentDocumentReference = $shipmentDocumentReference;
        return $this;
    }

    /**
     * Add item to ShipmentDocumentReference value
     * @param DocumentReferenceType $item
     * @return TransportHandlingUnitType
     * @throws InvalidArgumentException
     */
    public function addToShipmentDocumentReference(DocumentReferenceType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof DocumentReferenceType) {
            throw new InvalidArgumentException(sprintf('The ShipmentDocumentReference property can only contain items of type \Gek\UyumBahceGet\StructType\DocumentReferenceType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->ShipmentDocumentReference[] = $item;
        return $this;
    }

    /**
     * Get CustomsDeclaration value
     * @return CustomsDeclarationType[]|null
     */
    public function getCustomsDeclaration()
    {
        return $this->CustomsDeclaration;
    }

    /**
     * This method is responsible for validating the values passed to the setCustomsDeclaration method
     * This method is willingly generated in order to preserve the one-line inline validation within the setCustomsDeclaration method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateCustomsDeclarationForArrayConstraintsFromSetCustomsDeclaration(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $transportHandlingUnitTypeCustomsDeclarationItem) {
            // validation for constraint: itemType
            if (!$transportHandlingUnitTypeCustomsDeclarationItem instanceof CustomsDeclarationType) {
                $invalidValues[] = is_object($transportHandlingUnitTypeCustomsDeclarationItem) ? get_class($transportHandlingUnitTypeCustomsDeclarationItem) : sprintf('%s(%s)', gettype($transportHandlingUnitTypeCustomsDeclarationItem), var_export($transportHandlingUnitTypeCustomsDeclarationItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The CustomsDeclaration property can only contain items of type \Gek\UyumBahceGet\StructType\CustomsDeclarationType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }

    /**
     * Set CustomsDeclaration value
     * @param CustomsDeclarationType[] $customsDeclaration
     * @return TransportHandlingUnitType
     * @throws InvalidArgumentException
     */
    public function setCustomsDeclaration(array $customsDeclaration = array())
    {
        // validation for constraint: array
        if ('' !== ($customsDeclarationArrayErrorMessage = self::validateCustomsDeclarationForArrayConstraintsFromSetCustomsDeclaration($customsDeclaration))) {
            throw new InvalidArgumentException($customsDeclarationArrayErrorMessage, __LINE__);
        }
        $this->CustomsDeclaration = $customsDeclaration;
        return $this;
    }

    /**
     * Add item to CustomsDeclaration value
     * @param CustomsDeclarationType $item
     * @return TransportHandlingUnitType
     * @throws InvalidArgumentException
     */
    public function addToCustomsDeclaration(CustomsDeclarationType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof CustomsDeclarationType) {
            throw new InvalidArgumentException(sprintf('The CustomsDeclaration property can only contain items of type \Gek\UyumBahceGet\StructType\CustomsDeclarationType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->CustomsDeclaration[] = $item;
        return $this;
    }
}
