<?php

namespace Gek\UyumBahceGet\StructType;

use DOMDocument;
use InvalidArgumentException;
use WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TransformType StructType
 * Meta information extracted from the WSDL
 * - mixed: true
 * @subpackage Structs
 */
class TransformType extends AbstractStructBase
{
    /**
     * The XPath
     * Meta information extracted from the WSDL
     * - choice: XPath |
     * - choiceMaxOccurs: unbounded
     * - choiceMinOccurs: 0
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string[]
     */
    public $XPath;
    /**
     * The any
     * @var DOMDocument
     */
    public $any;
    /**
     * The Algorithm
     * @var string
     */
    public $Algorithm;

    /**
     * Constructor method for TransformType
     * @param string[] $xPath
     * @param DOMDocument $any
     * @param string $algorithm
     * @uses TransformType::setXPath()
     * @uses TransformType::setAny()
     * @uses TransformType::setAlgorithm()
     */
    public function __construct(array $xPath = array(), DOMDocument $any = null, $algorithm = null)
    {
        $this
            ->setXPath($xPath)
            ->setAny($any)
            ->setAlgorithm($algorithm);
    }

    /**
     * Get XPath value
     * @return string[]|null
     */
    public function getXPath()
    {
        return isset($this->XPath) ? $this->XPath : null;
    }

    /**
     * This method is responsible for validating the values passed to the setXPath method
     * This method is willingly generated in order to preserve the one-line inline validation within the setXPath method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateXPathForArrayConstraintsFromSetXPath(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $transformTypeXPathItem) {
            // validation for constraint: itemType
            if (!is_string($transformTypeXPathItem)) {
                $invalidValues[] = is_object($transformTypeXPathItem) ? get_class($transformTypeXPathItem) : sprintf('%s(%s)', gettype($transformTypeXPathItem), var_export($transformTypeXPathItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The XPath property can only contain items of type string, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }

    /**
     * This method is responsible for validating the value passed to the setXPath method
     * This method is willingly generated in order to preserve the one-line inline validation within the setXPath method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateXPathForChoiceConstraintsFromSetXPath($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new InvalidArgumentException(sprintf('The property XPath can\'t be set as the property %s is already set. Only one property must be set among these properties: XPath, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }

    /**
     * Set XPath value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @param string[] $xPath
     * @return TransformType
     * @throws InvalidArgumentException
     * @throws InvalidArgumentException
     */
    public function setXPath(array $xPath = array())
    {
        // validation for constraint: array
        if ('' !== ($xPathArrayErrorMessage = self::validateXPathForArrayConstraintsFromSetXPath($xPath))) {
            throw new InvalidArgumentException($xPathArrayErrorMessage, __LINE__);
        }
        // validation for constraint: choice(XPath, )
        if ('' !== ($xPathChoiceErrorMessage = self::validateXPathForChoiceConstraintsFromSetXPath($xPath))) {
            throw new InvalidArgumentException($xPathChoiceErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(1)
        if (is_array($xPath) && count($xPath) > 1) {
            throw new InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 1', count($xPath)), __LINE__);
        }
        if (is_null($xPath) || (is_array($xPath) && empty($xPath))) {
            unset($this->XPath);
        } else {
            $this->XPath = $xPath;
        }
        return $this;
    }

    /**
     * This method is responsible for validating the value passed to the addToXPath method
     * This method is willingly generated in order to preserve the one-line inline validation within the addToXPath method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateItemForChoiceConstraintsFromAddToXPath($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new InvalidArgumentException(sprintf('The property XPath can\'t be set as the property %s is already set. Only one property must be set among these properties: XPath, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }

    /**
     * Add item to XPath value
     * @param string $item
     * @return TransformType
     * @throws InvalidArgumentException
     */
    public function addToXPath($item)
    {
        // validation for constraint: itemType
        if (!is_string($item)) {
            throw new InvalidArgumentException(sprintf('The XPath property can only contain items of type string, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: choice(XPath, )
        if ('' !== ($itemChoiceErrorMessage = self::validateItemForChoiceConstraintsFromAddToXPath($item))) {
            throw new InvalidArgumentException($itemChoiceErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(1)
        if (is_array($this->XPath) && count($this->XPath) >= 1) {
            throw new InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 1', count($this->XPath)), __LINE__);
        }
        $this->XPath[] = $item;
        return $this;
    }

    /**
     * Get any value
     * @param bool $asString true: returns XML string, false: returns \DOMDocument
     * @return DOMDocument|null
     * @uses \DOMDocument::loadXML()
     */
    public function getAny($asString = true)
    {
        $domDocument = null;
        if (!empty($this->any) && !$asString) {
            $domDocument = new DOMDocument('1.0', 'UTF-8');
            $domDocument->loadXML($this->any);
        }
        return $asString ? $this->any : $domDocument;
    }

    /**
     * Set any value
     * @param DOMDocument $any
     * @return TransformType
     * @uses \DOMNode::item()
     * @uses \DOMDocument::hasChildNodes()
     * @uses \DOMDocument::saveXML()
     */
    public function setAny(DOMDocument $any = null)
    {
        $this->any = ($any instanceof DOMDocument) && $any->hasChildNodes() ? $any->saveXML($any->childNodes->item(0)) : $any;
        return $this;
    }

    /**
     * Get Algorithm value
     * @return string|null
     */
    public function getAlgorithm()
    {
        return $this->Algorithm;
    }

    /**
     * Set Algorithm value
     * @param string $algorithm
     * @return TransformType
     */
    public function setAlgorithm($algorithm = null)
    {
        // validation for constraint: string
        if (!is_null($algorithm) && !is_string($algorithm)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($algorithm, true), gettype($algorithm)), __LINE__);
        }
        $this->Algorithm = $algorithm;
        return $this;
    }
}
