<?php

namespace Gek\UyumBahceGet\StructType;

use InvalidArgumentException;
use WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TaxTotalType StructType
 * @subpackage Structs
 */
class TaxTotalType extends AbstractStructBase
{
    /**
     * The TaxAmount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: s4:TaxAmount
     * @var TaxAmountType
     */
    public $TaxAmount;
    /**
     * The TaxSubtotal
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var TaxSubtotalType[]
     */
    public $TaxSubtotal;

    /**
     * Constructor method for TaxTotalType
     * @param TaxAmountType $taxAmount
     * @param TaxSubtotalType[] $taxSubtotal
     * @uses TaxTotalType::setTaxAmount()
     * @uses TaxTotalType::setTaxSubtotal()
     */
    public function __construct(TaxAmountType $taxAmount = null, array $taxSubtotal = array())
    {
        $this
            ->setTaxAmount($taxAmount)
            ->setTaxSubtotal($taxSubtotal);
    }

    /**
     * Get TaxAmount value
     * @return TaxAmountType|null
     */
    public function getTaxAmount()
    {
        return $this->TaxAmount;
    }

    /**
     * Set TaxAmount value
     * @param TaxAmountType $taxAmount
     * @return TaxTotalType
     */
    public function setTaxAmount(TaxAmountType $taxAmount = null)
    {
        $this->TaxAmount = $taxAmount;
        return $this;
    }

    /**
     * Get TaxSubtotal value
     * @return TaxSubtotalType[]|null
     */
    public function getTaxSubtotal()
    {
        return $this->TaxSubtotal;
    }

    /**
     * This method is responsible for validating the values passed to the setTaxSubtotal method
     * This method is willingly generated in order to preserve the one-line inline validation within the setTaxSubtotal method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateTaxSubtotalForArrayConstraintsFromSetTaxSubtotal(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $taxTotalTypeTaxSubtotalItem) {
            // validation for constraint: itemType
            if (!$taxTotalTypeTaxSubtotalItem instanceof TaxSubtotalType) {
                $invalidValues[] = is_object($taxTotalTypeTaxSubtotalItem) ? get_class($taxTotalTypeTaxSubtotalItem) : sprintf('%s(%s)', gettype($taxTotalTypeTaxSubtotalItem), var_export($taxTotalTypeTaxSubtotalItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The TaxSubtotal property can only contain items of type \Gek\UyumBahceGet\StructType\TaxSubtotalType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }

    /**
     * Set TaxSubtotal value
     * @param TaxSubtotalType[] $taxSubtotal
     * @return TaxTotalType
     * @throws InvalidArgumentException
     */
    public function setTaxSubtotal(array $taxSubtotal = array())
    {
        // validation for constraint: array
        if ('' !== ($taxSubtotalArrayErrorMessage = self::validateTaxSubtotalForArrayConstraintsFromSetTaxSubtotal($taxSubtotal))) {
            throw new InvalidArgumentException($taxSubtotalArrayErrorMessage, __LINE__);
        }
        $this->TaxSubtotal = $taxSubtotal;
        return $this;
    }

    /**
     * Add item to TaxSubtotal value
     * @param TaxSubtotalType $item
     * @return TaxTotalType
     * @throws InvalidArgumentException
     */
    public function addToTaxSubtotal(TaxSubtotalType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof TaxSubtotalType) {
            throw new InvalidArgumentException(sprintf('The TaxSubtotal property can only contain items of type \Gek\UyumBahceGet\StructType\TaxSubtotalType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->TaxSubtotal[] = $item;
        return $this;
    }
}
