<?php

namespace Gek\UyumBahceGet\StructType;

use WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TaxSubtotalType StructType
 * @subpackage Structs
 */
class TaxSubtotalType extends AbstractStructBase
{
    /**
     * The TaxableAmount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: s4:TaxableAmount
     * @var TaxableAmountType
     */
    public $TaxableAmount;
    /**
     * The TaxAmount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: s4:TaxAmount
     * @var TaxAmountType
     */
    public $TaxAmount;
    /**
     * The CalculationSequenceNumeric
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: s4:CalculationSequenceNumeric
     * @var CalculationSequenceNumericType
     */
    public $CalculationSequenceNumeric;
    /**
     * The TransactionCurrencyTaxAmount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: s4:TransactionCurrencyTaxAmount
     * @var TransactionCurrencyTaxAmountType
     */
    public $TransactionCurrencyTaxAmount;
    /**
     * The Percent
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: s4:Percent
     * @var PercentType
     */
    public $Percent;
    /**
     * The BaseUnitMeasure
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: s4:BaseUnitMeasure
     * @var BaseUnitMeasureType
     */
    public $BaseUnitMeasure;
    /**
     * The PerUnitAmount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: s4:PerUnitAmount
     * @var PerUnitAmountType
     */
    public $PerUnitAmount;
    /**
     * The TaxCategory
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var TaxCategoryType
     */
    public $TaxCategory;

    /**
     * Constructor method for TaxSubtotalType
     * @param TaxableAmountType $taxableAmount
     * @param TaxAmountType $taxAmount
     * @param CalculationSequenceNumericType $calculationSequenceNumeric
     * @param TransactionCurrencyTaxAmountType $transactionCurrencyTaxAmount
     * @param PercentType $percent
     * @param BaseUnitMeasureType $baseUnitMeasure
     * @param PerUnitAmountType $perUnitAmount
     * @param TaxCategoryType $taxCategory
     * @uses TaxSubtotalType::setTaxableAmount()
     * @uses TaxSubtotalType::setTaxAmount()
     * @uses TaxSubtotalType::setCalculationSequenceNumeric()
     * @uses TaxSubtotalType::setTransactionCurrencyTaxAmount()
     * @uses TaxSubtotalType::setPercent()
     * @uses TaxSubtotalType::setBaseUnitMeasure()
     * @uses TaxSubtotalType::setPerUnitAmount()
     * @uses TaxSubtotalType::setTaxCategory()
     */
    public function __construct(TaxableAmountType $taxableAmount = null, TaxAmountType $taxAmount = null, CalculationSequenceNumericType $calculationSequenceNumeric = null, TransactionCurrencyTaxAmountType $transactionCurrencyTaxAmount = null, PercentType $percent = null, BaseUnitMeasureType $baseUnitMeasure = null, PerUnitAmountType $perUnitAmount = null, TaxCategoryType $taxCategory = null)
    {
        $this
            ->setTaxableAmount($taxableAmount)
            ->setTaxAmount($taxAmount)
            ->setCalculationSequenceNumeric($calculationSequenceNumeric)
            ->setTransactionCurrencyTaxAmount($transactionCurrencyTaxAmount)
            ->setPercent($percent)
            ->setBaseUnitMeasure($baseUnitMeasure)
            ->setPerUnitAmount($perUnitAmount)
            ->setTaxCategory($taxCategory);
    }

    /**
     * Get TaxableAmount value
     * @return TaxableAmountType|null
     */
    public function getTaxableAmount()
    {
        return $this->TaxableAmount;
    }

    /**
     * Set TaxableAmount value
     * @param TaxableAmountType $taxableAmount
     * @return TaxSubtotalType
     */
    public function setTaxableAmount(TaxableAmountType $taxableAmount = null)
    {
        $this->TaxableAmount = $taxableAmount;
        return $this;
    }

    /**
     * Get TaxAmount value
     * @return TaxAmountType|null
     */
    public function getTaxAmount()
    {
        return $this->TaxAmount;
    }

    /**
     * Set TaxAmount value
     * @param TaxAmountType $taxAmount
     * @return TaxSubtotalType
     */
    public function setTaxAmount(TaxAmountType $taxAmount = null)
    {
        $this->TaxAmount = $taxAmount;
        return $this;
    }

    /**
     * Get CalculationSequenceNumeric value
     * @return CalculationSequenceNumericType|null
     */
    public function getCalculationSequenceNumeric()
    {
        return $this->CalculationSequenceNumeric;
    }

    /**
     * Set CalculationSequenceNumeric value
     * @param CalculationSequenceNumericType $calculationSequenceNumeric
     * @return TaxSubtotalType
     */
    public function setCalculationSequenceNumeric(CalculationSequenceNumericType $calculationSequenceNumeric = null)
    {
        $this->CalculationSequenceNumeric = $calculationSequenceNumeric;
        return $this;
    }

    /**
     * Get TransactionCurrencyTaxAmount value
     * @return TransactionCurrencyTaxAmountType|null
     */
    public function getTransactionCurrencyTaxAmount()
    {
        return $this->TransactionCurrencyTaxAmount;
    }

    /**
     * Set TransactionCurrencyTaxAmount value
     * @param TransactionCurrencyTaxAmountType $transactionCurrencyTaxAmount
     * @return TaxSubtotalType
     */
    public function setTransactionCurrencyTaxAmount(TransactionCurrencyTaxAmountType $transactionCurrencyTaxAmount = null)
    {
        $this->TransactionCurrencyTaxAmount = $transactionCurrencyTaxAmount;
        return $this;
    }

    /**
     * Get Percent value
     * @return PercentType|null
     */
    public function getPercent()
    {
        return $this->Percent;
    }

    /**
     * Set Percent value
     * @param PercentType $percent
     * @return TaxSubtotalType
     */
    public function setPercent(PercentType $percent = null)
    {
        $this->Percent = $percent;
        return $this;
    }

    /**
     * Get BaseUnitMeasure value
     * @return BaseUnitMeasureType|null
     */
    public function getBaseUnitMeasure()
    {
        return $this->BaseUnitMeasure;
    }

    /**
     * Set BaseUnitMeasure value
     * @param BaseUnitMeasureType $baseUnitMeasure
     * @return TaxSubtotalType
     */
    public function setBaseUnitMeasure(BaseUnitMeasureType $baseUnitMeasure = null)
    {
        $this->BaseUnitMeasure = $baseUnitMeasure;
        return $this;
    }

    /**
     * Get PerUnitAmount value
     * @return PerUnitAmountType|null
     */
    public function getPerUnitAmount()
    {
        return $this->PerUnitAmount;
    }

    /**
     * Set PerUnitAmount value
     * @param PerUnitAmountType $perUnitAmount
     * @return TaxSubtotalType
     */
    public function setPerUnitAmount(PerUnitAmountType $perUnitAmount = null)
    {
        $this->PerUnitAmount = $perUnitAmount;
        return $this;
    }

    /**
     * Get TaxCategory value
     * @return TaxCategoryType|null
     */
    public function getTaxCategory()
    {
        return $this->TaxCategory;
    }

    /**
     * Set TaxCategory value
     * @param TaxCategoryType $taxCategory
     * @return TaxSubtotalType
     */
    public function setTaxCategory(TaxCategoryType $taxCategory = null)
    {
        $this->TaxCategory = $taxCategory;
        return $this;
    }
}
