<?php

namespace Gek\UyumBahceGet\StructType;

use WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TaxCategoryType StructType
 * @subpackage Structs
 */
class TaxCategoryType extends AbstractStructBase
{
    /**
     * The Name
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: s4:Name
     * @var NameType
     */
    public $Name;
    /**
     * The TaxExemptionReasonCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: s4:TaxExemptionReasonCode
     * @var TaxExemptionReasonCodeType
     */
    public $TaxExemptionReasonCode;
    /**
     * The TaxExemptionReason
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: s4:TaxExemptionReason
     * @var TaxExemptionReasonType
     */
    public $TaxExemptionReason;
    /**
     * The TaxScheme
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var TaxSchemeType
     */
    public $TaxScheme;

    /**
     * Constructor method for TaxCategoryType
     * @param NameType $name
     * @param TaxExemptionReasonCodeType $taxExemptionReasonCode
     * @param TaxExemptionReasonType $taxExemptionReason
     * @param TaxSchemeType $taxScheme
     * @uses TaxCategoryType::setName()
     * @uses TaxCategoryType::setTaxExemptionReasonCode()
     * @uses TaxCategoryType::setTaxExemptionReason()
     * @uses TaxCategoryType::setTaxScheme()
     */
    public function __construct(NameType $name = null, TaxExemptionReasonCodeType $taxExemptionReasonCode = null, TaxExemptionReasonType $taxExemptionReason = null, TaxSchemeType $taxScheme = null)
    {
        $this
            ->setName($name)
            ->setTaxExemptionReasonCode($taxExemptionReasonCode)
            ->setTaxExemptionReason($taxExemptionReason)
            ->setTaxScheme($taxScheme);
    }

    /**
     * Get Name value
     * @return NameType|null
     */
    public function getName()
    {
        return $this->Name;
    }

    /**
     * Set Name value
     * @param NameType $name
     * @return TaxCategoryType
     */
    public function setName(NameType $name = null)
    {
        $this->Name = $name;
        return $this;
    }

    /**
     * Get TaxExemptionReasonCode value
     * @return TaxExemptionReasonCodeType|null
     */
    public function getTaxExemptionReasonCode()
    {
        return $this->TaxExemptionReasonCode;
    }

    /**
     * Set TaxExemptionReasonCode value
     * @param TaxExemptionReasonCodeType $taxExemptionReasonCode
     * @return TaxCategoryType
     */
    public function setTaxExemptionReasonCode(TaxExemptionReasonCodeType $taxExemptionReasonCode = null)
    {
        $this->TaxExemptionReasonCode = $taxExemptionReasonCode;
        return $this;
    }

    /**
     * Get TaxExemptionReason value
     * @return TaxExemptionReasonType|null
     */
    public function getTaxExemptionReason()
    {
        return $this->TaxExemptionReason;
    }

    /**
     * Set TaxExemptionReason value
     * @param TaxExemptionReasonType $taxExemptionReason
     * @return TaxCategoryType
     */
    public function setTaxExemptionReason(TaxExemptionReasonType $taxExemptionReason = null)
    {
        $this->TaxExemptionReason = $taxExemptionReason;
        return $this;
    }

    /**
     * Get TaxScheme value
     * @return TaxSchemeType|null
     */
    public function getTaxScheme()
    {
        return $this->TaxScheme;
    }

    /**
     * Set TaxScheme value
     * @param TaxSchemeType $taxScheme
     * @return TaxCategoryType
     */
    public function setTaxScheme(TaxSchemeType $taxScheme = null)
    {
        $this->TaxScheme = $taxScheme;
        return $this;
    }
}
