<?php

namespace Gek\UyumBahceGet\StructType;

use Gek\UyumBahceGet\ArrayType\ArrayOfWhereClause;
use InvalidArgumentException;
use WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TableInfoIn StructType
 * @subpackage Structs
 */
class TableInfoIn extends AbstractStructBase
{
    /**
     * The TableName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $TableName;
    /**
     * The WhereClauseList
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var ArrayOfWhereClause
     */
    public $WhereClauseList;

    /**
     * Constructor method for TableInfoIn
     * @param string $tableName
     * @param ArrayOfWhereClause $whereClauseList
     * @uses TableInfoIn::setTableName()
     * @uses TableInfoIn::setWhereClauseList()
     */
    public function __construct($tableName = null, ArrayOfWhereClause $whereClauseList = null)
    {
        $this
            ->setTableName($tableName)
            ->setWhereClauseList($whereClauseList);
    }

    /**
     * Get TableName value
     * @return string|null
     */
    public function getTableName()
    {
        return $this->TableName;
    }

    /**
     * Set TableName value
     * @param string $tableName
     * @return TableInfoIn
     */
    public function setTableName($tableName = null)
    {
        // validation for constraint: string
        if (!is_null($tableName) && !is_string($tableName)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($tableName, true), gettype($tableName)), __LINE__);
        }
        $this->TableName = $tableName;
        return $this;
    }

    /**
     * Get WhereClauseList value
     * @return ArrayOfWhereClause|null
     */
    public function getWhereClauseList()
    {
        return $this->WhereClauseList;
    }

    /**
     * Set WhereClauseList value
     * @param ArrayOfWhereClause $whereClauseList
     * @return TableInfoIn
     */
    public function setWhereClauseList(ArrayOfWhereClause $whereClauseList = null)
    {
        $this->WhereClauseList = $whereClauseList;
        return $this;
    }
}
