<?php

namespace Gek\UyumBahceGet\StructType;

use InvalidArgumentException;
use WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SystemUserWithAlias StructType
 * @subpackage Structs
 */
class SystemUserWithAlias extends AbstractStructBase
{
    /**
     * The Definition
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var SystemUserDefinition
     */
    public $Definition;
    /**
     * The ReceiverboxAliases
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var SystemUserAlias[]
     */
    public $ReceiverboxAliases;
    /**
     * The SenderboxAliases
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var SystemUserAlias[]
     */
    public $SenderboxAliases;
    /**
     * The DespatchReceiverboxAliases
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var SystemUserAlias[]
     */
    public $DespatchReceiverboxAliases;
    /**
     * The DespatchSenderboxAliases
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var SystemUserAlias[]
     */
    public $DespatchSenderboxAliases;

    /**
     * Constructor method for SystemUserWithAlias
     * @param SystemUserDefinition $definition
     * @param SystemUserAlias[] $receiverboxAliases
     * @param SystemUserAlias[] $senderboxAliases
     * @param SystemUserAlias[] $despatchReceiverboxAliases
     * @param SystemUserAlias[] $despatchSenderboxAliases
     * @uses SystemUserWithAlias::setDefinition()
     * @uses SystemUserWithAlias::setReceiverboxAliases()
     * @uses SystemUserWithAlias::setSenderboxAliases()
     * @uses SystemUserWithAlias::setDespatchReceiverboxAliases()
     * @uses SystemUserWithAlias::setDespatchSenderboxAliases()
     */
    public function __construct(SystemUserDefinition $definition = null, array $receiverboxAliases = array(), array $senderboxAliases = array(), array $despatchReceiverboxAliases = array(), array $despatchSenderboxAliases = array())
    {
        $this
            ->setDefinition($definition)
            ->setReceiverboxAliases($receiverboxAliases)
            ->setSenderboxAliases($senderboxAliases)
            ->setDespatchReceiverboxAliases($despatchReceiverboxAliases)
            ->setDespatchSenderboxAliases($despatchSenderboxAliases);
    }

    /**
     * Get Definition value
     * @return SystemUserDefinition|null
     */
    public function getDefinition()
    {
        return $this->Definition;
    }

    /**
     * Set Definition value
     * @param SystemUserDefinition $definition
     * @return SystemUserWithAlias
     */
    public function setDefinition(SystemUserDefinition $definition = null)
    {
        $this->Definition = $definition;
        return $this;
    }

    /**
     * Get ReceiverboxAliases value
     * @return SystemUserAlias[]|null
     */
    public function getReceiverboxAliases()
    {
        return $this->ReceiverboxAliases;
    }

    /**
     * This method is responsible for validating the values passed to the setReceiverboxAliases method
     * This method is willingly generated in order to preserve the one-line inline validation within the setReceiverboxAliases method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateReceiverboxAliasesForArrayConstraintsFromSetReceiverboxAliases(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $systemUserWithAliasReceiverboxAliasesItem) {
            // validation for constraint: itemType
            if (!$systemUserWithAliasReceiverboxAliasesItem instanceof SystemUserAlias) {
                $invalidValues[] = is_object($systemUserWithAliasReceiverboxAliasesItem) ? get_class($systemUserWithAliasReceiverboxAliasesItem) : sprintf('%s(%s)', gettype($systemUserWithAliasReceiverboxAliasesItem), var_export($systemUserWithAliasReceiverboxAliasesItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The ReceiverboxAliases property can only contain items of type \Gek\UyumBahceGet\StructType\SystemUserAlias, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }

    /**
     * Set ReceiverboxAliases value
     * @param SystemUserAlias[] $receiverboxAliases
     * @return SystemUserWithAlias
     * @throws InvalidArgumentException
     */
    public function setReceiverboxAliases(array $receiverboxAliases = array())
    {
        // validation for constraint: array
        if ('' !== ($receiverboxAliasesArrayErrorMessage = self::validateReceiverboxAliasesForArrayConstraintsFromSetReceiverboxAliases($receiverboxAliases))) {
            throw new InvalidArgumentException($receiverboxAliasesArrayErrorMessage, __LINE__);
        }
        $this->ReceiverboxAliases = $receiverboxAliases;
        return $this;
    }

    /**
     * Add item to ReceiverboxAliases value
     * @param SystemUserAlias $item
     * @return SystemUserWithAlias
     * @throws InvalidArgumentException
     */
    public function addToReceiverboxAliases(SystemUserAlias $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof SystemUserAlias) {
            throw new InvalidArgumentException(sprintf('The ReceiverboxAliases property can only contain items of type \Gek\UyumBahceGet\StructType\SystemUserAlias, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->ReceiverboxAliases[] = $item;
        return $this;
    }

    /**
     * Get SenderboxAliases value
     * @return SystemUserAlias[]|null
     */
    public function getSenderboxAliases()
    {
        return $this->SenderboxAliases;
    }

    /**
     * This method is responsible for validating the values passed to the setSenderboxAliases method
     * This method is willingly generated in order to preserve the one-line inline validation within the setSenderboxAliases method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateSenderboxAliasesForArrayConstraintsFromSetSenderboxAliases(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $systemUserWithAliasSenderboxAliasesItem) {
            // validation for constraint: itemType
            if (!$systemUserWithAliasSenderboxAliasesItem instanceof SystemUserAlias) {
                $invalidValues[] = is_object($systemUserWithAliasSenderboxAliasesItem) ? get_class($systemUserWithAliasSenderboxAliasesItem) : sprintf('%s(%s)', gettype($systemUserWithAliasSenderboxAliasesItem), var_export($systemUserWithAliasSenderboxAliasesItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The SenderboxAliases property can only contain items of type \Gek\UyumBahceGet\StructType\SystemUserAlias, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }

    /**
     * Set SenderboxAliases value
     * @param SystemUserAlias[] $senderboxAliases
     * @return SystemUserWithAlias
     * @throws InvalidArgumentException
     */
    public function setSenderboxAliases(array $senderboxAliases = array())
    {
        // validation for constraint: array
        if ('' !== ($senderboxAliasesArrayErrorMessage = self::validateSenderboxAliasesForArrayConstraintsFromSetSenderboxAliases($senderboxAliases))) {
            throw new InvalidArgumentException($senderboxAliasesArrayErrorMessage, __LINE__);
        }
        $this->SenderboxAliases = $senderboxAliases;
        return $this;
    }

    /**
     * Add item to SenderboxAliases value
     * @param SystemUserAlias $item
     * @return SystemUserWithAlias
     * @throws InvalidArgumentException
     */
    public function addToSenderboxAliases(SystemUserAlias $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof SystemUserAlias) {
            throw new InvalidArgumentException(sprintf('The SenderboxAliases property can only contain items of type \Gek\UyumBahceGet\StructType\SystemUserAlias, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->SenderboxAliases[] = $item;
        return $this;
    }

    /**
     * Get DespatchReceiverboxAliases value
     * @return SystemUserAlias[]|null
     */
    public function getDespatchReceiverboxAliases()
    {
        return $this->DespatchReceiverboxAliases;
    }

    /**
     * This method is responsible for validating the values passed to the setDespatchReceiverboxAliases method
     * This method is willingly generated in order to preserve the one-line inline validation within the setDespatchReceiverboxAliases method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateDespatchReceiverboxAliasesForArrayConstraintsFromSetDespatchReceiverboxAliases(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $systemUserWithAliasDespatchReceiverboxAliasesItem) {
            // validation for constraint: itemType
            if (!$systemUserWithAliasDespatchReceiverboxAliasesItem instanceof SystemUserAlias) {
                $invalidValues[] = is_object($systemUserWithAliasDespatchReceiverboxAliasesItem) ? get_class($systemUserWithAliasDespatchReceiverboxAliasesItem) : sprintf('%s(%s)', gettype($systemUserWithAliasDespatchReceiverboxAliasesItem), var_export($systemUserWithAliasDespatchReceiverboxAliasesItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The DespatchReceiverboxAliases property can only contain items of type \Gek\UyumBahceGet\StructType\SystemUserAlias, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }

    /**
     * Set DespatchReceiverboxAliases value
     * @param SystemUserAlias[] $despatchReceiverboxAliases
     * @return SystemUserWithAlias
     * @throws InvalidArgumentException
     */
    public function setDespatchReceiverboxAliases(array $despatchReceiverboxAliases = array())
    {
        // validation for constraint: array
        if ('' !== ($despatchReceiverboxAliasesArrayErrorMessage = self::validateDespatchReceiverboxAliasesForArrayConstraintsFromSetDespatchReceiverboxAliases($despatchReceiverboxAliases))) {
            throw new InvalidArgumentException($despatchReceiverboxAliasesArrayErrorMessage, __LINE__);
        }
        $this->DespatchReceiverboxAliases = $despatchReceiverboxAliases;
        return $this;
    }

    /**
     * Add item to DespatchReceiverboxAliases value
     * @param SystemUserAlias $item
     * @return SystemUserWithAlias
     * @throws InvalidArgumentException
     */
    public function addToDespatchReceiverboxAliases(SystemUserAlias $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof SystemUserAlias) {
            throw new InvalidArgumentException(sprintf('The DespatchReceiverboxAliases property can only contain items of type \Gek\UyumBahceGet\StructType\SystemUserAlias, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->DespatchReceiverboxAliases[] = $item;
        return $this;
    }

    /**
     * Get DespatchSenderboxAliases value
     * @return SystemUserAlias[]|null
     */
    public function getDespatchSenderboxAliases()
    {
        return $this->DespatchSenderboxAliases;
    }

    /**
     * This method is responsible for validating the values passed to the setDespatchSenderboxAliases method
     * This method is willingly generated in order to preserve the one-line inline validation within the setDespatchSenderboxAliases method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateDespatchSenderboxAliasesForArrayConstraintsFromSetDespatchSenderboxAliases(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $systemUserWithAliasDespatchSenderboxAliasesItem) {
            // validation for constraint: itemType
            if (!$systemUserWithAliasDespatchSenderboxAliasesItem instanceof SystemUserAlias) {
                $invalidValues[] = is_object($systemUserWithAliasDespatchSenderboxAliasesItem) ? get_class($systemUserWithAliasDespatchSenderboxAliasesItem) : sprintf('%s(%s)', gettype($systemUserWithAliasDespatchSenderboxAliasesItem), var_export($systemUserWithAliasDespatchSenderboxAliasesItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The DespatchSenderboxAliases property can only contain items of type \Gek\UyumBahceGet\StructType\SystemUserAlias, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }

    /**
     * Set DespatchSenderboxAliases value
     * @param SystemUserAlias[] $despatchSenderboxAliases
     * @return SystemUserWithAlias
     * @throws InvalidArgumentException
     */
    public function setDespatchSenderboxAliases(array $despatchSenderboxAliases = array())
    {
        // validation for constraint: array
        if ('' !== ($despatchSenderboxAliasesArrayErrorMessage = self::validateDespatchSenderboxAliasesForArrayConstraintsFromSetDespatchSenderboxAliases($despatchSenderboxAliases))) {
            throw new InvalidArgumentException($despatchSenderboxAliasesArrayErrorMessage, __LINE__);
        }
        $this->DespatchSenderboxAliases = $despatchSenderboxAliases;
        return $this;
    }

    /**
     * Add item to DespatchSenderboxAliases value
     * @param SystemUserAlias $item
     * @return SystemUserWithAlias
     * @throws InvalidArgumentException
     */
    public function addToDespatchSenderboxAliases(SystemUserAlias $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof SystemUserAlias) {
            throw new InvalidArgumentException(sprintf('The DespatchSenderboxAliases property can only contain items of type \Gek\UyumBahceGet\StructType\SystemUserAlias, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->DespatchSenderboxAliases[] = $item;
        return $this;
    }
}
