<?php

namespace Gek\UyumBahceGet\StructType;

use InvalidArgumentException;

/**
 * This class stands for SystemUserAlias StructType
 * @subpackage Structs
 */
class SystemUserAlias extends EntityBaseInt
{
    /**
     * The Type
     * Meta information extracted from the WSDL
     * - use: required
     * @var int
     */
    public $Type;
    /**
     * The Enabled
     * Meta information extracted from the WSDL
     * - use: required
     * @var bool
     */
    public $Enabled;
    /**
     * The Alias
     * @var string
     */
    public $Alias;
    /**
     * The SystemCreateDate
     * @var string
     */
    public $SystemCreateDate;
    /**
     * The SystemDeleteDate
     * @var string
     */
    public $SystemDeleteDate;

    /**
     * Constructor method for SystemUserAlias
     * @param int $type
     * @param bool $enabled
     * @param string $alias
     * @param string $systemCreateDate
     * @param string $systemDeleteDate
     * @uses SystemUserAlias::setType()
     * @uses SystemUserAlias::setEnabled()
     * @uses SystemUserAlias::setAlias()
     * @uses SystemUserAlias::setSystemCreateDate()
     * @uses SystemUserAlias::setSystemDeleteDate()
     */
    public function __construct($type = null, $enabled = null, $alias = null, $systemCreateDate = null, $systemDeleteDate = null)
    {
        $this
            ->setType($type)
            ->setEnabled($enabled)
            ->setAlias($alias)
            ->setSystemCreateDate($systemCreateDate)
            ->setSystemDeleteDate($systemDeleteDate);
    }

    /**
     * Get Type value
     * @return int
     */
    public function getType()
    {
        return $this->Type;
    }

    /**
     * Set Type value
     * @param int $type
     * @return SystemUserAlias
     */
    public function setType($type = null)
    {
        // validation for constraint: int
        if (!is_null($type) && !(is_int($type) || ctype_digit($type))) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($type, true), gettype($type)), __LINE__);
        }
        $this->Type = $type;
        return $this;
    }

    /**
     * Get Enabled value
     * @return bool
     */
    public function getEnabled()
    {
        return $this->Enabled;
    }

    /**
     * Set Enabled value
     * @param bool $enabled
     * @return SystemUserAlias
     */
    public function setEnabled($enabled = null)
    {
        // validation for constraint: boolean
        if (!is_null($enabled) && !is_bool($enabled)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($enabled, true), gettype($enabled)), __LINE__);
        }
        $this->Enabled = $enabled;
        return $this;
    }

    /**
     * Get Alias value
     * @return string|null
     */
    public function getAlias()
    {
        return $this->Alias;
    }

    /**
     * Set Alias value
     * @param string $alias
     * @return SystemUserAlias
     */
    public function setAlias($alias = null)
    {
        // validation for constraint: string
        if (!is_null($alias) && !is_string($alias)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($alias, true), gettype($alias)), __LINE__);
        }
        $this->Alias = $alias;
        return $this;
    }

    /**
     * Get SystemCreateDate value
     * @return string|null
     */
    public function getSystemCreateDate()
    {
        return $this->SystemCreateDate;
    }

    /**
     * Set SystemCreateDate value
     * @param string $systemCreateDate
     * @return SystemUserAlias
     */
    public function setSystemCreateDate($systemCreateDate = null)
    {
        // validation for constraint: string
        if (!is_null($systemCreateDate) && !is_string($systemCreateDate)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($systemCreateDate, true), gettype($systemCreateDate)), __LINE__);
        }
        $this->SystemCreateDate = $systemCreateDate;
        return $this;
    }

    /**
     * Get SystemDeleteDate value
     * @return string|null
     */
    public function getSystemDeleteDate()
    {
        return $this->SystemDeleteDate;
    }

    /**
     * Set SystemDeleteDate value
     * @param string $systemDeleteDate
     * @return SystemUserAlias
     */
    public function setSystemDeleteDate($systemDeleteDate = null)
    {
        // validation for constraint: string
        if (!is_null($systemDeleteDate) && !is_string($systemDeleteDate)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($systemDeleteDate, true), gettype($systemDeleteDate)), __LINE__);
        }
        $this->SystemDeleteDate = $systemDeleteDate;
        return $this;
    }
}
