<?php

namespace Gek\UyumBahceGet\StructType;

use InvalidArgumentException;

/**
 * This class stands for SystemUser StructType
 * @subpackage Structs
 */
class SystemUser extends EntityUpdatedHistory
{
    /**
     * The Enabled
     * Meta information extracted from the WSDL
     * - use: required
     * @var bool
     */
    public $Enabled;
    /**
     * The Identifier
     * @var string
     */
    public $Identifier;
    /**
     * The PostboxAlias
     * @var string
     */
    public $PostboxAlias;
    /**
     * The SenderboxAlias
     * @var string
     */
    public $SenderboxAlias;
    /**
     * The Title
     * @var string
     */
    public $Title;
    /**
     * The Type
     * @var string
     */
    public $Type;
    /**
     * The SystemCreateDate
     * @var string
     */
    public $SystemCreateDate;
    /**
     * The FirstCreateDate
     * @var string
     */
    public $FirstCreateDate;

    /**
     * Constructor method for SystemUser
     * @param bool $enabled
     * @param string $identifier
     * @param string $postboxAlias
     * @param string $senderboxAlias
     * @param string $title
     * @param string $type
     * @param string $systemCreateDate
     * @param string $firstCreateDate
     * @uses SystemUser::setEnabled()
     * @uses SystemUser::setIdentifier()
     * @uses SystemUser::setPostboxAlias()
     * @uses SystemUser::setSenderboxAlias()
     * @uses SystemUser::setTitle()
     * @uses SystemUser::setType()
     * @uses SystemUser::setSystemCreateDate()
     * @uses SystemUser::setFirstCreateDate()
     */
    public function __construct($enabled = null, $identifier = null, $postboxAlias = null, $senderboxAlias = null, $title = null, $type = null, $systemCreateDate = null, $firstCreateDate = null)
    {
        $this
            ->setEnabled($enabled)
            ->setIdentifier($identifier)
            ->setPostboxAlias($postboxAlias)
            ->setSenderboxAlias($senderboxAlias)
            ->setTitle($title)
            ->setType($type)
            ->setSystemCreateDate($systemCreateDate)
            ->setFirstCreateDate($firstCreateDate);
    }

    /**
     * Get Enabled value
     * @return bool
     */
    public function getEnabled()
    {
        return $this->Enabled;
    }

    /**
     * Set Enabled value
     * @param bool $enabled
     * @return SystemUser
     */
    public function setEnabled($enabled = null)
    {
        // validation for constraint: boolean
        if (!is_null($enabled) && !is_bool($enabled)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($enabled, true), gettype($enabled)), __LINE__);
        }
        $this->Enabled = $enabled;
        return $this;
    }

    /**
     * Get Identifier value
     * @return string|null
     */
    public function getIdentifier()
    {
        return $this->Identifier;
    }

    /**
     * Set Identifier value
     * @param string $identifier
     * @return SystemUser
     */
    public function setIdentifier($identifier = null)
    {
        // validation for constraint: string
        if (!is_null($identifier) && !is_string($identifier)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($identifier, true), gettype($identifier)), __LINE__);
        }
        $this->Identifier = $identifier;
        return $this;
    }

    /**
     * Get PostboxAlias value
     * @return string|null
     */
    public function getPostboxAlias()
    {
        return $this->PostboxAlias;
    }

    /**
     * Set PostboxAlias value
     * @param string $postboxAlias
     * @return SystemUser
     */
    public function setPostboxAlias($postboxAlias = null)
    {
        // validation for constraint: string
        if (!is_null($postboxAlias) && !is_string($postboxAlias)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($postboxAlias, true), gettype($postboxAlias)), __LINE__);
        }
        $this->PostboxAlias = $postboxAlias;
        return $this;
    }

    /**
     * Get SenderboxAlias value
     * @return string|null
     */
    public function getSenderboxAlias()
    {
        return $this->SenderboxAlias;
    }

    /**
     * Set SenderboxAlias value
     * @param string $senderboxAlias
     * @return SystemUser
     */
    public function setSenderboxAlias($senderboxAlias = null)
    {
        // validation for constraint: string
        if (!is_null($senderboxAlias) && !is_string($senderboxAlias)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($senderboxAlias, true), gettype($senderboxAlias)), __LINE__);
        }
        $this->SenderboxAlias = $senderboxAlias;
        return $this;
    }

    /**
     * Get Title value
     * @return string|null
     */
    public function getTitle()
    {
        return $this->Title;
    }

    /**
     * Set Title value
     * @param string $title
     * @return SystemUser
     */
    public function setTitle($title = null)
    {
        // validation for constraint: string
        if (!is_null($title) && !is_string($title)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($title, true), gettype($title)), __LINE__);
        }
        $this->Title = $title;
        return $this;
    }

    /**
     * Get Type value
     * @return string|null
     */
    public function getType()
    {
        return $this->Type;
    }

    /**
     * Set Type value
     * @param string $type
     * @return SystemUser
     */
    public function setType($type = null)
    {
        // validation for constraint: string
        if (!is_null($type) && !is_string($type)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($type, true), gettype($type)), __LINE__);
        }
        $this->Type = $type;
        return $this;
    }

    /**
     * Get SystemCreateDate value
     * @return string|null
     */
    public function getSystemCreateDate()
    {
        return $this->SystemCreateDate;
    }

    /**
     * Set SystemCreateDate value
     * @param string $systemCreateDate
     * @return SystemUser
     */
    public function setSystemCreateDate($systemCreateDate = null)
    {
        // validation for constraint: string
        if (!is_null($systemCreateDate) && !is_string($systemCreateDate)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($systemCreateDate, true), gettype($systemCreateDate)), __LINE__);
        }
        $this->SystemCreateDate = $systemCreateDate;
        return $this;
    }

    /**
     * Get FirstCreateDate value
     * @return string|null
     */
    public function getFirstCreateDate()
    {
        return $this->FirstCreateDate;
    }

    /**
     * Set FirstCreateDate value
     * @param string $firstCreateDate
     * @return SystemUser
     */
    public function setFirstCreateDate($firstCreateDate = null)
    {
        // validation for constraint: string
        if (!is_null($firstCreateDate) && !is_string($firstCreateDate)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($firstCreateDate, true), gettype($firstCreateDate)), __LINE__);
        }
        $this->FirstCreateDate = $firstCreateDate;
        return $this;
    }
}
