<?php

namespace Gek\UyumBahceGet\StructType;

use InvalidArgumentException;
use WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for StowageType StructType
 * @subpackage Structs
 */
class StowageType extends AbstractStructBase
{
    /**
     * The LocationID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: s4:LocationID
     * @var LocationIDType
     */
    public $LocationID;
    /**
     * The Location
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - ref: s4:Location
     * @var LocationType[]
     */
    public $Location;
    /**
     * The MeasurementDimension
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var DimensionType[]
     */
    public $MeasurementDimension;

    /**
     * Constructor method for StowageType
     * @param LocationIDType $locationID
     * @param LocationType[] $location
     * @param DimensionType[] $measurementDimension
     * @uses StowageType::setLocationID()
     * @uses StowageType::setLocation()
     * @uses StowageType::setMeasurementDimension()
     */
    public function __construct(LocationIDType $locationID = null, array $location = array(), array $measurementDimension = array())
    {
        $this
            ->setLocationID($locationID)
            ->setLocation($location)
            ->setMeasurementDimension($measurementDimension);
    }

    /**
     * Get LocationID value
     * @return LocationIDType|null
     */
    public function getLocationID()
    {
        return $this->LocationID;
    }

    /**
     * Set LocationID value
     * @param LocationIDType $locationID
     * @return StowageType
     */
    public function setLocationID(LocationIDType $locationID = null)
    {
        $this->LocationID = $locationID;
        return $this;
    }

    /**
     * Get Location value
     * @return LocationType[]|null
     */
    public function getLocation()
    {
        return $this->Location;
    }

    /**
     * This method is responsible for validating the values passed to the setLocation method
     * This method is willingly generated in order to preserve the one-line inline validation within the setLocation method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateLocationForArrayConstraintsFromSetLocation(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $stowageTypeLocationItem) {
            // validation for constraint: itemType
            if (!$stowageTypeLocationItem instanceof LocationType) {
                $invalidValues[] = is_object($stowageTypeLocationItem) ? get_class($stowageTypeLocationItem) : sprintf('%s(%s)', gettype($stowageTypeLocationItem), var_export($stowageTypeLocationItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Location property can only contain items of type \Gek\UyumBahceGet\StructType\LocationType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }

    /**
     * Set Location value
     * @param LocationType[] $location
     * @return StowageType
     * @throws InvalidArgumentException
     */
    public function setLocation(array $location = array())
    {
        // validation for constraint: array
        if ('' !== ($locationArrayErrorMessage = self::validateLocationForArrayConstraintsFromSetLocation($location))) {
            throw new InvalidArgumentException($locationArrayErrorMessage, __LINE__);
        }
        $this->Location = $location;
        return $this;
    }

    /**
     * Add item to Location value
     * @param LocationType $item
     * @return StowageType
     * @throws InvalidArgumentException
     */
    public function addToLocation(LocationType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof LocationType) {
            throw new InvalidArgumentException(sprintf('The Location property can only contain items of type \Gek\UyumBahceGet\StructType\LocationType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Location[] = $item;
        return $this;
    }

    /**
     * Get MeasurementDimension value
     * @return DimensionType[]|null
     */
    public function getMeasurementDimension()
    {
        return $this->MeasurementDimension;
    }

    /**
     * This method is responsible for validating the values passed to the setMeasurementDimension method
     * This method is willingly generated in order to preserve the one-line inline validation within the setMeasurementDimension method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateMeasurementDimensionForArrayConstraintsFromSetMeasurementDimension(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $stowageTypeMeasurementDimensionItem) {
            // validation for constraint: itemType
            if (!$stowageTypeMeasurementDimensionItem instanceof DimensionType) {
                $invalidValues[] = is_object($stowageTypeMeasurementDimensionItem) ? get_class($stowageTypeMeasurementDimensionItem) : sprintf('%s(%s)', gettype($stowageTypeMeasurementDimensionItem), var_export($stowageTypeMeasurementDimensionItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The MeasurementDimension property can only contain items of type \Gek\UyumBahceGet\StructType\DimensionType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }

    /**
     * Set MeasurementDimension value
     * @param DimensionType[] $measurementDimension
     * @return StowageType
     * @throws InvalidArgumentException
     */
    public function setMeasurementDimension(array $measurementDimension = array())
    {
        // validation for constraint: array
        if ('' !== ($measurementDimensionArrayErrorMessage = self::validateMeasurementDimensionForArrayConstraintsFromSetMeasurementDimension($measurementDimension))) {
            throw new InvalidArgumentException($measurementDimensionArrayErrorMessage, __LINE__);
        }
        $this->MeasurementDimension = $measurementDimension;
        return $this;
    }

    /**
     * Add item to MeasurementDimension value
     * @param DimensionType $item
     * @return StowageType
     * @throws InvalidArgumentException
     */
    public function addToMeasurementDimension(DimensionType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof DimensionType) {
            throw new InvalidArgumentException(sprintf('The MeasurementDimension property can only contain items of type \Gek\UyumBahceGet\StructType\DimensionType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->MeasurementDimension[] = $item;
        return $this;
    }
}
