<?php

namespace Gek\UyumBahceGet\StructType;

use InvalidArgumentException;
use WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SrvItemLang StructType
 * @subpackage Structs
 */
class SrvItemLang extends AbstractStructBase
{
    /**
     * The Id
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $Id;
    /**
     * The ItemId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $ItemId;
    /**
     * The LangId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $LangId;
    /**
     * The ItemName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ItemName;
    /**
     * The ItemName2
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ItemName2;
    /**
     * The Description
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Description;
    /**
     * The LangCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $LangCode;

    /**
     * Constructor method for SrvItemLang
     * @param int $id
     * @param int $itemId
     * @param int $langId
     * @param string $itemName
     * @param string $itemName2
     * @param string $description
     * @param string $langCode
     * @uses SrvItemLang::setId()
     * @uses SrvItemLang::setItemId()
     * @uses SrvItemLang::setLangId()
     * @uses SrvItemLang::setItemName()
     * @uses SrvItemLang::setItemName2()
     * @uses SrvItemLang::setDescription()
     * @uses SrvItemLang::setLangCode()
     */
    public function __construct($id = null, $itemId = null, $langId = null, $itemName = null, $itemName2 = null, $description = null, $langCode = null)
    {
        $this
            ->setId($id)
            ->setItemId($itemId)
            ->setLangId($langId)
            ->setItemName($itemName)
            ->setItemName2($itemName2)
            ->setDescription($description)
            ->setLangCode($langCode);
    }

    /**
     * Get Id value
     * @return int
     */
    public function getId()
    {
        return $this->Id;
    }

    /**
     * Set Id value
     * @param int $id
     * @return SrvItemLang
     */
    public function setId($id = null)
    {
        // validation for constraint: int
        if (!is_null($id) && !(is_int($id) || ctype_digit($id))) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($id, true), gettype($id)), __LINE__);
        }
        $this->Id = $id;
        return $this;
    }

    /**
     * Get ItemId value
     * @return int
     */
    public function getItemId()
    {
        return $this->ItemId;
    }

    /**
     * Set ItemId value
     * @param int $itemId
     * @return SrvItemLang
     */
    public function setItemId($itemId = null)
    {
        // validation for constraint: int
        if (!is_null($itemId) && !(is_int($itemId) || ctype_digit($itemId))) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($itemId, true), gettype($itemId)), __LINE__);
        }
        $this->ItemId = $itemId;
        return $this;
    }

    /**
     * Get LangId value
     * @return int
     */
    public function getLangId()
    {
        return $this->LangId;
    }

    /**
     * Set LangId value
     * @param int $langId
     * @return SrvItemLang
     */
    public function setLangId($langId = null)
    {
        // validation for constraint: int
        if (!is_null($langId) && !(is_int($langId) || ctype_digit($langId))) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($langId, true), gettype($langId)), __LINE__);
        }
        $this->LangId = $langId;
        return $this;
    }

    /**
     * Get ItemName value
     * @return string|null
     */
    public function getItemName()
    {
        return $this->ItemName;
    }

    /**
     * Set ItemName value
     * @param string $itemName
     * @return SrvItemLang
     */
    public function setItemName($itemName = null)
    {
        // validation for constraint: string
        if (!is_null($itemName) && !is_string($itemName)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($itemName, true), gettype($itemName)), __LINE__);
        }
        $this->ItemName = $itemName;
        return $this;
    }

    /**
     * Get ItemName2 value
     * @return string|null
     */
    public function getItemName2()
    {
        return $this->ItemName2;
    }

    /**
     * Set ItemName2 value
     * @param string $itemName2
     * @return SrvItemLang
     */
    public function setItemName2($itemName2 = null)
    {
        // validation for constraint: string
        if (!is_null($itemName2) && !is_string($itemName2)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($itemName2, true), gettype($itemName2)), __LINE__);
        }
        $this->ItemName2 = $itemName2;
        return $this;
    }

    /**
     * Get Description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->Description;
    }

    /**
     * Set Description value
     * @param string $description
     * @return SrvItemLang
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($description, true), gettype($description)), __LINE__);
        }
        $this->Description = $description;
        return $this;
    }

    /**
     * Get LangCode value
     * @return string|null
     */
    public function getLangCode()
    {
        return $this->LangCode;
    }

    /**
     * Set LangCode value
     * @param string $langCode
     * @return SrvItemLang
     */
    public function setLangCode($langCode = null)
    {
        // validation for constraint: string
        if (!is_null($langCode) && !is_string($langCode)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($langCode, true), gettype($langCode)), __LINE__);
        }
        $this->LangCode = $langCode;
        return $this;
    }
}
