<?php

namespace Gek\UyumBahceGet\StructType;

use Gek\UyumBahceGet\ArrayType\ArrayOfDicKeyValues;
use InvalidArgumentException;
use WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SrvItemEditor StructType
 * @subpackage Structs
 */
class SrvItemEditor extends AbstractStructBase
{
    /**
     * The Id
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $Id;
    /**
     * The ItemId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $ItemId;
    /**
     * The LangId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $LangId;
    /**
     * The ItemEditorDesc
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ItemEditorDesc;
    /**
     * The ItemCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ItemCode;
    /**
     * The ItemName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ItemName;
    /**
     * The LangCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $LangCode;
    /**
     * The Description
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Description;
    /**
     * The dynamicValues
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var ArrayOfDicKeyValues
     */
    public $dynamicValues;

    /**
     * Constructor method for SrvItemEditor
     * @param int $id
     * @param int $itemId
     * @param int $langId
     * @param string $itemEditorDesc
     * @param string $itemCode
     * @param string $itemName
     * @param string $langCode
     * @param string $description
     * @param ArrayOfDicKeyValues $dynamicValues
     * @uses SrvItemEditor::setId()
     * @uses SrvItemEditor::setItemId()
     * @uses SrvItemEditor::setLangId()
     * @uses SrvItemEditor::setItemEditorDesc()
     * @uses SrvItemEditor::setItemCode()
     * @uses SrvItemEditor::setItemName()
     * @uses SrvItemEditor::setLangCode()
     * @uses SrvItemEditor::setDescription()
     * @uses SrvItemEditor::setDynamicValues()
     */
    public function __construct($id = null, $itemId = null, $langId = null, $itemEditorDesc = null, $itemCode = null, $itemName = null, $langCode = null, $description = null, ArrayOfDicKeyValues $dynamicValues = null)
    {
        $this
            ->setId($id)
            ->setItemId($itemId)
            ->setLangId($langId)
            ->setItemEditorDesc($itemEditorDesc)
            ->setItemCode($itemCode)
            ->setItemName($itemName)
            ->setLangCode($langCode)
            ->setDescription($description)
            ->setDynamicValues($dynamicValues);
    }

    /**
     * Get Id value
     * @return int
     */
    public function getId()
    {
        return $this->Id;
    }

    /**
     * Set Id value
     * @param int $id
     * @return SrvItemEditor
     */
    public function setId($id = null)
    {
        // validation for constraint: int
        if (!is_null($id) && !(is_int($id) || ctype_digit($id))) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($id, true), gettype($id)), __LINE__);
        }
        $this->Id = $id;
        return $this;
    }

    /**
     * Get ItemId value
     * @return int
     */
    public function getItemId()
    {
        return $this->ItemId;
    }

    /**
     * Set ItemId value
     * @param int $itemId
     * @return SrvItemEditor
     */
    public function setItemId($itemId = null)
    {
        // validation for constraint: int
        if (!is_null($itemId) && !(is_int($itemId) || ctype_digit($itemId))) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($itemId, true), gettype($itemId)), __LINE__);
        }
        $this->ItemId = $itemId;
        return $this;
    }

    /**
     * Get LangId value
     * @return int
     */
    public function getLangId()
    {
        return $this->LangId;
    }

    /**
     * Set LangId value
     * @param int $langId
     * @return SrvItemEditor
     */
    public function setLangId($langId = null)
    {
        // validation for constraint: int
        if (!is_null($langId) && !(is_int($langId) || ctype_digit($langId))) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($langId, true), gettype($langId)), __LINE__);
        }
        $this->LangId = $langId;
        return $this;
    }

    /**
     * Get ItemEditorDesc value
     * @return string|null
     */
    public function getItemEditorDesc()
    {
        return $this->ItemEditorDesc;
    }

    /**
     * Set ItemEditorDesc value
     * @param string $itemEditorDesc
     * @return SrvItemEditor
     */
    public function setItemEditorDesc($itemEditorDesc = null)
    {
        // validation for constraint: string
        if (!is_null($itemEditorDesc) && !is_string($itemEditorDesc)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($itemEditorDesc, true), gettype($itemEditorDesc)), __LINE__);
        }
        $this->ItemEditorDesc = $itemEditorDesc;
        return $this;
    }

    /**
     * Get ItemCode value
     * @return string|null
     */
    public function getItemCode()
    {
        return $this->ItemCode;
    }

    /**
     * Set ItemCode value
     * @param string $itemCode
     * @return SrvItemEditor
     */
    public function setItemCode($itemCode = null)
    {
        // validation for constraint: string
        if (!is_null($itemCode) && !is_string($itemCode)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($itemCode, true), gettype($itemCode)), __LINE__);
        }
        $this->ItemCode = $itemCode;
        return $this;
    }

    /**
     * Get ItemName value
     * @return string|null
     */
    public function getItemName()
    {
        return $this->ItemName;
    }

    /**
     * Set ItemName value
     * @param string $itemName
     * @return SrvItemEditor
     */
    public function setItemName($itemName = null)
    {
        // validation for constraint: string
        if (!is_null($itemName) && !is_string($itemName)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($itemName, true), gettype($itemName)), __LINE__);
        }
        $this->ItemName = $itemName;
        return $this;
    }

    /**
     * Get LangCode value
     * @return string|null
     */
    public function getLangCode()
    {
        return $this->LangCode;
    }

    /**
     * Set LangCode value
     * @param string $langCode
     * @return SrvItemEditor
     */
    public function setLangCode($langCode = null)
    {
        // validation for constraint: string
        if (!is_null($langCode) && !is_string($langCode)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($langCode, true), gettype($langCode)), __LINE__);
        }
        $this->LangCode = $langCode;
        return $this;
    }

    /**
     * Get Description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->Description;
    }

    /**
     * Set Description value
     * @param string $description
     * @return SrvItemEditor
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($description, true), gettype($description)), __LINE__);
        }
        $this->Description = $description;
        return $this;
    }

    /**
     * Get dynamicValues value
     * @return ArrayOfDicKeyValues|null
     */
    public function getDynamicValues()
    {
        return $this->dynamicValues;
    }

    /**
     * Set dynamicValues value
     * @param ArrayOfDicKeyValues $dynamicValues
     * @return SrvItemEditor
     */
    public function setDynamicValues(ArrayOfDicKeyValues $dynamicValues = null)
    {
        $this->dynamicValues = $dynamicValues;
        return $this;
    }
}
