<?php

namespace Gek\UyumBahceGet\StructType;

use Gek\UyumBahceGet\EnumType\AttributeGrp;
use InvalidArgumentException;
use WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SrvItemAttribute StructType
 * @subpackage Structs
 */
class SrvItemAttribute extends AbstractStructBase
{
    /**
     * The Id
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $Id;
    /**
     * The AttributeGrp
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $AttributeGrp;
    /**
     * The ItemAttributeId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $ItemAttributeId;
    /**
     * The ItemId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $ItemId;
    /**
     * The ItemAttributeName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ItemAttributeName;
    /**
     * The ItemAttributeValue
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ItemAttributeValue;
    /**
     * The ItemAttributeDesc
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ItemAttributeDesc;
    /**
     * The Description
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Description;
    /**
     * The Description2
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Description2;
    /**
     * The ItemAttributeCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ItemAttributeCode;

    /**
     * Constructor method for SrvItemAttribute
     * @param int $id
     * @param string $attributeGrp
     * @param int $itemAttributeId
     * @param int $itemId
     * @param string $itemAttributeName
     * @param string $itemAttributeValue
     * @param string $itemAttributeDesc
     * @param string $description
     * @param string $description2
     * @param string $itemAttributeCode
     * @uses SrvItemAttribute::setId()
     * @uses SrvItemAttribute::setAttributeGrp()
     * @uses SrvItemAttribute::setItemAttributeId()
     * @uses SrvItemAttribute::setItemId()
     * @uses SrvItemAttribute::setItemAttributeName()
     * @uses SrvItemAttribute::setItemAttributeValue()
     * @uses SrvItemAttribute::setItemAttributeDesc()
     * @uses SrvItemAttribute::setDescription()
     * @uses SrvItemAttribute::setDescription2()
     * @uses SrvItemAttribute::setItemAttributeCode()
     */
    public function __construct($id = null, $attributeGrp = null, $itemAttributeId = null, $itemId = null, $itemAttributeName = null, $itemAttributeValue = null, $itemAttributeDesc = null, $description = null, $description2 = null, $itemAttributeCode = null)
    {
        $this
            ->setId($id)
            ->setAttributeGrp($attributeGrp)
            ->setItemAttributeId($itemAttributeId)
            ->setItemId($itemId)
            ->setItemAttributeName($itemAttributeName)
            ->setItemAttributeValue($itemAttributeValue)
            ->setItemAttributeDesc($itemAttributeDesc)
            ->setDescription($description)
            ->setDescription2($description2)
            ->setItemAttributeCode($itemAttributeCode);
    }

    /**
     * Get Id value
     * @return int
     */
    public function getId()
    {
        return $this->Id;
    }

    /**
     * Set Id value
     * @param int $id
     * @return SrvItemAttribute
     */
    public function setId($id = null)
    {
        // validation for constraint: int
        if (!is_null($id) && !(is_int($id) || ctype_digit($id))) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($id, true), gettype($id)), __LINE__);
        }
        $this->Id = $id;
        return $this;
    }

    /**
     * Get AttributeGrp value
     * @return string
     */
    public function getAttributeGrp()
    {
        return $this->AttributeGrp;
    }

    /**
     * Set AttributeGrp value
     * @param string $attributeGrp
     * @return SrvItemAttribute
     * @throws InvalidArgumentException
     * @uses \Gek\UyumBahceGet\EnumType\AttributeGrp::getValidValues()
     * @uses \Gek\UyumBahceGet\EnumType\AttributeGrp::valueIsValid()
     */
    public function setAttributeGrp($attributeGrp = null)
    {
        // validation for constraint: enumeration
        if (!AttributeGrp::valueIsValid($attributeGrp)) {
            throw new InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \Gek\UyumBahceGet\EnumType\AttributeGrp', is_array($attributeGrp) ? implode(', ', $attributeGrp) : var_export($attributeGrp, true), implode(', ', AttributeGrp::getValidValues())), __LINE__);
        }
        $this->AttributeGrp = $attributeGrp;
        return $this;
    }

    /**
     * Get ItemAttributeId value
     * @return int
     */
    public function getItemAttributeId()
    {
        return $this->ItemAttributeId;
    }

    /**
     * Set ItemAttributeId value
     * @param int $itemAttributeId
     * @return SrvItemAttribute
     */
    public function setItemAttributeId($itemAttributeId = null)
    {
        // validation for constraint: int
        if (!is_null($itemAttributeId) && !(is_int($itemAttributeId) || ctype_digit($itemAttributeId))) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($itemAttributeId, true), gettype($itemAttributeId)), __LINE__);
        }
        $this->ItemAttributeId = $itemAttributeId;
        return $this;
    }

    /**
     * Get ItemId value
     * @return int
     */
    public function getItemId()
    {
        return $this->ItemId;
    }

    /**
     * Set ItemId value
     * @param int $itemId
     * @return SrvItemAttribute
     */
    public function setItemId($itemId = null)
    {
        // validation for constraint: int
        if (!is_null($itemId) && !(is_int($itemId) || ctype_digit($itemId))) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($itemId, true), gettype($itemId)), __LINE__);
        }
        $this->ItemId = $itemId;
        return $this;
    }

    /**
     * Get ItemAttributeName value
     * @return string|null
     */
    public function getItemAttributeName()
    {
        return $this->ItemAttributeName;
    }

    /**
     * Set ItemAttributeName value
     * @param string $itemAttributeName
     * @return SrvItemAttribute
     */
    public function setItemAttributeName($itemAttributeName = null)
    {
        // validation for constraint: string
        if (!is_null($itemAttributeName) && !is_string($itemAttributeName)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($itemAttributeName, true), gettype($itemAttributeName)), __LINE__);
        }
        $this->ItemAttributeName = $itemAttributeName;
        return $this;
    }

    /**
     * Get ItemAttributeValue value
     * @return string|null
     */
    public function getItemAttributeValue()
    {
        return $this->ItemAttributeValue;
    }

    /**
     * Set ItemAttributeValue value
     * @param string $itemAttributeValue
     * @return SrvItemAttribute
     */
    public function setItemAttributeValue($itemAttributeValue = null)
    {
        // validation for constraint: string
        if (!is_null($itemAttributeValue) && !is_string($itemAttributeValue)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($itemAttributeValue, true), gettype($itemAttributeValue)), __LINE__);
        }
        $this->ItemAttributeValue = $itemAttributeValue;
        return $this;
    }

    /**
     * Get ItemAttributeDesc value
     * @return string|null
     */
    public function getItemAttributeDesc()
    {
        return $this->ItemAttributeDesc;
    }

    /**
     * Set ItemAttributeDesc value
     * @param string $itemAttributeDesc
     * @return SrvItemAttribute
     */
    public function setItemAttributeDesc($itemAttributeDesc = null)
    {
        // validation for constraint: string
        if (!is_null($itemAttributeDesc) && !is_string($itemAttributeDesc)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($itemAttributeDesc, true), gettype($itemAttributeDesc)), __LINE__);
        }
        $this->ItemAttributeDesc = $itemAttributeDesc;
        return $this;
    }

    /**
     * Get Description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->Description;
    }

    /**
     * Set Description value
     * @param string $description
     * @return SrvItemAttribute
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($description, true), gettype($description)), __LINE__);
        }
        $this->Description = $description;
        return $this;
    }

    /**
     * Get Description2 value
     * @return string|null
     */
    public function getDescription2()
    {
        return $this->Description2;
    }

    /**
     * Set Description2 value
     * @param string $description2
     * @return SrvItemAttribute
     */
    public function setDescription2($description2 = null)
    {
        // validation for constraint: string
        if (!is_null($description2) && !is_string($description2)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($description2, true), gettype($description2)), __LINE__);
        }
        $this->Description2 = $description2;
        return $this;
    }

    /**
     * Get ItemAttributeCode value
     * @return string|null
     */
    public function getItemAttributeCode()
    {
        return $this->ItemAttributeCode;
    }

    /**
     * Set ItemAttributeCode value
     * @param string $itemAttributeCode
     * @return SrvItemAttribute
     */
    public function setItemAttributeCode($itemAttributeCode = null)
    {
        // validation for constraint: string
        if (!is_null($itemAttributeCode) && !is_string($itemAttributeCode)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($itemAttributeCode, true), gettype($itemAttributeCode)), __LINE__);
        }
        $this->ItemAttributeCode = $itemAttributeCode;
        return $this;
    }
}
