<?php

namespace Gek\UyumBahceGet\StructType;

use InvalidArgumentException;
use WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SignatureType StructType
 * @subpackage Structs
 */
class SignatureType extends AbstractStructBase
{
    /**
     * The SignedInfo
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var SignedInfoType
     */
    public $SignedInfo;
    /**
     * The SignatureValue
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var SignatureValueType
     */
    public $SignatureValue;
    /**
     * The KeyInfo
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var KeyInfoType
     */
    public $KeyInfo;
    /**
     * The Object
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var ObjectType[]
     */
    public $Object;
    /**
     * The Id
     * @var string
     */
    public $Id;
    /**
     * The ID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: s4:ID
     * @var IDType
     */
    public $ID;
    /**
     * The SignatoryParty
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var PartyType
     */
    public $SignatoryParty;
    /**
     * The DigitalSignatureAttachment
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var AttachmentType
     */
    public $DigitalSignatureAttachment;

    /**
     * Constructor method for SignatureType
     * @param SignedInfoType $signedInfo
     * @param SignatureValueType $signatureValue
     * @param KeyInfoType $keyInfo
     * @param ObjectType[] $object
     * @param string $id
     * @param IDType|null $iD_1
     * @param PartyType $signatoryParty
     * @param AttachmentType $digitalSignatureAttachment
     * @uses SignatureType::setSignedInfo()
     * @uses SignatureType::setSignatureValue()
     * @uses SignatureType::setKeyInfo()
     * @uses SignatureType::setObject()
     * @uses SignatureType::setId()
     * @uses SignatureType::setID_1()
     * @uses SignatureType::setSignatoryParty()
     * @uses SignatureType::setDigitalSignatureAttachment()
     */
    public function __construct(SignedInfoType $signedInfo = null, SignatureValueType $signatureValue = null, KeyInfoType $keyInfo = null, array $object = array(), $id = null, IDType $iD_1 = null, PartyType $signatoryParty = null, AttachmentType $digitalSignatureAttachment = null)
    {
        $this
            ->setSignedInfo($signedInfo)
            ->setSignatureValue($signatureValue)
            ->setKeyInfo($keyInfo)
            ->setObject($object)
            ->setId($id)
            ->setID_1($iD_1)
            ->setSignatoryParty($signatoryParty)
            ->setDigitalSignatureAttachment($digitalSignatureAttachment);
    }

    /**
     * Get SignedInfo value
     * @return SignedInfoType|null
     */
    public function getSignedInfo()
    {
        return $this->SignedInfo;
    }

    /**
     * Set SignedInfo value
     * @param SignedInfoType $signedInfo
     * @return SignatureType
     */
    public function setSignedInfo(SignedInfoType $signedInfo = null)
    {
        $this->SignedInfo = $signedInfo;
        return $this;
    }

    /**
     * Get SignatureValue value
     * @return SignatureValueType|null
     */
    public function getSignatureValue()
    {
        return $this->SignatureValue;
    }

    /**
     * Set SignatureValue value
     * @param SignatureValueType $signatureValue
     * @return SignatureType
     */
    public function setSignatureValue(SignatureValueType $signatureValue = null)
    {
        $this->SignatureValue = $signatureValue;
        return $this;
    }

    /**
     * Get KeyInfo value
     * @return KeyInfoType|null
     */
    public function getKeyInfo()
    {
        return $this->KeyInfo;
    }

    /**
     * Set KeyInfo value
     * @param KeyInfoType $keyInfo
     * @return SignatureType
     */
    public function setKeyInfo(KeyInfoType $keyInfo = null)
    {
        $this->KeyInfo = $keyInfo;
        return $this;
    }

    /**
     * Get Object value
     * @return ObjectType[]|null
     */
    public function getObject()
    {
        return $this->Object;
    }

    /**
     * This method is responsible for validating the values passed to the setObject method
     * This method is willingly generated in order to preserve the one-line inline validation within the setObject method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateObjectForArrayConstraintsFromSetObject(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $signatureTypeObjectItem) {
            // validation for constraint: itemType
            if (!$signatureTypeObjectItem instanceof ObjectType) {
                $invalidValues[] = is_object($signatureTypeObjectItem) ? get_class($signatureTypeObjectItem) : sprintf('%s(%s)', gettype($signatureTypeObjectItem), var_export($signatureTypeObjectItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Object property can only contain items of type \Gek\UyumBahceGet\StructType\ObjectType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }

    /**
     * Set Object value
     * @param ObjectType[] $object
     * @return SignatureType
     * @throws InvalidArgumentException
     */
    public function setObject(array $object = array())
    {
        // validation for constraint: array
        if ('' !== ($objectArrayErrorMessage = self::validateObjectForArrayConstraintsFromSetObject($object))) {
            throw new InvalidArgumentException($objectArrayErrorMessage, __LINE__);
        }
        $this->Object = $object;
        return $this;
    }

    /**
     * Add item to Object value
     * @param ObjectType $item
     * @return SignatureType
     * @throws InvalidArgumentException
     */
    public function addToObject(ObjectType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof ObjectType) {
            throw new InvalidArgumentException(sprintf('The Object property can only contain items of type \Gek\UyumBahceGet\StructType\ObjectType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Object[] = $item;
        return $this;
    }

    /**
     * Get Id value
     * @return string|null
     */
    public function getId()
    {
        return $this->Id;
    }

    /**
     * Set Id value
     * @param string $id
     * @return SignatureType
     */
    public function setId($id = null)
    {
        // validation for constraint: string
        if (!is_null($id) && !is_string($id)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($id, true), gettype($id)), __LINE__);
        }
        $this->Id = $id;
        return $this;
    }

    /**
     * Get ID value
     * @return IDType|null
     */
    public function getID_1()
    {
        return $this->ID;
    }

    /**
     * Set ID value
     * @param IDType|null $iD_1
     * @return SignatureType
     */
    public function setID_1(IDType $iD_1 = null)
    {
        $this->ID = $iD_1;
        return $this;
    }

    /**
     * Get SignatoryParty value
     * @return PartyType|null
     */
    public function getSignatoryParty()
    {
        return $this->SignatoryParty;
    }

    /**
     * Set SignatoryParty value
     * @param PartyType $signatoryParty
     * @return SignatureType
     */
    public function setSignatoryParty(PartyType $signatoryParty = null)
    {
        $this->SignatoryParty = $signatoryParty;
        return $this;
    }

    /**
     * Get DigitalSignatureAttachment value
     * @return AttachmentType|null
     */
    public function getDigitalSignatureAttachment()
    {
        return $this->DigitalSignatureAttachment;
    }

    /**
     * Set DigitalSignatureAttachment value
     * @param AttachmentType $digitalSignatureAttachment
     * @return SignatureType
     */
    public function setDigitalSignatureAttachment(AttachmentType $digitalSignatureAttachment = null)
    {
        $this->DigitalSignatureAttachment = $digitalSignatureAttachment;
        return $this;
    }
}
