<?php

namespace Gek\UyumBahceGet\StructType;

use InvalidArgumentException;
use WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ShipmentType StructType
 * @subpackage Structs
 */
class ShipmentType extends AbstractStructBase
{
    /**
     * The ID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: s4:ID
     * @var IDType
     */
    public $ID;
    /**
     * The HandlingCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: s4:HandlingCode
     * @var HandlingCodeType
     */
    public $HandlingCode;
    /**
     * The HandlingInstructions
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: s4:HandlingInstructions
     * @var HandlingInstructionsType
     */
    public $HandlingInstructions;
    /**
     * The GrossWeightMeasure
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: s4:GrossWeightMeasure
     * @var GrossWeightMeasureType
     */
    public $GrossWeightMeasure;
    /**
     * The NetWeightMeasure
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: s4:NetWeightMeasure
     * @var NetWeightMeasureType
     */
    public $NetWeightMeasure;
    /**
     * The GrossVolumeMeasure
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: s4:GrossVolumeMeasure
     * @var GrossVolumeMeasureType
     */
    public $GrossVolumeMeasure;
    /**
     * The NetVolumeMeasure
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: s4:NetVolumeMeasure
     * @var NetVolumeMeasureType
     */
    public $NetVolumeMeasure;
    /**
     * The TotalGoodsItemQuantity
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: s4:TotalGoodsItemQuantity
     * @var TotalGoodsItemQuantityType
     */
    public $TotalGoodsItemQuantity;
    /**
     * The TotalTransportHandlingUnitQuantity
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: s4:TotalTransportHandlingUnitQuantity
     * @var TotalTransportHandlingUnitQuantityType
     */
    public $TotalTransportHandlingUnitQuantity;
    /**
     * The InsuranceValueAmount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: s4:InsuranceValueAmount
     * @var InsuranceValueAmountType
     */
    public $InsuranceValueAmount;
    /**
     * The DeclaredCustomsValueAmount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: s4:DeclaredCustomsValueAmount
     * @var DeclaredCustomsValueAmountType
     */
    public $DeclaredCustomsValueAmount;
    /**
     * The DeclaredForCarriageValueAmount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: s4:DeclaredForCarriageValueAmount
     * @var DeclaredForCarriageValueAmountType
     */
    public $DeclaredForCarriageValueAmount;
    /**
     * The DeclaredStatisticsValueAmount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: s4:DeclaredStatisticsValueAmount
     * @var DeclaredStatisticsValueAmountType
     */
    public $DeclaredStatisticsValueAmount;
    /**
     * The FreeOnBoardValueAmount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: s4:FreeOnBoardValueAmount
     * @var FreeOnBoardValueAmountType
     */
    public $FreeOnBoardValueAmount;
    /**
     * The SpecialInstructions
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - ref: s4:SpecialInstructions
     * @var SpecialInstructionsType[]
     */
    public $SpecialInstructions;
    /**
     * The GoodsItem
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var GoodsItemType[]
     */
    public $GoodsItem;
    /**
     * The ShipmentStage
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var ShipmentStageType[]
     */
    public $ShipmentStage;
    /**
     * The Delivery
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var DeliveryType
     */
    public $Delivery;
    /**
     * The TransportHandlingUnit
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var TransportHandlingUnitType[]
     */
    public $TransportHandlingUnit;
    /**
     * The ReturnAddress
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var AddressType
     */
    public $ReturnAddress;
    /**
     * The FirstArrivalPortLocation
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var LocationType
     */
    public $FirstArrivalPortLocation;
    /**
     * The LastExitPortLocation
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var LocationType
     */
    public $LastExitPortLocation;

    /**
     * Constructor method for ShipmentType
     * @param IDType $iD
     * @param HandlingCodeType $handlingCode
     * @param HandlingInstructionsType $handlingInstructions
     * @param GrossWeightMeasureType $grossWeightMeasure
     * @param NetWeightMeasureType $netWeightMeasure
     * @param GrossVolumeMeasureType $grossVolumeMeasure
     * @param NetVolumeMeasureType $netVolumeMeasure
     * @param TotalGoodsItemQuantityType $totalGoodsItemQuantity
     * @param TotalTransportHandlingUnitQuantityType $totalTransportHandlingUnitQuantity
     * @param InsuranceValueAmountType $insuranceValueAmount
     * @param DeclaredCustomsValueAmountType $declaredCustomsValueAmount
     * @param DeclaredForCarriageValueAmountType $declaredForCarriageValueAmount
     * @param DeclaredStatisticsValueAmountType $declaredStatisticsValueAmount
     * @param FreeOnBoardValueAmountType $freeOnBoardValueAmount
     * @param SpecialInstructionsType[] $specialInstructions
     * @param GoodsItemType[] $goodsItem
     * @param ShipmentStageType[] $shipmentStage
     * @param DeliveryType $delivery
     * @param TransportHandlingUnitType[] $transportHandlingUnit
     * @param AddressType $returnAddress
     * @param LocationType $firstArrivalPortLocation
     * @param LocationType $lastExitPortLocation
     * @uses ShipmentType::setID()
     * @uses ShipmentType::setHandlingCode()
     * @uses ShipmentType::setHandlingInstructions()
     * @uses ShipmentType::setGrossWeightMeasure()
     * @uses ShipmentType::setNetWeightMeasure()
     * @uses ShipmentType::setGrossVolumeMeasure()
     * @uses ShipmentType::setNetVolumeMeasure()
     * @uses ShipmentType::setTotalGoodsItemQuantity()
     * @uses ShipmentType::setTotalTransportHandlingUnitQuantity()
     * @uses ShipmentType::setInsuranceValueAmount()
     * @uses ShipmentType::setDeclaredCustomsValueAmount()
     * @uses ShipmentType::setDeclaredForCarriageValueAmount()
     * @uses ShipmentType::setDeclaredStatisticsValueAmount()
     * @uses ShipmentType::setFreeOnBoardValueAmount()
     * @uses ShipmentType::setSpecialInstructions()
     * @uses ShipmentType::setGoodsItem()
     * @uses ShipmentType::setShipmentStage()
     * @uses ShipmentType::setDelivery()
     * @uses ShipmentType::setTransportHandlingUnit()
     * @uses ShipmentType::setReturnAddress()
     * @uses ShipmentType::setFirstArrivalPortLocation()
     * @uses ShipmentType::setLastExitPortLocation()
     */
    public function __construct(IDType $iD = null, HandlingCodeType $handlingCode = null, HandlingInstructionsType $handlingInstructions = null, GrossWeightMeasureType $grossWeightMeasure = null, NetWeightMeasureType $netWeightMeasure = null, GrossVolumeMeasureType $grossVolumeMeasure = null, NetVolumeMeasureType $netVolumeMeasure = null, TotalGoodsItemQuantityType $totalGoodsItemQuantity = null, TotalTransportHandlingUnitQuantityType $totalTransportHandlingUnitQuantity = null, InsuranceValueAmountType $insuranceValueAmount = null, DeclaredCustomsValueAmountType $declaredCustomsValueAmount = null, DeclaredForCarriageValueAmountType $declaredForCarriageValueAmount = null, DeclaredStatisticsValueAmountType $declaredStatisticsValueAmount = null, FreeOnBoardValueAmountType $freeOnBoardValueAmount = null, array $specialInstructions = array(), array $goodsItem = array(), array $shipmentStage = array(), DeliveryType $delivery = null, array $transportHandlingUnit = array(), AddressType $returnAddress = null, LocationType $firstArrivalPortLocation = null, LocationType $lastExitPortLocation = null)
    {
        $this
            ->setID($iD)
            ->setHandlingCode($handlingCode)
            ->setHandlingInstructions($handlingInstructions)
            ->setGrossWeightMeasure($grossWeightMeasure)
            ->setNetWeightMeasure($netWeightMeasure)
            ->setGrossVolumeMeasure($grossVolumeMeasure)
            ->setNetVolumeMeasure($netVolumeMeasure)
            ->setTotalGoodsItemQuantity($totalGoodsItemQuantity)
            ->setTotalTransportHandlingUnitQuantity($totalTransportHandlingUnitQuantity)
            ->setInsuranceValueAmount($insuranceValueAmount)
            ->setDeclaredCustomsValueAmount($declaredCustomsValueAmount)
            ->setDeclaredForCarriageValueAmount($declaredForCarriageValueAmount)
            ->setDeclaredStatisticsValueAmount($declaredStatisticsValueAmount)
            ->setFreeOnBoardValueAmount($freeOnBoardValueAmount)
            ->setSpecialInstructions($specialInstructions)
            ->setGoodsItem($goodsItem)
            ->setShipmentStage($shipmentStage)
            ->setDelivery($delivery)
            ->setTransportHandlingUnit($transportHandlingUnit)
            ->setReturnAddress($returnAddress)
            ->setFirstArrivalPortLocation($firstArrivalPortLocation)
            ->setLastExitPortLocation($lastExitPortLocation);
    }

    /**
     * Get ID value
     * @return IDType|null
     */
    public function getID()
    {
        return $this->ID;
    }

    /**
     * Set ID value
     * @param IDType $iD
     * @return ShipmentType
     */
    public function setID(IDType $iD = null)
    {
        $this->ID = $iD;
        return $this;
    }

    /**
     * Get HandlingCode value
     * @return HandlingCodeType|null
     */
    public function getHandlingCode()
    {
        return $this->HandlingCode;
    }

    /**
     * Set HandlingCode value
     * @param HandlingCodeType $handlingCode
     * @return ShipmentType
     */
    public function setHandlingCode(HandlingCodeType $handlingCode = null)
    {
        $this->HandlingCode = $handlingCode;
        return $this;
    }

    /**
     * Get HandlingInstructions value
     * @return HandlingInstructionsType|null
     */
    public function getHandlingInstructions()
    {
        return $this->HandlingInstructions;
    }

    /**
     * Set HandlingInstructions value
     * @param HandlingInstructionsType $handlingInstructions
     * @return ShipmentType
     */
    public function setHandlingInstructions(HandlingInstructionsType $handlingInstructions = null)
    {
        $this->HandlingInstructions = $handlingInstructions;
        return $this;
    }

    /**
     * Get GrossWeightMeasure value
     * @return GrossWeightMeasureType|null
     */
    public function getGrossWeightMeasure()
    {
        return $this->GrossWeightMeasure;
    }

    /**
     * Set GrossWeightMeasure value
     * @param GrossWeightMeasureType $grossWeightMeasure
     * @return ShipmentType
     */
    public function setGrossWeightMeasure(GrossWeightMeasureType $grossWeightMeasure = null)
    {
        $this->GrossWeightMeasure = $grossWeightMeasure;
        return $this;
    }

    /**
     * Get NetWeightMeasure value
     * @return NetWeightMeasureType|null
     */
    public function getNetWeightMeasure()
    {
        return $this->NetWeightMeasure;
    }

    /**
     * Set NetWeightMeasure value
     * @param NetWeightMeasureType $netWeightMeasure
     * @return ShipmentType
     */
    public function setNetWeightMeasure(NetWeightMeasureType $netWeightMeasure = null)
    {
        $this->NetWeightMeasure = $netWeightMeasure;
        return $this;
    }

    /**
     * Get GrossVolumeMeasure value
     * @return GrossVolumeMeasureType|null
     */
    public function getGrossVolumeMeasure()
    {
        return $this->GrossVolumeMeasure;
    }

    /**
     * Set GrossVolumeMeasure value
     * @param GrossVolumeMeasureType $grossVolumeMeasure
     * @return ShipmentType
     */
    public function setGrossVolumeMeasure(GrossVolumeMeasureType $grossVolumeMeasure = null)
    {
        $this->GrossVolumeMeasure = $grossVolumeMeasure;
        return $this;
    }

    /**
     * Get NetVolumeMeasure value
     * @return NetVolumeMeasureType|null
     */
    public function getNetVolumeMeasure()
    {
        return $this->NetVolumeMeasure;
    }

    /**
     * Set NetVolumeMeasure value
     * @param NetVolumeMeasureType $netVolumeMeasure
     * @return ShipmentType
     */
    public function setNetVolumeMeasure(NetVolumeMeasureType $netVolumeMeasure = null)
    {
        $this->NetVolumeMeasure = $netVolumeMeasure;
        return $this;
    }

    /**
     * Get TotalGoodsItemQuantity value
     * @return TotalGoodsItemQuantityType|null
     */
    public function getTotalGoodsItemQuantity()
    {
        return $this->TotalGoodsItemQuantity;
    }

    /**
     * Set TotalGoodsItemQuantity value
     * @param TotalGoodsItemQuantityType $totalGoodsItemQuantity
     * @return ShipmentType
     */
    public function setTotalGoodsItemQuantity(TotalGoodsItemQuantityType $totalGoodsItemQuantity = null)
    {
        $this->TotalGoodsItemQuantity = $totalGoodsItemQuantity;
        return $this;
    }

    /**
     * Get TotalTransportHandlingUnitQuantity value
     * @return TotalTransportHandlingUnitQuantityType|null
     */
    public function getTotalTransportHandlingUnitQuantity()
    {
        return $this->TotalTransportHandlingUnitQuantity;
    }

    /**
     * Set TotalTransportHandlingUnitQuantity value
     * @param TotalTransportHandlingUnitQuantityType $totalTransportHandlingUnitQuantity
     * @return ShipmentType
     */
    public function setTotalTransportHandlingUnitQuantity(TotalTransportHandlingUnitQuantityType $totalTransportHandlingUnitQuantity = null)
    {
        $this->TotalTransportHandlingUnitQuantity = $totalTransportHandlingUnitQuantity;
        return $this;
    }

    /**
     * Get InsuranceValueAmount value
     * @return InsuranceValueAmountType|null
     */
    public function getInsuranceValueAmount()
    {
        return $this->InsuranceValueAmount;
    }

    /**
     * Set InsuranceValueAmount value
     * @param InsuranceValueAmountType $insuranceValueAmount
     * @return ShipmentType
     */
    public function setInsuranceValueAmount(InsuranceValueAmountType $insuranceValueAmount = null)
    {
        $this->InsuranceValueAmount = $insuranceValueAmount;
        return $this;
    }

    /**
     * Get DeclaredCustomsValueAmount value
     * @return DeclaredCustomsValueAmountType|null
     */
    public function getDeclaredCustomsValueAmount()
    {
        return $this->DeclaredCustomsValueAmount;
    }

    /**
     * Set DeclaredCustomsValueAmount value
     * @param DeclaredCustomsValueAmountType $declaredCustomsValueAmount
     * @return ShipmentType
     */
    public function setDeclaredCustomsValueAmount(DeclaredCustomsValueAmountType $declaredCustomsValueAmount = null)
    {
        $this->DeclaredCustomsValueAmount = $declaredCustomsValueAmount;
        return $this;
    }

    /**
     * Get DeclaredForCarriageValueAmount value
     * @return DeclaredForCarriageValueAmountType|null
     */
    public function getDeclaredForCarriageValueAmount()
    {
        return $this->DeclaredForCarriageValueAmount;
    }

    /**
     * Set DeclaredForCarriageValueAmount value
     * @param DeclaredForCarriageValueAmountType $declaredForCarriageValueAmount
     * @return ShipmentType
     */
    public function setDeclaredForCarriageValueAmount(DeclaredForCarriageValueAmountType $declaredForCarriageValueAmount = null)
    {
        $this->DeclaredForCarriageValueAmount = $declaredForCarriageValueAmount;
        return $this;
    }

    /**
     * Get DeclaredStatisticsValueAmount value
     * @return DeclaredStatisticsValueAmountType|null
     */
    public function getDeclaredStatisticsValueAmount()
    {
        return $this->DeclaredStatisticsValueAmount;
    }

    /**
     * Set DeclaredStatisticsValueAmount value
     * @param DeclaredStatisticsValueAmountType $declaredStatisticsValueAmount
     * @return ShipmentType
     */
    public function setDeclaredStatisticsValueAmount(DeclaredStatisticsValueAmountType $declaredStatisticsValueAmount = null)
    {
        $this->DeclaredStatisticsValueAmount = $declaredStatisticsValueAmount;
        return $this;
    }

    /**
     * Get FreeOnBoardValueAmount value
     * @return FreeOnBoardValueAmountType|null
     */
    public function getFreeOnBoardValueAmount()
    {
        return $this->FreeOnBoardValueAmount;
    }

    /**
     * Set FreeOnBoardValueAmount value
     * @param FreeOnBoardValueAmountType $freeOnBoardValueAmount
     * @return ShipmentType
     */
    public function setFreeOnBoardValueAmount(FreeOnBoardValueAmountType $freeOnBoardValueAmount = null)
    {
        $this->FreeOnBoardValueAmount = $freeOnBoardValueAmount;
        return $this;
    }

    /**
     * Get SpecialInstructions value
     * @return SpecialInstructionsType[]|null
     */
    public function getSpecialInstructions()
    {
        return $this->SpecialInstructions;
    }

    /**
     * This method is responsible for validating the values passed to the setSpecialInstructions method
     * This method is willingly generated in order to preserve the one-line inline validation within the setSpecialInstructions method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateSpecialInstructionsForArrayConstraintsFromSetSpecialInstructions(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $shipmentTypeSpecialInstructionsItem) {
            // validation for constraint: itemType
            if (!$shipmentTypeSpecialInstructionsItem instanceof SpecialInstructionsType) {
                $invalidValues[] = is_object($shipmentTypeSpecialInstructionsItem) ? get_class($shipmentTypeSpecialInstructionsItem) : sprintf('%s(%s)', gettype($shipmentTypeSpecialInstructionsItem), var_export($shipmentTypeSpecialInstructionsItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The SpecialInstructions property can only contain items of type \Gek\UyumBahceGet\StructType\SpecialInstructionsType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }

    /**
     * Set SpecialInstructions value
     * @param SpecialInstructionsType[] $specialInstructions
     * @return ShipmentType
     * @throws InvalidArgumentException
     */
    public function setSpecialInstructions(array $specialInstructions = array())
    {
        // validation for constraint: array
        if ('' !== ($specialInstructionsArrayErrorMessage = self::validateSpecialInstructionsForArrayConstraintsFromSetSpecialInstructions($specialInstructions))) {
            throw new InvalidArgumentException($specialInstructionsArrayErrorMessage, __LINE__);
        }
        $this->SpecialInstructions = $specialInstructions;
        return $this;
    }

    /**
     * Add item to SpecialInstructions value
     * @param SpecialInstructionsType $item
     * @return ShipmentType
     * @throws InvalidArgumentException
     */
    public function addToSpecialInstructions(SpecialInstructionsType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof SpecialInstructionsType) {
            throw new InvalidArgumentException(sprintf('The SpecialInstructions property can only contain items of type \Gek\UyumBahceGet\StructType\SpecialInstructionsType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->SpecialInstructions[] = $item;
        return $this;
    }

    /**
     * Get GoodsItem value
     * @return GoodsItemType[]|null
     */
    public function getGoodsItem()
    {
        return $this->GoodsItem;
    }

    /**
     * This method is responsible for validating the values passed to the setGoodsItem method
     * This method is willingly generated in order to preserve the one-line inline validation within the setGoodsItem method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateGoodsItemForArrayConstraintsFromSetGoodsItem(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $shipmentTypeGoodsItemItem) {
            // validation for constraint: itemType
            if (!$shipmentTypeGoodsItemItem instanceof GoodsItemType) {
                $invalidValues[] = is_object($shipmentTypeGoodsItemItem) ? get_class($shipmentTypeGoodsItemItem) : sprintf('%s(%s)', gettype($shipmentTypeGoodsItemItem), var_export($shipmentTypeGoodsItemItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The GoodsItem property can only contain items of type \Gek\UyumBahceGet\StructType\GoodsItemType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }

    /**
     * Set GoodsItem value
     * @param GoodsItemType[] $goodsItem
     * @return ShipmentType
     * @throws InvalidArgumentException
     */
    public function setGoodsItem(array $goodsItem = array())
    {
        // validation for constraint: array
        if ('' !== ($goodsItemArrayErrorMessage = self::validateGoodsItemForArrayConstraintsFromSetGoodsItem($goodsItem))) {
            throw new InvalidArgumentException($goodsItemArrayErrorMessage, __LINE__);
        }
        $this->GoodsItem = $goodsItem;
        return $this;
    }

    /**
     * Add item to GoodsItem value
     * @param GoodsItemType $item
     * @return ShipmentType
     * @throws InvalidArgumentException
     */
    public function addToGoodsItem(GoodsItemType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof GoodsItemType) {
            throw new InvalidArgumentException(sprintf('The GoodsItem property can only contain items of type \Gek\UyumBahceGet\StructType\GoodsItemType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->GoodsItem[] = $item;
        return $this;
    }

    /**
     * Get ShipmentStage value
     * @return ShipmentStageType[]|null
     */
    public function getShipmentStage()
    {
        return $this->ShipmentStage;
    }

    /**
     * This method is responsible for validating the values passed to the setShipmentStage method
     * This method is willingly generated in order to preserve the one-line inline validation within the setShipmentStage method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateShipmentStageForArrayConstraintsFromSetShipmentStage(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $shipmentTypeShipmentStageItem) {
            // validation for constraint: itemType
            if (!$shipmentTypeShipmentStageItem instanceof ShipmentStageType) {
                $invalidValues[] = is_object($shipmentTypeShipmentStageItem) ? get_class($shipmentTypeShipmentStageItem) : sprintf('%s(%s)', gettype($shipmentTypeShipmentStageItem), var_export($shipmentTypeShipmentStageItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The ShipmentStage property can only contain items of type \Gek\UyumBahceGet\StructType\ShipmentStageType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }

    /**
     * Set ShipmentStage value
     * @param ShipmentStageType[] $shipmentStage
     * @return ShipmentType
     * @throws InvalidArgumentException
     */
    public function setShipmentStage(array $shipmentStage = array())
    {
        // validation for constraint: array
        if ('' !== ($shipmentStageArrayErrorMessage = self::validateShipmentStageForArrayConstraintsFromSetShipmentStage($shipmentStage))) {
            throw new InvalidArgumentException($shipmentStageArrayErrorMessage, __LINE__);
        }
        $this->ShipmentStage = $shipmentStage;
        return $this;
    }

    /**
     * Add item to ShipmentStage value
     * @param ShipmentStageType $item
     * @return ShipmentType
     * @throws InvalidArgumentException
     */
    public function addToShipmentStage(ShipmentStageType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof ShipmentStageType) {
            throw new InvalidArgumentException(sprintf('The ShipmentStage property can only contain items of type \Gek\UyumBahceGet\StructType\ShipmentStageType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->ShipmentStage[] = $item;
        return $this;
    }

    /**
     * Get Delivery value
     * @return DeliveryType|null
     */
    public function getDelivery()
    {
        return $this->Delivery;
    }

    /**
     * Set Delivery value
     * @param DeliveryType $delivery
     * @return ShipmentType
     */
    public function setDelivery(DeliveryType $delivery = null)
    {
        $this->Delivery = $delivery;
        return $this;
    }

    /**
     * Get TransportHandlingUnit value
     * @return TransportHandlingUnitType[]|null
     */
    public function getTransportHandlingUnit()
    {
        return $this->TransportHandlingUnit;
    }

    /**
     * This method is responsible for validating the values passed to the setTransportHandlingUnit method
     * This method is willingly generated in order to preserve the one-line inline validation within the setTransportHandlingUnit method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateTransportHandlingUnitForArrayConstraintsFromSetTransportHandlingUnit(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $shipmentTypeTransportHandlingUnitItem) {
            // validation for constraint: itemType
            if (!$shipmentTypeTransportHandlingUnitItem instanceof TransportHandlingUnitType) {
                $invalidValues[] = is_object($shipmentTypeTransportHandlingUnitItem) ? get_class($shipmentTypeTransportHandlingUnitItem) : sprintf('%s(%s)', gettype($shipmentTypeTransportHandlingUnitItem), var_export($shipmentTypeTransportHandlingUnitItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The TransportHandlingUnit property can only contain items of type \Gek\UyumBahceGet\StructType\TransportHandlingUnitType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }

    /**
     * Set TransportHandlingUnit value
     * @param TransportHandlingUnitType[] $transportHandlingUnit
     * @return ShipmentType
     * @throws InvalidArgumentException
     */
    public function setTransportHandlingUnit(array $transportHandlingUnit = array())
    {
        // validation for constraint: array
        if ('' !== ($transportHandlingUnitArrayErrorMessage = self::validateTransportHandlingUnitForArrayConstraintsFromSetTransportHandlingUnit($transportHandlingUnit))) {
            throw new InvalidArgumentException($transportHandlingUnitArrayErrorMessage, __LINE__);
        }
        $this->TransportHandlingUnit = $transportHandlingUnit;
        return $this;
    }

    /**
     * Add item to TransportHandlingUnit value
     * @param TransportHandlingUnitType $item
     * @return ShipmentType
     * @throws InvalidArgumentException
     */
    public function addToTransportHandlingUnit(TransportHandlingUnitType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof TransportHandlingUnitType) {
            throw new InvalidArgumentException(sprintf('The TransportHandlingUnit property can only contain items of type \Gek\UyumBahceGet\StructType\TransportHandlingUnitType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->TransportHandlingUnit[] = $item;
        return $this;
    }

    /**
     * Get ReturnAddress value
     * @return AddressType|null
     */
    public function getReturnAddress()
    {
        return $this->ReturnAddress;
    }

    /**
     * Set ReturnAddress value
     * @param AddressType $returnAddress
     * @return ShipmentType
     */
    public function setReturnAddress(AddressType $returnAddress = null)
    {
        $this->ReturnAddress = $returnAddress;
        return $this;
    }

    /**
     * Get FirstArrivalPortLocation value
     * @return LocationType|null
     */
    public function getFirstArrivalPortLocation()
    {
        return $this->FirstArrivalPortLocation;
    }

    /**
     * Set FirstArrivalPortLocation value
     * @param LocationType $firstArrivalPortLocation
     * @return ShipmentType
     */
    public function setFirstArrivalPortLocation(LocationType $firstArrivalPortLocation = null)
    {
        $this->FirstArrivalPortLocation = $firstArrivalPortLocation;
        return $this;
    }

    /**
     * Get LastExitPortLocation value
     * @return LocationType|null
     */
    public function getLastExitPortLocation()
    {
        return $this->LastExitPortLocation;
    }

    /**
     * Set LastExitPortLocation value
     * @param LocationType $lastExitPortLocation
     * @return ShipmentType
     */
    public function setLastExitPortLocation(LocationType $lastExitPortLocation = null)
    {
        $this->LastExitPortLocation = $lastExitPortLocation;
        return $this;
    }
}
