<?php

namespace Gek\UyumBahceGet\StructType;

use InvalidArgumentException;
use WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ShipmentStageType StructType
 * @subpackage Structs
 */
class ShipmentStageType extends AbstractStructBase
{
    /**
     * The ID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: s4:ID
     * @var IDType
     */
    public $ID;
    /**
     * The TransportModeCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: s4:TransportModeCode
     * @var TransportModeCodeType
     */
    public $TransportModeCode;
    /**
     * The TransportMeansTypeCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: s4:TransportMeansTypeCode
     * @var TransportMeansTypeCodeType
     */
    public $TransportMeansTypeCode;
    /**
     * The TransitDirectionCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: s4:TransitDirectionCode
     * @var TransitDirectionCodeType
     */
    public $TransitDirectionCode;
    /**
     * The Instructions
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - ref: s4:Instructions
     * @var InstructionsType[]
     */
    public $Instructions;
    /**
     * The TransitPeriod
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var PeriodType
     */
    public $TransitPeriod;
    /**
     * The TransportMeans
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var TransportMeansType
     */
    public $TransportMeans;
    /**
     * The DriverPerson
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var PersonType[]
     */
    public $DriverPerson;

    /**
     * Constructor method for ShipmentStageType
     * @param IDType $iD
     * @param TransportModeCodeType $transportModeCode
     * @param TransportMeansTypeCodeType $transportMeansTypeCode
     * @param TransitDirectionCodeType $transitDirectionCode
     * @param InstructionsType[] $instructions
     * @param PeriodType $transitPeriod
     * @param TransportMeansType $transportMeans
     * @param PersonType[] $driverPerson
     * @uses ShipmentStageType::setID()
     * @uses ShipmentStageType::setTransportModeCode()
     * @uses ShipmentStageType::setTransportMeansTypeCode()
     * @uses ShipmentStageType::setTransitDirectionCode()
     * @uses ShipmentStageType::setInstructions()
     * @uses ShipmentStageType::setTransitPeriod()
     * @uses ShipmentStageType::setTransportMeans()
     * @uses ShipmentStageType::setDriverPerson()
     */
    public function __construct(IDType $iD = null, TransportModeCodeType $transportModeCode = null, TransportMeansTypeCodeType $transportMeansTypeCode = null, TransitDirectionCodeType $transitDirectionCode = null, array $instructions = array(), PeriodType $transitPeriod = null, TransportMeansType $transportMeans = null, array $driverPerson = array())
    {
        $this
            ->setID($iD)
            ->setTransportModeCode($transportModeCode)
            ->setTransportMeansTypeCode($transportMeansTypeCode)
            ->setTransitDirectionCode($transitDirectionCode)
            ->setInstructions($instructions)
            ->setTransitPeriod($transitPeriod)
            ->setTransportMeans($transportMeans)
            ->setDriverPerson($driverPerson);
    }

    /**
     * Get ID value
     * @return IDType|null
     */
    public function getID()
    {
        return $this->ID;
    }

    /**
     * Set ID value
     * @param IDType $iD
     * @return ShipmentStageType
     */
    public function setID(IDType $iD = null)
    {
        $this->ID = $iD;
        return $this;
    }

    /**
     * Get TransportModeCode value
     * @return TransportModeCodeType|null
     */
    public function getTransportModeCode()
    {
        return $this->TransportModeCode;
    }

    /**
     * Set TransportModeCode value
     * @param TransportModeCodeType $transportModeCode
     * @return ShipmentStageType
     */
    public function setTransportModeCode(TransportModeCodeType $transportModeCode = null)
    {
        $this->TransportModeCode = $transportModeCode;
        return $this;
    }

    /**
     * Get TransportMeansTypeCode value
     * @return TransportMeansTypeCodeType|null
     */
    public function getTransportMeansTypeCode()
    {
        return $this->TransportMeansTypeCode;
    }

    /**
     * Set TransportMeansTypeCode value
     * @param TransportMeansTypeCodeType $transportMeansTypeCode
     * @return ShipmentStageType
     */
    public function setTransportMeansTypeCode(TransportMeansTypeCodeType $transportMeansTypeCode = null)
    {
        $this->TransportMeansTypeCode = $transportMeansTypeCode;
        return $this;
    }

    /**
     * Get TransitDirectionCode value
     * @return TransitDirectionCodeType|null
     */
    public function getTransitDirectionCode()
    {
        return $this->TransitDirectionCode;
    }

    /**
     * Set TransitDirectionCode value
     * @param TransitDirectionCodeType $transitDirectionCode
     * @return ShipmentStageType
     */
    public function setTransitDirectionCode(TransitDirectionCodeType $transitDirectionCode = null)
    {
        $this->TransitDirectionCode = $transitDirectionCode;
        return $this;
    }

    /**
     * Get Instructions value
     * @return InstructionsType[]|null
     */
    public function getInstructions()
    {
        return $this->Instructions;
    }

    /**
     * This method is responsible for validating the values passed to the setInstructions method
     * This method is willingly generated in order to preserve the one-line inline validation within the setInstructions method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateInstructionsForArrayConstraintsFromSetInstructions(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $shipmentStageTypeInstructionsItem) {
            // validation for constraint: itemType
            if (!$shipmentStageTypeInstructionsItem instanceof InstructionsType) {
                $invalidValues[] = is_object($shipmentStageTypeInstructionsItem) ? get_class($shipmentStageTypeInstructionsItem) : sprintf('%s(%s)', gettype($shipmentStageTypeInstructionsItem), var_export($shipmentStageTypeInstructionsItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Instructions property can only contain items of type \Gek\UyumBahceGet\StructType\InstructionsType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }

    /**
     * Set Instructions value
     * @param InstructionsType[] $instructions
     * @return ShipmentStageType
     * @throws InvalidArgumentException
     */
    public function setInstructions(array $instructions = array())
    {
        // validation for constraint: array
        if ('' !== ($instructionsArrayErrorMessage = self::validateInstructionsForArrayConstraintsFromSetInstructions($instructions))) {
            throw new InvalidArgumentException($instructionsArrayErrorMessage, __LINE__);
        }
        $this->Instructions = $instructions;
        return $this;
    }

    /**
     * Add item to Instructions value
     * @param InstructionsType $item
     * @return ShipmentStageType
     * @throws InvalidArgumentException
     */
    public function addToInstructions(InstructionsType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof InstructionsType) {
            throw new InvalidArgumentException(sprintf('The Instructions property can only contain items of type \Gek\UyumBahceGet\StructType\InstructionsType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Instructions[] = $item;
        return $this;
    }

    /**
     * Get TransitPeriod value
     * @return PeriodType|null
     */
    public function getTransitPeriod()
    {
        return $this->TransitPeriod;
    }

    /**
     * Set TransitPeriod value
     * @param PeriodType $transitPeriod
     * @return ShipmentStageType
     */
    public function setTransitPeriod(PeriodType $transitPeriod = null)
    {
        $this->TransitPeriod = $transitPeriod;
        return $this;
    }

    /**
     * Get TransportMeans value
     * @return TransportMeansType|null
     */
    public function getTransportMeans()
    {
        return $this->TransportMeans;
    }

    /**
     * Set TransportMeans value
     * @param TransportMeansType $transportMeans
     * @return ShipmentStageType
     */
    public function setTransportMeans(TransportMeansType $transportMeans = null)
    {
        $this->TransportMeans = $transportMeans;
        return $this;
    }

    /**
     * Get DriverPerson value
     * @return PersonType[]|null
     */
    public function getDriverPerson()
    {
        return $this->DriverPerson;
    }

    /**
     * This method is responsible for validating the values passed to the setDriverPerson method
     * This method is willingly generated in order to preserve the one-line inline validation within the setDriverPerson method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateDriverPersonForArrayConstraintsFromSetDriverPerson(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $shipmentStageTypeDriverPersonItem) {
            // validation for constraint: itemType
            if (!$shipmentStageTypeDriverPersonItem instanceof PersonType) {
                $invalidValues[] = is_object($shipmentStageTypeDriverPersonItem) ? get_class($shipmentStageTypeDriverPersonItem) : sprintf('%s(%s)', gettype($shipmentStageTypeDriverPersonItem), var_export($shipmentStageTypeDriverPersonItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The DriverPerson property can only contain items of type \Gek\UyumBahceGet\StructType\PersonType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }

    /**
     * Set DriverPerson value
     * @param PersonType[] $driverPerson
     * @return ShipmentStageType
     * @throws InvalidArgumentException
     */
    public function setDriverPerson(array $driverPerson = array())
    {
        // validation for constraint: array
        if ('' !== ($driverPersonArrayErrorMessage = self::validateDriverPersonForArrayConstraintsFromSetDriverPerson($driverPerson))) {
            throw new InvalidArgumentException($driverPersonArrayErrorMessage, __LINE__);
        }
        $this->DriverPerson = $driverPerson;
        return $this;
    }

    /**
     * Add item to DriverPerson value
     * @param PersonType $item
     * @return ShipmentStageType
     * @throws InvalidArgumentException
     */
    public function addToDriverPerson(PersonType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof PersonType) {
            throw new InvalidArgumentException(sprintf('The DriverPerson property can only contain items of type \Gek\UyumBahceGet\StructType\PersonType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->DriverPerson[] = $item;
        return $this;
    }
}
