<?php

namespace Gek\UyumBahceGet\StructType;

use InvalidArgumentException;
use WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ServiceResultOfArrayOfByte StructType
 * @subpackage Structs
 */
class ServiceResultOfArrayOfByte extends AbstractStructBase
{
    /**
     * The Result
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $Result;
    /**
     * The PageIndex
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $PageIndex;
    /**
     * The TotalPage
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $TotalPage;
    /**
     * The Message
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Message;
    /**
     * The Value
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Value;

    /**
     * Constructor method for ServiceResultOfArrayOfByte
     * @param bool $result
     * @param int $pageIndex
     * @param int $totalPage
     * @param string $message
     * @param string $value
     * @uses ServiceResultOfArrayOfByte::setResult()
     * @uses ServiceResultOfArrayOfByte::setPageIndex()
     * @uses ServiceResultOfArrayOfByte::setTotalPage()
     * @uses ServiceResultOfArrayOfByte::setMessage()
     * @uses ServiceResultOfArrayOfByte::setValue()
     */
    public function __construct($result = null, $pageIndex = null, $totalPage = null, $message = null, $value = null)
    {
        $this
            ->setResult($result)
            ->setPageIndex($pageIndex)
            ->setTotalPage($totalPage)
            ->setMessage($message)
            ->setValue($value);
    }

    /**
     * Get Result value
     * @return bool
     */
    public function getResult()
    {
        return $this->Result;
    }

    /**
     * Set Result value
     * @param bool $result
     * @return ServiceResultOfArrayOfByte
     */
    public function setResult($result = null)
    {
        // validation for constraint: boolean
        if (!is_null($result) && !is_bool($result)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($result, true), gettype($result)), __LINE__);
        }
        $this->Result = $result;
        return $this;
    }

    /**
     * Get PageIndex value
     * @return int
     */
    public function getPageIndex()
    {
        return $this->PageIndex;
    }

    /**
     * Set PageIndex value
     * @param int $pageIndex
     * @return ServiceResultOfArrayOfByte
     */
    public function setPageIndex($pageIndex = null)
    {
        // validation for constraint: int
        if (!is_null($pageIndex) && !(is_int($pageIndex) || ctype_digit($pageIndex))) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($pageIndex, true), gettype($pageIndex)), __LINE__);
        }
        $this->PageIndex = $pageIndex;
        return $this;
    }

    /**
     * Get TotalPage value
     * @return int
     */
    public function getTotalPage()
    {
        return $this->TotalPage;
    }

    /**
     * Set TotalPage value
     * @param int $totalPage
     * @return ServiceResultOfArrayOfByte
     */
    public function setTotalPage($totalPage = null)
    {
        // validation for constraint: int
        if (!is_null($totalPage) && !(is_int($totalPage) || ctype_digit($totalPage))) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($totalPage, true), gettype($totalPage)), __LINE__);
        }
        $this->TotalPage = $totalPage;
        return $this;
    }

    /**
     * Get Message value
     * @return string|null
     */
    public function getMessage()
    {
        return $this->Message;
    }

    /**
     * Set Message value
     * @param string $message
     * @return ServiceResultOfArrayOfByte
     */
    public function setMessage($message = null)
    {
        // validation for constraint: string
        if (!is_null($message) && !is_string($message)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($message, true), gettype($message)), __LINE__);
        }
        $this->Message = $message;
        return $this;
    }

    /**
     * Get Value value
     * @return string|null
     */
    public function getValue()
    {
        return $this->Value;
    }

    /**
     * Set Value value
     * @param string $value
     * @return ServiceResultOfArrayOfByte
     */
    public function setValue($value = null)
    {
        // validation for constraint: string
        if (!is_null($value) && !is_string($value)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($value, true), gettype($value)), __LINE__);
        }
        $this->Value = $value;
        return $this;
    }
}
