<?php

namespace Gek\UyumBahceGet\StructType;

use Gek\UyumBahceGet\ArrayType\ArrayOfTransformType;
use InvalidArgumentException;
use WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RetrievalMethodType StructType
 * @subpackage Structs
 */
class RetrievalMethodType extends AbstractStructBase
{
    /**
     * The Transforms
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var ArrayOfTransformType
     */
    public $Transforms;
    /**
     * The Type
     * @var string
     */
    public $Type;
    /**
     * The URI
     * @var string
     */
    public $URI;

    /**
     * Constructor method for RetrievalMethodType
     * @param ArrayOfTransformType $transforms
     * @param string $type
     * @param string $uRI
     * @uses RetrievalMethodType::setTransforms()
     * @uses RetrievalMethodType::setType()
     * @uses RetrievalMethodType::setURI()
     */
    public function __construct(ArrayOfTransformType $transforms = null, $type = null, $uRI = null)
    {
        $this
            ->setTransforms($transforms)
            ->setType($type)
            ->setURI($uRI);
    }

    /**
     * Get Transforms value
     * @return ArrayOfTransformType|null
     */
    public function getTransforms()
    {
        return $this->Transforms;
    }

    /**
     * Set Transforms value
     * @param ArrayOfTransformType $transforms
     * @return RetrievalMethodType
     */
    public function setTransforms(ArrayOfTransformType $transforms = null)
    {
        $this->Transforms = $transforms;
        return $this;
    }

    /**
     * Get Type value
     * @return string|null
     */
    public function getType()
    {
        return $this->Type;
    }

    /**
     * Set Type value
     * @param string $type
     * @return RetrievalMethodType
     */
    public function setType($type = null)
    {
        // validation for constraint: string
        if (!is_null($type) && !is_string($type)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($type, true), gettype($type)), __LINE__);
        }
        $this->Type = $type;
        return $this;
    }

    /**
     * Get URI value
     * @return string|null
     */
    public function getURI()
    {
        return $this->URI;
    }

    /**
     * Set URI value
     * @param string $uRI
     * @return RetrievalMethodType
     */
    public function setURI($uRI = null)
    {
        // validation for constraint: string
        if (!is_null($uRI) && !is_string($uRI)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($uRI, true), gettype($uRI)), __LINE__);
        }
        $this->URI = $uRI;
        return $this;
    }
}
