<?php

namespace Gek\UyumBahceGet\StructType;

use InvalidArgumentException;
use WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for QuantityType StructType
 * @subpackage Structs
 */
class QuantityType extends AbstractStructBase
{
    /**
     * The _
     * @var QuantityType
     */
    public $_;
    /**
     * The unitCode
     * @var string
     */
    public $unitCode;
    /**
     * The unitCodeListID
     * @var string
     */
    public $unitCodeListID;
    /**
     * The unitCodeListAgencyID
     * @var string
     */
    public $unitCodeListAgencyID;
    /**
     * The unitCodeListAgencyName
     * @var string
     */
    public $unitCodeListAgencyName;

    /**
     * Constructor method for QuantityType
     * @param QuantityType $_
     * @param string $unitCode
     * @param string $unitCodeListID
     * @param string $unitCodeListAgencyID
     * @param string $unitCodeListAgencyName
     * @uses QuantityType::set_()
     * @uses QuantityType::setUnitCode()
     * @uses QuantityType::setUnitCodeListID()
     * @uses QuantityType::setUnitCodeListAgencyID()
     * @uses QuantityType::setUnitCodeListAgencyName()
     */
    public function __construct(QuantityType $_ = null, $unitCode = null, $unitCodeListID = null, $unitCodeListAgencyID = null, $unitCodeListAgencyName = null)
    {
        $this
            ->set_($_)
            ->setUnitCode($unitCode)
            ->setUnitCodeListID($unitCodeListID)
            ->setUnitCodeListAgencyID($unitCodeListAgencyID)
            ->setUnitCodeListAgencyName($unitCodeListAgencyName);
    }

    /**
     * Get _ value
     * @return QuantityType|null
     */
    public function get_()
    {
        return $this->_;
    }

    /**
     * Set _ value
     * @param QuantityType $_
     * @return QuantityType
     */
    public function set_(QuantityType $_ = null)
    {
        $this->_ = $_;
        return $this;
    }

    /**
     * Get unitCode value
     * @return string|null
     */
    public function getUnitCode()
    {
        return $this->unitCode;
    }

    /**
     * Set unitCode value
     * @param string $unitCode
     * @return QuantityType
     */
    public function setUnitCode($unitCode = null)
    {
        // validation for constraint: string
        if (!is_null($unitCode) && !is_string($unitCode)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($unitCode, true), gettype($unitCode)), __LINE__);
        }
        $this->unitCode = $unitCode;
        return $this;
    }

    /**
     * Get unitCodeListID value
     * @return string|null
     */
    public function getUnitCodeListID()
    {
        return $this->unitCodeListID;
    }

    /**
     * Set unitCodeListID value
     * @param string $unitCodeListID
     * @return QuantityType
     */
    public function setUnitCodeListID($unitCodeListID = null)
    {
        // validation for constraint: string
        if (!is_null($unitCodeListID) && !is_string($unitCodeListID)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($unitCodeListID, true), gettype($unitCodeListID)), __LINE__);
        }
        $this->unitCodeListID = $unitCodeListID;
        return $this;
    }

    /**
     * Get unitCodeListAgencyID value
     * @return string|null
     */
    public function getUnitCodeListAgencyID()
    {
        return $this->unitCodeListAgencyID;
    }

    /**
     * Set unitCodeListAgencyID value
     * @param string $unitCodeListAgencyID
     * @return QuantityType
     */
    public function setUnitCodeListAgencyID($unitCodeListAgencyID = null)
    {
        // validation for constraint: string
        if (!is_null($unitCodeListAgencyID) && !is_string($unitCodeListAgencyID)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($unitCodeListAgencyID, true), gettype($unitCodeListAgencyID)), __LINE__);
        }
        $this->unitCodeListAgencyID = $unitCodeListAgencyID;
        return $this;
    }

    /**
     * Get unitCodeListAgencyName value
     * @return string|null
     */
    public function getUnitCodeListAgencyName()
    {
        return $this->unitCodeListAgencyName;
    }

    /**
     * Set unitCodeListAgencyName value
     * @param string $unitCodeListAgencyName
     * @return QuantityType
     */
    public function setUnitCodeListAgencyName($unitCodeListAgencyName = null)
    {
        // validation for constraint: string
        if (!is_null($unitCodeListAgencyName) && !is_string($unitCodeListAgencyName)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($unitCodeListAgencyName, true), gettype($unitCodeListAgencyName)), __LINE__);
        }
        $this->unitCodeListAgencyName = $unitCodeListAgencyName;
        return $this;
    }
}
