<?php

namespace Gek\UyumBahceGet\StructType;

use WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PaymentTermsType StructType
 * @subpackage Structs
 */
class PaymentTermsType extends AbstractStructBase
{
    /**
     * The Note
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: s4:Note
     * @var NoteType
     */
    public $Note;
    /**
     * The PenaltySurchargePercent
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: s4:PenaltySurchargePercent
     * @var PenaltySurchargePercentType
     */
    public $PenaltySurchargePercent;
    /**
     * The Amount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: s4:Amount
     * @var AmountType
     */
    public $Amount;
    /**
     * The PenaltyAmount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: s4:PenaltyAmount
     * @var PenaltyAmountType
     */
    public $PenaltyAmount;
    /**
     * The PaymentDueDate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: s4:PaymentDueDate
     * @var PaymentDueDateType
     */
    public $PaymentDueDate;
    /**
     * The SettlementPeriod
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var PeriodType
     */
    public $SettlementPeriod;

    /**
     * Constructor method for PaymentTermsType
     * @param NoteType $note
     * @param PenaltySurchargePercentType $penaltySurchargePercent
     * @param AmountType $amount
     * @param PenaltyAmountType $penaltyAmount
     * @param PaymentDueDateType $paymentDueDate
     * @param PeriodType $settlementPeriod
     * @uses PaymentTermsType::setNote()
     * @uses PaymentTermsType::setPenaltySurchargePercent()
     * @uses PaymentTermsType::setAmount()
     * @uses PaymentTermsType::setPenaltyAmount()
     * @uses PaymentTermsType::setPaymentDueDate()
     * @uses PaymentTermsType::setSettlementPeriod()
     */
    public function __construct(NoteType $note = null, PenaltySurchargePercentType $penaltySurchargePercent = null, AmountType $amount = null, PenaltyAmountType $penaltyAmount = null, PaymentDueDateType $paymentDueDate = null, PeriodType $settlementPeriod = null)
    {
        $this
            ->setNote($note)
            ->setPenaltySurchargePercent($penaltySurchargePercent)
            ->setAmount($amount)
            ->setPenaltyAmount($penaltyAmount)
            ->setPaymentDueDate($paymentDueDate)
            ->setSettlementPeriod($settlementPeriod);
    }

    /**
     * Get Note value
     * @return NoteType|null
     */
    public function getNote()
    {
        return $this->Note;
    }

    /**
     * Set Note value
     * @param NoteType $note
     * @return PaymentTermsType
     */
    public function setNote(NoteType $note = null)
    {
        $this->Note = $note;
        return $this;
    }

    /**
     * Get PenaltySurchargePercent value
     * @return PenaltySurchargePercentType|null
     */
    public function getPenaltySurchargePercent()
    {
        return $this->PenaltySurchargePercent;
    }

    /**
     * Set PenaltySurchargePercent value
     * @param PenaltySurchargePercentType $penaltySurchargePercent
     * @return PaymentTermsType
     */
    public function setPenaltySurchargePercent(PenaltySurchargePercentType $penaltySurchargePercent = null)
    {
        $this->PenaltySurchargePercent = $penaltySurchargePercent;
        return $this;
    }

    /**
     * Get Amount value
     * @return AmountType|null
     */
    public function getAmount()
    {
        return $this->Amount;
    }

    /**
     * Set Amount value
     * @param AmountType $amount
     * @return PaymentTermsType
     */
    public function setAmount(AmountType $amount = null)
    {
        $this->Amount = $amount;
        return $this;
    }

    /**
     * Get PenaltyAmount value
     * @return PenaltyAmountType|null
     */
    public function getPenaltyAmount()
    {
        return $this->PenaltyAmount;
    }

    /**
     * Set PenaltyAmount value
     * @param PenaltyAmountType $penaltyAmount
     * @return PaymentTermsType
     */
    public function setPenaltyAmount(PenaltyAmountType $penaltyAmount = null)
    {
        $this->PenaltyAmount = $penaltyAmount;
        return $this;
    }

    /**
     * Get PaymentDueDate value
     * @return PaymentDueDateType|null
     */
    public function getPaymentDueDate()
    {
        return $this->PaymentDueDate;
    }

    /**
     * Set PaymentDueDate value
     * @param PaymentDueDateType $paymentDueDate
     * @return PaymentTermsType
     */
    public function setPaymentDueDate(PaymentDueDateType $paymentDueDate = null)
    {
        $this->PaymentDueDate = $paymentDueDate;
        return $this;
    }

    /**
     * Get SettlementPeriod value
     * @return PeriodType|null
     */
    public function getSettlementPeriod()
    {
        return $this->SettlementPeriod;
    }

    /**
     * Set SettlementPeriod value
     * @param PeriodType $settlementPeriod
     * @return PaymentTermsType
     */
    public function setSettlementPeriod(PeriodType $settlementPeriod = null)
    {
        $this->SettlementPeriod = $settlementPeriod;
        return $this;
    }
}
