<?php

namespace Gek\UyumBahceGet\StructType;

use WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PaymentMeansType StructType
 * @subpackage Structs
 */
class PaymentMeansType extends AbstractStructBase
{
    /**
     * The PaymentMeansCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: s4:PaymentMeansCode
     * @var PaymentMeansCodeType
     */
    public $PaymentMeansCode;
    /**
     * The PaymentDueDate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: s4:PaymentDueDate
     * @var PaymentDueDateType
     */
    public $PaymentDueDate;
    /**
     * The PaymentChannelCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: s4:PaymentChannelCode
     * @var PaymentChannelCodeType
     */
    public $PaymentChannelCode;
    /**
     * The InstructionNote
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: s4:InstructionNote
     * @var InstructionNoteType
     */
    public $InstructionNote;
    /**
     * The PayerFinancialAccount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var FinancialAccountType
     */
    public $PayerFinancialAccount;
    /**
     * The PayeeFinancialAccount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var FinancialAccountType
     */
    public $PayeeFinancialAccount;

    /**
     * Constructor method for PaymentMeansType
     * @param PaymentMeansCodeType $paymentMeansCode
     * @param PaymentDueDateType $paymentDueDate
     * @param PaymentChannelCodeType $paymentChannelCode
     * @param InstructionNoteType $instructionNote
     * @param FinancialAccountType $payerFinancialAccount
     * @param FinancialAccountType $payeeFinancialAccount
     * @uses PaymentMeansType::setPaymentMeansCode()
     * @uses PaymentMeansType::setPaymentDueDate()
     * @uses PaymentMeansType::setPaymentChannelCode()
     * @uses PaymentMeansType::setInstructionNote()
     * @uses PaymentMeansType::setPayerFinancialAccount()
     * @uses PaymentMeansType::setPayeeFinancialAccount()
     */
    public function __construct(PaymentMeansCodeType $paymentMeansCode = null, PaymentDueDateType $paymentDueDate = null, PaymentChannelCodeType $paymentChannelCode = null, InstructionNoteType $instructionNote = null, FinancialAccountType $payerFinancialAccount = null, FinancialAccountType $payeeFinancialAccount = null)
    {
        $this
            ->setPaymentMeansCode($paymentMeansCode)
            ->setPaymentDueDate($paymentDueDate)
            ->setPaymentChannelCode($paymentChannelCode)
            ->setInstructionNote($instructionNote)
            ->setPayerFinancialAccount($payerFinancialAccount)
            ->setPayeeFinancialAccount($payeeFinancialAccount);
    }

    /**
     * Get PaymentMeansCode value
     * @return PaymentMeansCodeType|null
     */
    public function getPaymentMeansCode()
    {
        return $this->PaymentMeansCode;
    }

    /**
     * Set PaymentMeansCode value
     * @param PaymentMeansCodeType $paymentMeansCode
     * @return PaymentMeansType
     */
    public function setPaymentMeansCode(PaymentMeansCodeType $paymentMeansCode = null)
    {
        $this->PaymentMeansCode = $paymentMeansCode;
        return $this;
    }

    /**
     * Get PaymentDueDate value
     * @return PaymentDueDateType|null
     */
    public function getPaymentDueDate()
    {
        return $this->PaymentDueDate;
    }

    /**
     * Set PaymentDueDate value
     * @param PaymentDueDateType $paymentDueDate
     * @return PaymentMeansType
     */
    public function setPaymentDueDate(PaymentDueDateType $paymentDueDate = null)
    {
        $this->PaymentDueDate = $paymentDueDate;
        return $this;
    }

    /**
     * Get PaymentChannelCode value
     * @return PaymentChannelCodeType|null
     */
    public function getPaymentChannelCode()
    {
        return $this->PaymentChannelCode;
    }

    /**
     * Set PaymentChannelCode value
     * @param PaymentChannelCodeType $paymentChannelCode
     * @return PaymentMeansType
     */
    public function setPaymentChannelCode(PaymentChannelCodeType $paymentChannelCode = null)
    {
        $this->PaymentChannelCode = $paymentChannelCode;
        return $this;
    }

    /**
     * Get InstructionNote value
     * @return InstructionNoteType|null
     */
    public function getInstructionNote()
    {
        return $this->InstructionNote;
    }

    /**
     * Set InstructionNote value
     * @param InstructionNoteType $instructionNote
     * @return PaymentMeansType
     */
    public function setInstructionNote(InstructionNoteType $instructionNote = null)
    {
        $this->InstructionNote = $instructionNote;
        return $this;
    }

    /**
     * Get PayerFinancialAccount value
     * @return FinancialAccountType|null
     */
    public function getPayerFinancialAccount()
    {
        return $this->PayerFinancialAccount;
    }

    /**
     * Set PayerFinancialAccount value
     * @param FinancialAccountType $payerFinancialAccount
     * @return PaymentMeansType
     */
    public function setPayerFinancialAccount(FinancialAccountType $payerFinancialAccount = null)
    {
        $this->PayerFinancialAccount = $payerFinancialAccount;
        return $this;
    }

    /**
     * Get PayeeFinancialAccount value
     * @return FinancialAccountType|null
     */
    public function getPayeeFinancialAccount()
    {
        return $this->PayeeFinancialAccount;
    }

    /**
     * Set PayeeFinancialAccount value
     * @param FinancialAccountType $payeeFinancialAccount
     * @return PaymentMeansType
     */
    public function setPayeeFinancialAccount(FinancialAccountType $payeeFinancialAccount = null)
    {
        $this->PayeeFinancialAccount = $payeeFinancialAccount;
        return $this;
    }
}
