<?php

namespace Gek\UyumBahceGet\StructType;

use InvalidArgumentException;
use WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PartyType StructType
 * @subpackage Structs
 */
class PartyType extends AbstractStructBase
{
    /**
     * The WebsiteURI
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: s4:WebsiteURI
     * @var WebsiteURIType
     */
    public $WebsiteURI;
    /**
     * The EndpointID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: s4:EndpointID
     * @var EndpointIDType
     */
    public $EndpointID;
    /**
     * The IndustryClassificationCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: s4:IndustryClassificationCode
     * @var IndustryClassificationCodeType
     */
    public $IndustryClassificationCode;
    /**
     * The PartyIdentification
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var PartyIdentificationType[]
     */
    public $PartyIdentification;
    /**
     * The PartyName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var PartyNameType
     */
    public $PartyName;
    /**
     * The PostalAddress
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var AddressType
     */
    public $PostalAddress;
    /**
     * The PhysicalLocation
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var LocationType
     */
    public $PhysicalLocation;
    /**
     * The PartyTaxScheme
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var PartyTaxSchemeType
     */
    public $PartyTaxScheme;
    /**
     * The PartyLegalEntity
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var PartyLegalEntityType[]
     */
    public $PartyLegalEntity;
    /**
     * The Contact
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var ContactType
     */
    public $Contact;
    /**
     * The Person
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var PersonType
     */
    public $Person;
    /**
     * The AgentParty
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var PartyType
     */
    public $AgentParty;

    /**
     * Constructor method for PartyType
     * @param WebsiteURIType $websiteURI
     * @param EndpointIDType $endpointID
     * @param IndustryClassificationCodeType $industryClassificationCode
     * @param PartyIdentificationType[] $partyIdentification
     * @param PartyNameType $partyName
     * @param AddressType $postalAddress
     * @param LocationType $physicalLocation
     * @param PartyTaxSchemeType $partyTaxScheme
     * @param PartyLegalEntityType[] $partyLegalEntity
     * @param ContactType $contact
     * @param PersonType $person
     * @param PartyType $agentParty
     * @uses PartyType::setWebsiteURI()
     * @uses PartyType::setEndpointID()
     * @uses PartyType::setIndustryClassificationCode()
     * @uses PartyType::setPartyIdentification()
     * @uses PartyType::setPartyName()
     * @uses PartyType::setPostalAddress()
     * @uses PartyType::setPhysicalLocation()
     * @uses PartyType::setPartyTaxScheme()
     * @uses PartyType::setPartyLegalEntity()
     * @uses PartyType::setContact()
     * @uses PartyType::setPerson()
     * @uses PartyType::setAgentParty()
     */
    public function __construct(WebsiteURIType $websiteURI = null, EndpointIDType $endpointID = null, IndustryClassificationCodeType $industryClassificationCode = null, array $partyIdentification = array(), PartyNameType $partyName = null, AddressType $postalAddress = null, LocationType $physicalLocation = null, PartyTaxSchemeType $partyTaxScheme = null, array $partyLegalEntity = array(), ContactType $contact = null, PersonType $person = null, PartyType $agentParty = null)
    {
        $this
            ->setWebsiteURI($websiteURI)
            ->setEndpointID($endpointID)
            ->setIndustryClassificationCode($industryClassificationCode)
            ->setPartyIdentification($partyIdentification)
            ->setPartyName($partyName)
            ->setPostalAddress($postalAddress)
            ->setPhysicalLocation($physicalLocation)
            ->setPartyTaxScheme($partyTaxScheme)
            ->setPartyLegalEntity($partyLegalEntity)
            ->setContact($contact)
            ->setPerson($person)
            ->setAgentParty($agentParty);
    }

    /**
     * Get WebsiteURI value
     * @return WebsiteURIType|null
     */
    public function getWebsiteURI()
    {
        return $this->WebsiteURI;
    }

    /**
     * Set WebsiteURI value
     * @param WebsiteURIType $websiteURI
     * @return PartyType
     */
    public function setWebsiteURI(WebsiteURIType $websiteURI = null)
    {
        $this->WebsiteURI = $websiteURI;
        return $this;
    }

    /**
     * Get EndpointID value
     * @return EndpointIDType|null
     */
    public function getEndpointID()
    {
        return $this->EndpointID;
    }

    /**
     * Set EndpointID value
     * @param EndpointIDType $endpointID
     * @return PartyType
     */
    public function setEndpointID(EndpointIDType $endpointID = null)
    {
        $this->EndpointID = $endpointID;
        return $this;
    }

    /**
     * Get IndustryClassificationCode value
     * @return IndustryClassificationCodeType|null
     */
    public function getIndustryClassificationCode()
    {
        return $this->IndustryClassificationCode;
    }

    /**
     * Set IndustryClassificationCode value
     * @param IndustryClassificationCodeType $industryClassificationCode
     * @return PartyType
     */
    public function setIndustryClassificationCode(IndustryClassificationCodeType $industryClassificationCode = null)
    {
        $this->IndustryClassificationCode = $industryClassificationCode;
        return $this;
    }

    /**
     * Get PartyIdentification value
     * @return PartyIdentificationType[]|null
     */
    public function getPartyIdentification()
    {
        return $this->PartyIdentification;
    }

    /**
     * This method is responsible for validating the values passed to the setPartyIdentification method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPartyIdentification method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validatePartyIdentificationForArrayConstraintsFromSetPartyIdentification(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $partyTypePartyIdentificationItem) {
            // validation for constraint: itemType
            if (!$partyTypePartyIdentificationItem instanceof PartyIdentificationType) {
                $invalidValues[] = is_object($partyTypePartyIdentificationItem) ? get_class($partyTypePartyIdentificationItem) : sprintf('%s(%s)', gettype($partyTypePartyIdentificationItem), var_export($partyTypePartyIdentificationItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The PartyIdentification property can only contain items of type \Gek\UyumBahceGet\StructType\PartyIdentificationType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }

    /**
     * Set PartyIdentification value
     * @param PartyIdentificationType[] $partyIdentification
     * @return PartyType
     * @throws InvalidArgumentException
     */
    public function setPartyIdentification(array $partyIdentification = array())
    {
        // validation for constraint: array
        if ('' !== ($partyIdentificationArrayErrorMessage = self::validatePartyIdentificationForArrayConstraintsFromSetPartyIdentification($partyIdentification))) {
            throw new InvalidArgumentException($partyIdentificationArrayErrorMessage, __LINE__);
        }
        $this->PartyIdentification = $partyIdentification;
        return $this;
    }

    /**
     * Add item to PartyIdentification value
     * @param PartyIdentificationType $item
     * @return PartyType
     * @throws InvalidArgumentException
     */
    public function addToPartyIdentification(PartyIdentificationType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof PartyIdentificationType) {
            throw new InvalidArgumentException(sprintf('The PartyIdentification property can only contain items of type \Gek\UyumBahceGet\StructType\PartyIdentificationType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->PartyIdentification[] = $item;
        return $this;
    }

    /**
     * Get PartyName value
     * @return PartyNameType|null
     */
    public function getPartyName()
    {
        return $this->PartyName;
    }

    /**
     * Set PartyName value
     * @param PartyNameType $partyName
     * @return PartyType
     */
    public function setPartyName(PartyNameType $partyName = null)
    {
        $this->PartyName = $partyName;
        return $this;
    }

    /**
     * Get PostalAddress value
     * @return AddressType|null
     */
    public function getPostalAddress()
    {
        return $this->PostalAddress;
    }

    /**
     * Set PostalAddress value
     * @param AddressType $postalAddress
     * @return PartyType
     */
    public function setPostalAddress(AddressType $postalAddress = null)
    {
        $this->PostalAddress = $postalAddress;
        return $this;
    }

    /**
     * Get PhysicalLocation value
     * @return LocationType|null
     */
    public function getPhysicalLocation()
    {
        return $this->PhysicalLocation;
    }

    /**
     * Set PhysicalLocation value
     * @param LocationType $physicalLocation
     * @return PartyType
     */
    public function setPhysicalLocation(LocationType $physicalLocation = null)
    {
        $this->PhysicalLocation = $physicalLocation;
        return $this;
    }

    /**
     * Get PartyTaxScheme value
     * @return PartyTaxSchemeType|null
     */
    public function getPartyTaxScheme()
    {
        return $this->PartyTaxScheme;
    }

    /**
     * Set PartyTaxScheme value
     * @param PartyTaxSchemeType $partyTaxScheme
     * @return PartyType
     */
    public function setPartyTaxScheme(PartyTaxSchemeType $partyTaxScheme = null)
    {
        $this->PartyTaxScheme = $partyTaxScheme;
        return $this;
    }

    /**
     * Get PartyLegalEntity value
     * @return PartyLegalEntityType[]|null
     */
    public function getPartyLegalEntity()
    {
        return $this->PartyLegalEntity;
    }

    /**
     * This method is responsible for validating the values passed to the setPartyLegalEntity method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPartyLegalEntity method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validatePartyLegalEntityForArrayConstraintsFromSetPartyLegalEntity(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $partyTypePartyLegalEntityItem) {
            // validation for constraint: itemType
            if (!$partyTypePartyLegalEntityItem instanceof PartyLegalEntityType) {
                $invalidValues[] = is_object($partyTypePartyLegalEntityItem) ? get_class($partyTypePartyLegalEntityItem) : sprintf('%s(%s)', gettype($partyTypePartyLegalEntityItem), var_export($partyTypePartyLegalEntityItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The PartyLegalEntity property can only contain items of type \Gek\UyumBahceGet\StructType\PartyLegalEntityType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }

    /**
     * Set PartyLegalEntity value
     * @param PartyLegalEntityType[] $partyLegalEntity
     * @return PartyType
     * @throws InvalidArgumentException
     */
    public function setPartyLegalEntity(array $partyLegalEntity = array())
    {
        // validation for constraint: array
        if ('' !== ($partyLegalEntityArrayErrorMessage = self::validatePartyLegalEntityForArrayConstraintsFromSetPartyLegalEntity($partyLegalEntity))) {
            throw new InvalidArgumentException($partyLegalEntityArrayErrorMessage, __LINE__);
        }
        $this->PartyLegalEntity = $partyLegalEntity;
        return $this;
    }

    /**
     * Add item to PartyLegalEntity value
     * @param PartyLegalEntityType $item
     * @return PartyType
     * @throws InvalidArgumentException
     */
    public function addToPartyLegalEntity(PartyLegalEntityType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof PartyLegalEntityType) {
            throw new InvalidArgumentException(sprintf('The PartyLegalEntity property can only contain items of type \Gek\UyumBahceGet\StructType\PartyLegalEntityType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->PartyLegalEntity[] = $item;
        return $this;
    }

    /**
     * Get Contact value
     * @return ContactType|null
     */
    public function getContact()
    {
        return $this->Contact;
    }

    /**
     * Set Contact value
     * @param ContactType $contact
     * @return PartyType
     */
    public function setContact(ContactType $contact = null)
    {
        $this->Contact = $contact;
        return $this;
    }

    /**
     * Get Person value
     * @return PersonType|null
     */
    public function getPerson()
    {
        return $this->Person;
    }

    /**
     * Set Person value
     * @param PersonType $person
     * @return PartyType
     */
    public function setPerson(PersonType $person = null)
    {
        $this->Person = $person;
        return $this;
    }

    /**
     * Get AgentParty value
     * @return PartyType|null
     */
    public function getAgentParty()
    {
        return $this->AgentParty;
    }

    /**
     * Set AgentParty value
     * @param PartyType $agentParty
     * @return PartyType
     */
    public function setAgentParty(PartyType $agentParty = null)
    {
        $this->AgentParty = $agentParty;
        return $this;
    }
}
