<?php

namespace Gek\UyumBahceGet\StructType;

use WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PartyLegalEntityType StructType
 * @subpackage Structs
 */
class PartyLegalEntityType extends AbstractStructBase
{
    /**
     * The RegistrationName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: s4:RegistrationName
     * @var RegistrationNameType
     */
    public $RegistrationName;
    /**
     * The CompanyID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: s4:CompanyID
     * @var CompanyIDType
     */
    public $CompanyID;
    /**
     * The RegistrationDate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: s4:RegistrationDate
     * @var RegistrationDateType
     */
    public $RegistrationDate;
    /**
     * The SoleProprietorshipIndicator
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: s4:SoleProprietorshipIndicator
     * @var SoleProprietorshipIndicatorType
     */
    public $SoleProprietorshipIndicator;
    /**
     * The CorporateStockAmount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: s4:CorporateStockAmount
     * @var CorporateStockAmountType
     */
    public $CorporateStockAmount;
    /**
     * The FullyPaidSharesIndicator
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: s4:FullyPaidSharesIndicator
     * @var FullyPaidSharesIndicatorType
     */
    public $FullyPaidSharesIndicator;
    /**
     * The CorporateRegistrationScheme
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var CorporateRegistrationSchemeType
     */
    public $CorporateRegistrationScheme;
    /**
     * The HeadOfficeParty
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var PartyType
     */
    public $HeadOfficeParty;

    /**
     * Constructor method for PartyLegalEntityType
     * @param RegistrationNameType $registrationName
     * @param CompanyIDType $companyID
     * @param RegistrationDateType $registrationDate
     * @param SoleProprietorshipIndicatorType $soleProprietorshipIndicator
     * @param CorporateStockAmountType $corporateStockAmount
     * @param FullyPaidSharesIndicatorType $fullyPaidSharesIndicator
     * @param CorporateRegistrationSchemeType $corporateRegistrationScheme
     * @param PartyType $headOfficeParty
     * @uses PartyLegalEntityType::setRegistrationName()
     * @uses PartyLegalEntityType::setCompanyID()
     * @uses PartyLegalEntityType::setRegistrationDate()
     * @uses PartyLegalEntityType::setSoleProprietorshipIndicator()
     * @uses PartyLegalEntityType::setCorporateStockAmount()
     * @uses PartyLegalEntityType::setFullyPaidSharesIndicator()
     * @uses PartyLegalEntityType::setCorporateRegistrationScheme()
     * @uses PartyLegalEntityType::setHeadOfficeParty()
     */
    public function __construct(RegistrationNameType $registrationName = null, CompanyIDType $companyID = null, RegistrationDateType $registrationDate = null, SoleProprietorshipIndicatorType $soleProprietorshipIndicator = null, CorporateStockAmountType $corporateStockAmount = null, FullyPaidSharesIndicatorType $fullyPaidSharesIndicator = null, CorporateRegistrationSchemeType $corporateRegistrationScheme = null, PartyType $headOfficeParty = null)
    {
        $this
            ->setRegistrationName($registrationName)
            ->setCompanyID($companyID)
            ->setRegistrationDate($registrationDate)
            ->setSoleProprietorshipIndicator($soleProprietorshipIndicator)
            ->setCorporateStockAmount($corporateStockAmount)
            ->setFullyPaidSharesIndicator($fullyPaidSharesIndicator)
            ->setCorporateRegistrationScheme($corporateRegistrationScheme)
            ->setHeadOfficeParty($headOfficeParty);
    }

    /**
     * Get RegistrationName value
     * @return RegistrationNameType|null
     */
    public function getRegistrationName()
    {
        return $this->RegistrationName;
    }

    /**
     * Set RegistrationName value
     * @param RegistrationNameType $registrationName
     * @return PartyLegalEntityType
     */
    public function setRegistrationName(RegistrationNameType $registrationName = null)
    {
        $this->RegistrationName = $registrationName;
        return $this;
    }

    /**
     * Get CompanyID value
     * @return CompanyIDType|null
     */
    public function getCompanyID()
    {
        return $this->CompanyID;
    }

    /**
     * Set CompanyID value
     * @param CompanyIDType $companyID
     * @return PartyLegalEntityType
     */
    public function setCompanyID(CompanyIDType $companyID = null)
    {
        $this->CompanyID = $companyID;
        return $this;
    }

    /**
     * Get RegistrationDate value
     * @return RegistrationDateType|null
     */
    public function getRegistrationDate()
    {
        return $this->RegistrationDate;
    }

    /**
     * Set RegistrationDate value
     * @param RegistrationDateType $registrationDate
     * @return PartyLegalEntityType
     */
    public function setRegistrationDate(RegistrationDateType $registrationDate = null)
    {
        $this->RegistrationDate = $registrationDate;
        return $this;
    }

    /**
     * Get SoleProprietorshipIndicator value
     * @return SoleProprietorshipIndicatorType|null
     */
    public function getSoleProprietorshipIndicator()
    {
        return $this->SoleProprietorshipIndicator;
    }

    /**
     * Set SoleProprietorshipIndicator value
     * @param SoleProprietorshipIndicatorType $soleProprietorshipIndicator
     * @return PartyLegalEntityType
     */
    public function setSoleProprietorshipIndicator(SoleProprietorshipIndicatorType $soleProprietorshipIndicator = null)
    {
        $this->SoleProprietorshipIndicator = $soleProprietorshipIndicator;
        return $this;
    }

    /**
     * Get CorporateStockAmount value
     * @return CorporateStockAmountType|null
     */
    public function getCorporateStockAmount()
    {
        return $this->CorporateStockAmount;
    }

    /**
     * Set CorporateStockAmount value
     * @param CorporateStockAmountType $corporateStockAmount
     * @return PartyLegalEntityType
     */
    public function setCorporateStockAmount(CorporateStockAmountType $corporateStockAmount = null)
    {
        $this->CorporateStockAmount = $corporateStockAmount;
        return $this;
    }

    /**
     * Get FullyPaidSharesIndicator value
     * @return FullyPaidSharesIndicatorType|null
     */
    public function getFullyPaidSharesIndicator()
    {
        return $this->FullyPaidSharesIndicator;
    }

    /**
     * Set FullyPaidSharesIndicator value
     * @param FullyPaidSharesIndicatorType $fullyPaidSharesIndicator
     * @return PartyLegalEntityType
     */
    public function setFullyPaidSharesIndicator(FullyPaidSharesIndicatorType $fullyPaidSharesIndicator = null)
    {
        $this->FullyPaidSharesIndicator = $fullyPaidSharesIndicator;
        return $this;
    }

    /**
     * Get CorporateRegistrationScheme value
     * @return CorporateRegistrationSchemeType|null
     */
    public function getCorporateRegistrationScheme()
    {
        return $this->CorporateRegistrationScheme;
    }

    /**
     * Set CorporateRegistrationScheme value
     * @param CorporateRegistrationSchemeType $corporateRegistrationScheme
     * @return PartyLegalEntityType
     */
    public function setCorporateRegistrationScheme(CorporateRegistrationSchemeType $corporateRegistrationScheme = null)
    {
        $this->CorporateRegistrationScheme = $corporateRegistrationScheme;
        return $this;
    }

    /**
     * Get HeadOfficeParty value
     * @return PartyType|null
     */
    public function getHeadOfficeParty()
    {
        return $this->HeadOfficeParty;
    }

    /**
     * Set HeadOfficeParty value
     * @param PartyType $headOfficeParty
     * @return PartyLegalEntityType
     */
    public function setHeadOfficeParty(PartyType $headOfficeParty = null)
    {
        $this->HeadOfficeParty = $headOfficeParty;
        return $this;
    }
}
