<?php

namespace Gek\UyumBahceGet\StructType;

use InvalidArgumentException;
use WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PagedResponseOfInvoiceInfo StructType
 * @subpackage Structs
 */
class PagedResponseOfInvoiceInfo extends AbstractStructBase
{
    /**
     * The TotalCount
     * Meta information extracted from the WSDL
     * - use: required
     * @var int
     */
    public $TotalCount;
    /**
     * The TotalPages
     * Meta information extracted from the WSDL
     * - use: required
     * @var int
     */
    public $TotalPages;
    /**
     * The PageIndex
     * Meta information extracted from the WSDL
     * - use: required
     * @var int
     */
    public $PageIndex;
    /**
     * The PageSize
     * Meta information extracted from the WSDL
     * - use: required
     * @var int
     */
    public $PageSize;
    /**
     * The Items
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var InvoiceInfo[]
     */
    public $Items;

    /**
     * Constructor method for PagedResponseOfInvoiceInfo
     * @param int $totalCount
     * @param int $totalPages
     * @param int $pageIndex
     * @param int $pageSize
     * @param InvoiceInfo[] $items
     * @uses PagedResponseOfInvoiceInfo::setTotalCount()
     * @uses PagedResponseOfInvoiceInfo::setTotalPages()
     * @uses PagedResponseOfInvoiceInfo::setPageIndex()
     * @uses PagedResponseOfInvoiceInfo::setPageSize()
     * @uses PagedResponseOfInvoiceInfo::setItems()
     */
    public function __construct($totalCount = null, $totalPages = null, $pageIndex = null, $pageSize = null, array $items = array())
    {
        $this
            ->setTotalCount($totalCount)
            ->setTotalPages($totalPages)
            ->setPageIndex($pageIndex)
            ->setPageSize($pageSize)
            ->setItems($items);
    }

    /**
     * Get TotalCount value
     * @return int
     */
    public function getTotalCount()
    {
        return $this->TotalCount;
    }

    /**
     * Set TotalCount value
     * @param int $totalCount
     * @return PagedResponseOfInvoiceInfo
     */
    public function setTotalCount($totalCount = null)
    {
        // validation for constraint: int
        if (!is_null($totalCount) && !(is_int($totalCount) || ctype_digit($totalCount))) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($totalCount, true), gettype($totalCount)), __LINE__);
        }
        $this->TotalCount = $totalCount;
        return $this;
    }

    /**
     * Get TotalPages value
     * @return int
     */
    public function getTotalPages()
    {
        return $this->TotalPages;
    }

    /**
     * Set TotalPages value
     * @param int $totalPages
     * @return PagedResponseOfInvoiceInfo
     */
    public function setTotalPages($totalPages = null)
    {
        // validation for constraint: int
        if (!is_null($totalPages) && !(is_int($totalPages) || ctype_digit($totalPages))) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($totalPages, true), gettype($totalPages)), __LINE__);
        }
        $this->TotalPages = $totalPages;
        return $this;
    }

    /**
     * Get PageIndex value
     * @return int
     */
    public function getPageIndex()
    {
        return $this->PageIndex;
    }

    /**
     * Set PageIndex value
     * @param int $pageIndex
     * @return PagedResponseOfInvoiceInfo
     */
    public function setPageIndex($pageIndex = null)
    {
        // validation for constraint: int
        if (!is_null($pageIndex) && !(is_int($pageIndex) || ctype_digit($pageIndex))) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($pageIndex, true), gettype($pageIndex)), __LINE__);
        }
        $this->PageIndex = $pageIndex;
        return $this;
    }

    /**
     * Get PageSize value
     * @return int
     */
    public function getPageSize()
    {
        return $this->PageSize;
    }

    /**
     * Set PageSize value
     * @param int $pageSize
     * @return PagedResponseOfInvoiceInfo
     */
    public function setPageSize($pageSize = null)
    {
        // validation for constraint: int
        if (!is_null($pageSize) && !(is_int($pageSize) || ctype_digit($pageSize))) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($pageSize, true), gettype($pageSize)), __LINE__);
        }
        $this->PageSize = $pageSize;
        return $this;
    }

    /**
     * Get Items value
     * @return InvoiceInfo[]|null
     */
    public function getItems()
    {
        return $this->Items;
    }

    /**
     * This method is responsible for validating the values passed to the setItems method
     * This method is willingly generated in order to preserve the one-line inline validation within the setItems method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateItemsForArrayConstraintsFromSetItems(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $pagedResponseOfInvoiceInfoItemsItem) {
            // validation for constraint: itemType
            if (!$pagedResponseOfInvoiceInfoItemsItem instanceof InvoiceInfo) {
                $invalidValues[] = is_object($pagedResponseOfInvoiceInfoItemsItem) ? get_class($pagedResponseOfInvoiceInfoItemsItem) : sprintf('%s(%s)', gettype($pagedResponseOfInvoiceInfoItemsItem), var_export($pagedResponseOfInvoiceInfoItemsItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Items property can only contain items of type \Gek\UyumBahceGet\StructType\InvoiceInfo, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }

    /**
     * Set Items value
     * @param InvoiceInfo[] $items
     * @return PagedResponseOfInvoiceInfo
     * @throws InvalidArgumentException
     */
    public function setItems(array $items = array())
    {
        // validation for constraint: array
        if ('' !== ($itemsArrayErrorMessage = self::validateItemsForArrayConstraintsFromSetItems($items))) {
            throw new InvalidArgumentException($itemsArrayErrorMessage, __LINE__);
        }
        $this->Items = $items;
        return $this;
    }

    /**
     * Add item to Items value
     * @param InvoiceInfo $item
     * @return PagedResponseOfInvoiceInfo
     * @throws InvalidArgumentException
     */
    public function addToItems(InvoiceInfo $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof InvoiceInfo) {
            throw new InvalidArgumentException(sprintf('The Items property can only contain items of type \Gek\UyumBahceGet\StructType\InvoiceInfo, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Items[] = $item;
        return $this;
    }
}
