<?php

namespace Gek\UyumBahceGet\StructType;

use InvalidArgumentException;
use WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PagedResponseOfInvoiceData StructType
 * @subpackage Structs
 */
class PagedResponseOfInvoiceData extends AbstractStructBase
{
    /**
     * The TotalCount
     * Meta information extracted from the WSDL
     * - use: required
     * @var int
     */
    public $TotalCount;
    /**
     * The TotalPages
     * Meta information extracted from the WSDL
     * - use: required
     * @var int
     */
    public $TotalPages;
    /**
     * The PageIndex
     * Meta information extracted from the WSDL
     * - use: required
     * @var int
     */
    public $PageIndex;
    /**
     * The PageSize
     * Meta information extracted from the WSDL
     * - use: required
     * @var int
     */
    public $PageSize;
    /**
     * The Items
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var InvoiceData[]
     */
    public $Items;

    /**
     * Constructor method for PagedResponseOfInvoiceData
     * @param int $totalCount
     * @param int $totalPages
     * @param int $pageIndex
     * @param int $pageSize
     * @param InvoiceData[] $items
     * @uses PagedResponseOfInvoiceData::setTotalCount()
     * @uses PagedResponseOfInvoiceData::setTotalPages()
     * @uses PagedResponseOfInvoiceData::setPageIndex()
     * @uses PagedResponseOfInvoiceData::setPageSize()
     * @uses PagedResponseOfInvoiceData::setItems()
     */
    public function __construct($totalCount = null, $totalPages = null, $pageIndex = null, $pageSize = null, array $items = array())
    {
        $this
            ->setTotalCount($totalCount)
            ->setTotalPages($totalPages)
            ->setPageIndex($pageIndex)
            ->setPageSize($pageSize)
            ->setItems($items);
    }

    /**
     * Get TotalCount value
     * @return int
     */
    public function getTotalCount()
    {
        return $this->TotalCount;
    }

    /**
     * Set TotalCount value
     * @param int $totalCount
     * @return PagedResponseOfInvoiceData
     */
    public function setTotalCount($totalCount = null)
    {
        // validation for constraint: int
        if (!is_null($totalCount) && !(is_int($totalCount) || ctype_digit($totalCount))) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($totalCount, true), gettype($totalCount)), __LINE__);
        }
        $this->TotalCount = $totalCount;
        return $this;
    }

    /**
     * Get TotalPages value
     * @return int
     */
    public function getTotalPages()
    {
        return $this->TotalPages;
    }

    /**
     * Set TotalPages value
     * @param int $totalPages
     * @return PagedResponseOfInvoiceData
     */
    public function setTotalPages($totalPages = null)
    {
        // validation for constraint: int
        if (!is_null($totalPages) && !(is_int($totalPages) || ctype_digit($totalPages))) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($totalPages, true), gettype($totalPages)), __LINE__);
        }
        $this->TotalPages = $totalPages;
        return $this;
    }

    /**
     * Get PageIndex value
     * @return int
     */
    public function getPageIndex()
    {
        return $this->PageIndex;
    }

    /**
     * Set PageIndex value
     * @param int $pageIndex
     * @return PagedResponseOfInvoiceData
     */
    public function setPageIndex($pageIndex = null)
    {
        // validation for constraint: int
        if (!is_null($pageIndex) && !(is_int($pageIndex) || ctype_digit($pageIndex))) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($pageIndex, true), gettype($pageIndex)), __LINE__);
        }
        $this->PageIndex = $pageIndex;
        return $this;
    }

    /**
     * Get PageSize value
     * @return int
     */
    public function getPageSize()
    {
        return $this->PageSize;
    }

    /**
     * Set PageSize value
     * @param int $pageSize
     * @return PagedResponseOfInvoiceData
     */
    public function setPageSize($pageSize = null)
    {
        // validation for constraint: int
        if (!is_null($pageSize) && !(is_int($pageSize) || ctype_digit($pageSize))) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($pageSize, true), gettype($pageSize)), __LINE__);
        }
        $this->PageSize = $pageSize;
        return $this;
    }

    /**
     * Get Items value
     * @return InvoiceData[]|null
     */
    public function getItems()
    {
        return $this->Items;
    }

    /**
     * This method is responsible for validating the values passed to the setItems method
     * This method is willingly generated in order to preserve the one-line inline validation within the setItems method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateItemsForArrayConstraintsFromSetItems(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $pagedResponseOfInvoiceDataItemsItem) {
            // validation for constraint: itemType
            if (!$pagedResponseOfInvoiceDataItemsItem instanceof InvoiceData) {
                $invalidValues[] = is_object($pagedResponseOfInvoiceDataItemsItem) ? get_class($pagedResponseOfInvoiceDataItemsItem) : sprintf('%s(%s)', gettype($pagedResponseOfInvoiceDataItemsItem), var_export($pagedResponseOfInvoiceDataItemsItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Items property can only contain items of type \Gek\UyumBahceGet\StructType\InvoiceData, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }

    /**
     * Set Items value
     * @param InvoiceData[] $items
     * @return PagedResponseOfInvoiceData
     * @throws InvalidArgumentException
     */
    public function setItems(array $items = array())
    {
        // validation for constraint: array
        if ('' !== ($itemsArrayErrorMessage = self::validateItemsForArrayConstraintsFromSetItems($items))) {
            throw new InvalidArgumentException($itemsArrayErrorMessage, __LINE__);
        }
        $this->Items = $items;
        return $this;
    }

    /**
     * Add item to Items value
     * @param InvoiceData $item
     * @return PagedResponseOfInvoiceData
     * @throws InvalidArgumentException
     */
    public function addToItems(InvoiceData $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof InvoiceData) {
            throw new InvalidArgumentException(sprintf('The Items property can only contain items of type \Gek\UyumBahceGet\StructType\InvoiceData, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Items[] = $item;
        return $this;
    }
}
