<?php

namespace Gek\UyumBahceGet\StructType;

use WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for OrderReferenceType StructType
 * @subpackage Structs
 */
class OrderReferenceType extends AbstractStructBase
{
    /**
     * The ID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: s4:ID
     * @var IDType
     */
    public $ID;
    /**
     * The SalesOrderID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: s4:SalesOrderID
     * @var SalesOrderIDType
     */
    public $SalesOrderID;
    /**
     * The IssueDate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: s4:IssueDate
     * @var IssueDateType
     */
    public $IssueDate;
    /**
     * The OrderTypeCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: s4:OrderTypeCode
     * @var OrderTypeCodeType
     */
    public $OrderTypeCode;
    /**
     * The DocumentReference
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var DocumentReferenceType
     */
    public $DocumentReference;

    /**
     * Constructor method for OrderReferenceType
     * @param IDType $iD
     * @param SalesOrderIDType $salesOrderID
     * @param IssueDateType $issueDate
     * @param OrderTypeCodeType $orderTypeCode
     * @param DocumentReferenceType $documentReference
     * @uses OrderReferenceType::setID()
     * @uses OrderReferenceType::setSalesOrderID()
     * @uses OrderReferenceType::setIssueDate()
     * @uses OrderReferenceType::setOrderTypeCode()
     * @uses OrderReferenceType::setDocumentReference()
     */
    public function __construct(IDType $iD = null, SalesOrderIDType $salesOrderID = null, IssueDateType $issueDate = null, OrderTypeCodeType $orderTypeCode = null, DocumentReferenceType $documentReference = null)
    {
        $this
            ->setID($iD)
            ->setSalesOrderID($salesOrderID)
            ->setIssueDate($issueDate)
            ->setOrderTypeCode($orderTypeCode)
            ->setDocumentReference($documentReference);
    }

    /**
     * Get ID value
     * @return IDType|null
     */
    public function getID()
    {
        return $this->ID;
    }

    /**
     * Set ID value
     * @param IDType $iD
     * @return OrderReferenceType
     */
    public function setID(IDType $iD = null)
    {
        $this->ID = $iD;
        return $this;
    }

    /**
     * Get SalesOrderID value
     * @return SalesOrderIDType|null
     */
    public function getSalesOrderID()
    {
        return $this->SalesOrderID;
    }

    /**
     * Set SalesOrderID value
     * @param SalesOrderIDType $salesOrderID
     * @return OrderReferenceType
     */
    public function setSalesOrderID(SalesOrderIDType $salesOrderID = null)
    {
        $this->SalesOrderID = $salesOrderID;
        return $this;
    }

    /**
     * Get IssueDate value
     * @return IssueDateType|null
     */
    public function getIssueDate()
    {
        return $this->IssueDate;
    }

    /**
     * Set IssueDate value
     * @param IssueDateType $issueDate
     * @return OrderReferenceType
     */
    public function setIssueDate(IssueDateType $issueDate = null)
    {
        $this->IssueDate = $issueDate;
        return $this;
    }

    /**
     * Get OrderTypeCode value
     * @return OrderTypeCodeType|null
     */
    public function getOrderTypeCode()
    {
        return $this->OrderTypeCode;
    }

    /**
     * Set OrderTypeCode value
     * @param OrderTypeCodeType $orderTypeCode
     * @return OrderReferenceType
     */
    public function setOrderTypeCode(OrderTypeCodeType $orderTypeCode = null)
    {
        $this->OrderTypeCode = $orderTypeCode;
        return $this;
    }

    /**
     * Get DocumentReference value
     * @return DocumentReferenceType|null
     */
    public function getDocumentReference()
    {
        return $this->DocumentReference;
    }

    /**
     * Set DocumentReference value
     * @param DocumentReferenceType $documentReference
     * @return OrderReferenceType
     */
    public function setDocumentReference(DocumentReferenceType $documentReference = null)
    {
        $this->DocumentReference = $documentReference;
        return $this;
    }
}
