<?php

namespace Gek\UyumBahceGet\StructType;

use Gek\UyumBahceGet\ArrayType\ArrayOfWherePropertyClause;
use InvalidArgumentException;
use WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ObjectInfoIn StructType
 * @subpackage Structs
 */
class ObjectInfoIn extends AbstractStructBase
{
    /**
     * The LoadDetail
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $LoadDetail;
    /**
     * The ObjectCollectionTypeName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ObjectCollectionTypeName;
    /**
     * The WhereClauseList
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var ArrayOfWherePropertyClause
     */
    public $WhereClauseList;

    /**
     * Constructor method for ObjectInfoIn
     * @param bool $loadDetail
     * @param string $objectCollectionTypeName
     * @param ArrayOfWherePropertyClause $whereClauseList
     * @uses ObjectInfoIn::setLoadDetail()
     * @uses ObjectInfoIn::setObjectCollectionTypeName()
     * @uses ObjectInfoIn::setWhereClauseList()
     */
    public function __construct($loadDetail = null, $objectCollectionTypeName = null, ArrayOfWherePropertyClause $whereClauseList = null)
    {
        $this
            ->setLoadDetail($loadDetail)
            ->setObjectCollectionTypeName($objectCollectionTypeName)
            ->setWhereClauseList($whereClauseList);
    }

    /**
     * Get LoadDetail value
     * @return bool
     */
    public function getLoadDetail()
    {
        return $this->LoadDetail;
    }

    /**
     * Set LoadDetail value
     * @param bool $loadDetail
     * @return ObjectInfoIn
     */
    public function setLoadDetail($loadDetail = null)
    {
        // validation for constraint: boolean
        if (!is_null($loadDetail) && !is_bool($loadDetail)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($loadDetail, true), gettype($loadDetail)), __LINE__);
        }
        $this->LoadDetail = $loadDetail;
        return $this;
    }

    /**
     * Get ObjectCollectionTypeName value
     * @return string|null
     */
    public function getObjectCollectionTypeName()
    {
        return $this->ObjectCollectionTypeName;
    }

    /**
     * Set ObjectCollectionTypeName value
     * @param string $objectCollectionTypeName
     * @return ObjectInfoIn
     */
    public function setObjectCollectionTypeName($objectCollectionTypeName = null)
    {
        // validation for constraint: string
        if (!is_null($objectCollectionTypeName) && !is_string($objectCollectionTypeName)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($objectCollectionTypeName, true), gettype($objectCollectionTypeName)), __LINE__);
        }
        $this->ObjectCollectionTypeName = $objectCollectionTypeName;
        return $this;
    }

    /**
     * Get WhereClauseList value
     * @return ArrayOfWherePropertyClause|null
     */
    public function getWhereClauseList()
    {
        return $this->WhereClauseList;
    }

    /**
     * Set WhereClauseList value
     * @param ArrayOfWherePropertyClause $whereClauseList
     * @return ObjectInfoIn
     */
    public function setWhereClauseList(ArrayOfWherePropertyClause $whereClauseList = null)
    {
        $this->WhereClauseList = $whereClauseList;
        return $this;
    }
}
