<?php

namespace Gek\UyumBahceGet\StructType;

use InvalidArgumentException;
use WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for MonthlyReportItem StructType
 * @subpackage Structs
 */
class MonthlyReportItem extends AbstractStructBase
{
    /**
     * The Period
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $Period;
    /**
     * The InboxCount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $InboxCount;
    /**
     * The OutboxCount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $OutboxCount;

    /**
     * Constructor method for MonthlyReportItem
     * @param int $period
     * @param int $inboxCount
     * @param int $outboxCount
     * @uses MonthlyReportItem::setPeriod()
     * @uses MonthlyReportItem::setInboxCount()
     * @uses MonthlyReportItem::setOutboxCount()
     */
    public function __construct($period = null, $inboxCount = null, $outboxCount = null)
    {
        $this
            ->setPeriod($period)
            ->setInboxCount($inboxCount)
            ->setOutboxCount($outboxCount);
    }

    /**
     * Get Period value
     * @return int
     */
    public function getPeriod()
    {
        return $this->Period;
    }

    /**
     * Set Period value
     * @param int $period
     * @return MonthlyReportItem
     */
    public function setPeriod($period = null)
    {
        // validation for constraint: int
        if (!is_null($period) && !(is_int($period) || ctype_digit($period))) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($period, true), gettype($period)), __LINE__);
        }
        $this->Period = $period;
        return $this;
    }

    /**
     * Get InboxCount value
     * @return int
     */
    public function getInboxCount()
    {
        return $this->InboxCount;
    }

    /**
     * Set InboxCount value
     * @param int $inboxCount
     * @return MonthlyReportItem
     */
    public function setInboxCount($inboxCount = null)
    {
        // validation for constraint: int
        if (!is_null($inboxCount) && !(is_int($inboxCount) || ctype_digit($inboxCount))) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($inboxCount, true), gettype($inboxCount)), __LINE__);
        }
        $this->InboxCount = $inboxCount;
        return $this;
    }

    /**
     * Get OutboxCount value
     * @return int
     */
    public function getOutboxCount()
    {
        return $this->OutboxCount;
    }

    /**
     * Set OutboxCount value
     * @param int $outboxCount
     * @return MonthlyReportItem
     */
    public function setOutboxCount($outboxCount = null)
    {
        // validation for constraint: int
        if (!is_null($outboxCount) && !(is_int($outboxCount) || ctype_digit($outboxCount))) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($outboxCount, true), gettype($outboxCount)), __LINE__);
        }
        $this->OutboxCount = $outboxCount;
        return $this;
    }
}
