<?php

namespace Gek\UyumBahceGet\StructType;

use InvalidArgumentException;
use WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for MobBaseTop StructType
 * @subpackage Structs
 */
class MobBaseTop extends AbstractStructBase
{
    /**
     * The Id
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $Id;
    /**
     * The Code
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Code;
    /**
     * The Desc
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Desc;

    /**
     * Constructor method for MobBaseTop
     * @param int $id
     * @param string $code
     * @param string $desc
     * @uses MobBaseTop::setId()
     * @uses MobBaseTop::setCode()
     * @uses MobBaseTop::setDesc()
     */
    public function __construct($id = null, $code = null, $desc = null)
    {
        $this
            ->setId($id)
            ->setCode($code)
            ->setDesc($desc);
    }

    /**
     * Get Id value
     * @return int
     */
    public function getId()
    {
        return $this->Id;
    }

    /**
     * Set Id value
     * @param int $id
     * @return MobBaseTop
     */
    public function setId($id = null)
    {
        // validation for constraint: int
        if (!is_null($id) && !(is_int($id) || ctype_digit($id))) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($id, true), gettype($id)), __LINE__);
        }
        $this->Id = $id;
        return $this;
    }

    /**
     * Get Code value
     * @return string|null
     */
    public function getCode()
    {
        return $this->Code;
    }

    /**
     * Set Code value
     * @param string $code
     * @return MobBaseTop
     */
    public function setCode($code = null)
    {
        // validation for constraint: string
        if (!is_null($code) && !is_string($code)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($code, true), gettype($code)), __LINE__);
        }
        $this->Code = $code;
        return $this;
    }

    /**
     * Get Desc value
     * @return string|null
     */
    public function getDesc()
    {
        return $this->Desc;
    }

    /**
     * Set Desc value
     * @param string $desc
     * @return MobBaseTop
     */
    public function setDesc($desc = null)
    {
        // validation for constraint: string
        if (!is_null($desc) && !is_string($desc)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($desc, true), gettype($desc)), __LINE__);
        }
        $this->Desc = $desc;
        return $this;
    }
}
