<?php /** @noinspection PhpMissingParentConstructorInspection */

namespace Gek\UyumBahceGet\StructType;

use InvalidArgumentException;

/**
 * This class stands for MobBaseLocal StructType
 * @subpackage Structs
 */
class MobBaseLocal extends MobBase
{
    /**
     * The CoId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $CoId;
    /**
     * The BranchId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $BranchId;

    /**
     * Constructor method for MobBaseLocal
     * @param int $coId
     * @param int $branchId
     * @uses MobBaseLocal::setCoId()
     * @uses MobBaseLocal::setBranchId()
     */
    public function __construct($coId = null, $branchId = null)
    {
        $this
            ->setCoId($coId)
            ->setBranchId($branchId);
    }

    /**
     * Get CoId value
     * @return int
     */
    public function getCoId()
    {
        return $this->CoId;
    }

    /**
     * Set CoId value
     * @param int $coId
     * @return MobBaseLocal
     */
    public function setCoId($coId = null)
    {
        // validation for constraint: int
        if (!is_null($coId) && !(is_int($coId) || ctype_digit($coId))) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($coId, true), gettype($coId)), __LINE__);
        }
        $this->CoId = $coId;
        return $this;
    }

    /**
     * Get BranchId value
     * @return int
     */
    public function getBranchId()
    {
        return $this->BranchId;
    }

    /**
     * Set BranchId value
     * @param int $branchId
     * @return MobBaseLocal
     */
    public function setBranchId($branchId = null)
    {
        // validation for constraint: int
        if (!is_null($branchId) && !(is_int($branchId) || ctype_digit($branchId))) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($branchId, true), gettype($branchId)), __LINE__);
        }
        $this->BranchId = $branchId;
        return $this;
    }
}
