<?php /** @noinspection PhpMissingParentConstructorInspection */

namespace Gek\UyumBahceGet\StructType;

use InvalidArgumentException;

/**
 * This class stands for MobBase StructType
 * @subpackage Structs
 */
class MobBase extends MobBaseTop
{
    /**
     * The CardId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $CardId;
    /**
     * The IsPassive
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $IsPassive;

    /**
     * Constructor method for MobBase
     * @param int $cardId
     * @param bool $isPassive
     * @uses MobBase::setCardId()
     * @uses MobBase::setIsPassive()
     */
    public function __construct($cardId = null, $isPassive = null)
    {
        $this
            ->setCardId($cardId)
            ->setIsPassive($isPassive);
    }

    /**
     * Get CardId value
     * @return int
     */
    public function getCardId()
    {
        return $this->CardId;
    }

    /**
     * Set CardId value
     * @param int $cardId
     * @return MobBase
     */
    public function setCardId($cardId = null)
    {
        // validation for constraint: int
        if (!is_null($cardId) && !(is_int($cardId) || ctype_digit($cardId))) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($cardId, true), gettype($cardId)), __LINE__);
        }
        $this->CardId = $cardId;
        return $this;
    }

    /**
     * Get IsPassive value
     * @return bool
     */
    public function getIsPassive()
    {
        return $this->IsPassive;
    }

    /**
     * Set IsPassive value
     * @param bool $isPassive
     * @return MobBase
     */
    public function setIsPassive($isPassive = null)
    {
        // validation for constraint: boolean
        if (!is_null($isPassive) && !is_bool($isPassive)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isPassive, true), gettype($isPassive)), __LINE__);
        }
        $this->IsPassive = $isPassive;
        return $this;
    }
}
