<?php

namespace Gek\UyumBahceGet\StructType;

use WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for LineReferenceType StructType
 * @subpackage Structs
 */
class LineReferenceType extends AbstractStructBase
{
    /**
     * The LineID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: s4:LineID
     * @var LineIDType
     */
    public $LineID;
    /**
     * The LineStatusCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: s4:LineStatusCode
     * @var LineStatusCodeType
     */
    public $LineStatusCode;
    /**
     * The DocumentReference
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var DocumentReferenceType
     */
    public $DocumentReference;

    /**
     * Constructor method for LineReferenceType
     * @param LineIDType $lineID
     * @param LineStatusCodeType $lineStatusCode
     * @param DocumentReferenceType $documentReference
     * @uses LineReferenceType::setLineID()
     * @uses LineReferenceType::setLineStatusCode()
     * @uses LineReferenceType::setDocumentReference()
     */
    public function __construct(LineIDType $lineID = null, LineStatusCodeType $lineStatusCode = null, DocumentReferenceType $documentReference = null)
    {
        $this
            ->setLineID($lineID)
            ->setLineStatusCode($lineStatusCode)
            ->setDocumentReference($documentReference);
    }

    /**
     * Get LineID value
     * @return LineIDType|null
     */
    public function getLineID()
    {
        return $this->LineID;
    }

    /**
     * Set LineID value
     * @param LineIDType $lineID
     * @return LineReferenceType
     */
    public function setLineID(LineIDType $lineID = null)
    {
        $this->LineID = $lineID;
        return $this;
    }

    /**
     * Get LineStatusCode value
     * @return LineStatusCodeType|null
     */
    public function getLineStatusCode()
    {
        return $this->LineStatusCode;
    }

    /**
     * Set LineStatusCode value
     * @param LineStatusCodeType $lineStatusCode
     * @return LineReferenceType
     */
    public function setLineStatusCode(LineStatusCodeType $lineStatusCode = null)
    {
        $this->LineStatusCode = $lineStatusCode;
        return $this;
    }

    /**
     * Get DocumentReference value
     * @return DocumentReferenceType|null
     */
    public function getDocumentReference()
    {
        return $this->DocumentReference;
    }

    /**
     * Set DocumentReference value
     * @param DocumentReferenceType $documentReference
     * @return LineReferenceType
     */
    public function setDocumentReference(DocumentReferenceType $documentReference = null)
    {
        $this->DocumentReference = $documentReference;
        return $this;
    }
}
