<?php

namespace Gek\UyumBahceGet\StructType;

use InvalidArgumentException;
use WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Last10DaysReport StructType
 * @subpackage Structs
 */
class Last10DaysReport extends AbstractStructBase
{
    /**
     * The InboxWaitingForApprovalCount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $InboxWaitingForApprovalCount;
    /**
     * The OutboxWaitingForApprovalCount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $OutboxWaitingForApprovalCount;
    /**
     * The OutboxErrorCount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $OutboxErrorCount;

    /**
     * Constructor method for Last10DaysReport
     * @param int $inboxWaitingForApprovalCount
     * @param int $outboxWaitingForApprovalCount
     * @param int $outboxErrorCount
     * @uses Last10DaysReport::setInboxWaitingForApprovalCount()
     * @uses Last10DaysReport::setOutboxWaitingForApprovalCount()
     * @uses Last10DaysReport::setOutboxErrorCount()
     */
    public function __construct($inboxWaitingForApprovalCount = null, $outboxWaitingForApprovalCount = null, $outboxErrorCount = null)
    {
        $this
            ->setInboxWaitingForApprovalCount($inboxWaitingForApprovalCount)
            ->setOutboxWaitingForApprovalCount($outboxWaitingForApprovalCount)
            ->setOutboxErrorCount($outboxErrorCount);
    }

    /**
     * Get InboxWaitingForApprovalCount value
     * @return int
     */
    public function getInboxWaitingForApprovalCount()
    {
        return $this->InboxWaitingForApprovalCount;
    }

    /**
     * Set InboxWaitingForApprovalCount value
     * @param int $inboxWaitingForApprovalCount
     * @return Last10DaysReport
     */
    public function setInboxWaitingForApprovalCount($inboxWaitingForApprovalCount = null)
    {
        // validation for constraint: int
        if (!is_null($inboxWaitingForApprovalCount) && !(is_int($inboxWaitingForApprovalCount) || ctype_digit($inboxWaitingForApprovalCount))) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($inboxWaitingForApprovalCount, true), gettype($inboxWaitingForApprovalCount)), __LINE__);
        }
        $this->InboxWaitingForApprovalCount = $inboxWaitingForApprovalCount;
        return $this;
    }

    /**
     * Get OutboxWaitingForApprovalCount value
     * @return int
     */
    public function getOutboxWaitingForApprovalCount()
    {
        return $this->OutboxWaitingForApprovalCount;
    }

    /**
     * Set OutboxWaitingForApprovalCount value
     * @param int $outboxWaitingForApprovalCount
     * @return Last10DaysReport
     */
    public function setOutboxWaitingForApprovalCount($outboxWaitingForApprovalCount = null)
    {
        // validation for constraint: int
        if (!is_null($outboxWaitingForApprovalCount) && !(is_int($outboxWaitingForApprovalCount) || ctype_digit($outboxWaitingForApprovalCount))) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($outboxWaitingForApprovalCount, true), gettype($outboxWaitingForApprovalCount)), __LINE__);
        }
        $this->OutboxWaitingForApprovalCount = $outboxWaitingForApprovalCount;
        return $this;
    }

    /**
     * Get OutboxErrorCount value
     * @return int
     */
    public function getOutboxErrorCount()
    {
        return $this->OutboxErrorCount;
    }

    /**
     * Set OutboxErrorCount value
     * @param int $outboxErrorCount
     * @return Last10DaysReport
     */
    public function setOutboxErrorCount($outboxErrorCount = null)
    {
        // validation for constraint: int
        if (!is_null($outboxErrorCount) && !(is_int($outboxErrorCount) || ctype_digit($outboxErrorCount))) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($outboxErrorCount, true), gettype($outboxErrorCount)), __LINE__);
        }
        $this->OutboxErrorCount = $outboxErrorCount;
        return $this;
    }
}
