<?php

namespace Gek\UyumBahceGet\StructType;

use DOMDocument;
use InvalidArgumentException;
use WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for KeyInfoType StructType
 * Meta information extracted from the WSDL
 * - mixed: true
 * @subpackage Structs
 */
class KeyInfoType extends AbstractStructBase
{
    /**
     * The KeyName
     * Meta information extracted from the WSDL
     * - choice: KeyName | KeyValue | MgmtData | PGPData | RetrievalMethod | SPKIData | X509Data |
     * - choiceMaxOccurs: unbounded
     * - choiceMinOccurs: 0
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string[]
     */
    public $KeyName;
    /**
     * The KeyValue
     * Meta information extracted from the WSDL
     * - choice: KeyName | KeyValue | MgmtData | PGPData | RetrievalMethod | SPKIData | X509Data |
     * - choiceMaxOccurs: unbounded
     * - choiceMinOccurs: 0
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var KeyValueType[]
     */
    public $KeyValue;
    /**
     * The MgmtData
     * Meta information extracted from the WSDL
     * - choice: KeyName | KeyValue | MgmtData | PGPData | RetrievalMethod | SPKIData | X509Data |
     * - choiceMaxOccurs: unbounded
     * - choiceMinOccurs: 0
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string[]
     */
    public $MgmtData;
    /**
     * The PGPData
     * Meta information extracted from the WSDL
     * - choice: KeyName | KeyValue | MgmtData | PGPData | RetrievalMethod | SPKIData | X509Data |
     * - choiceMaxOccurs: unbounded
     * - choiceMinOccurs: 0
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var PGPDataType[]
     */
    public $PGPData;
    /**
     * The RetrievalMethod
     * Meta information extracted from the WSDL
     * - choice: KeyName | KeyValue | MgmtData | PGPData | RetrievalMethod | SPKIData | X509Data |
     * - choiceMaxOccurs: unbounded
     * - choiceMinOccurs: 0
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var RetrievalMethodType[]
     */
    public $RetrievalMethod;
    /**
     * The SPKIData
     * Meta information extracted from the WSDL
     * - choice: KeyName | KeyValue | MgmtData | PGPData | RetrievalMethod | SPKIData | X509Data |
     * - choiceMaxOccurs: unbounded
     * - choiceMinOccurs: 0
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var SPKIDataType[]
     */
    public $SPKIData;
    /**
     * The X509Data
     * Meta information extracted from the WSDL
     * - choice: KeyName | KeyValue | MgmtData | PGPData | RetrievalMethod | SPKIData | X509Data |
     * - choiceMaxOccurs: unbounded
     * - choiceMinOccurs: 0
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var X509DataType[]
     */
    public $X509Data;
    /**
     * The any
     * @var DOMDocument
     */
    public $any;
    /**
     * The Id
     * @var string
     */
    public $Id;

    /**
     * Constructor method for KeyInfoType
     * @param string[] $keyName
     * @param KeyValueType[] $keyValue
     * @param string[] $mgmtData
     * @param PGPDataType[] $pGPData
     * @param RetrievalMethodType[] $retrievalMethod
     * @param SPKIDataType[] $sPKIData
     * @param X509DataType[] $x509Data
     * @param DOMDocument $any
     * @param string $id
     * @uses KeyInfoType::setKeyName()
     * @uses KeyInfoType::setKeyValue()
     * @uses KeyInfoType::setMgmtData()
     * @uses KeyInfoType::setPGPData()
     * @uses KeyInfoType::setRetrievalMethod()
     * @uses KeyInfoType::setSPKIData()
     * @uses KeyInfoType::setX509Data()
     * @uses KeyInfoType::setAny()
     * @uses KeyInfoType::setId()
     */
    public function __construct(array $keyName = array(), array $keyValue = array(), array $mgmtData = array(), array $pGPData = array(), array $retrievalMethod = array(), array $sPKIData = array(), array $x509Data = array(), DOMDocument $any = null, $id = null)
    {
        $this
            ->setKeyName($keyName)
            ->setKeyValue($keyValue)
            ->setMgmtData($mgmtData)
            ->setPGPData($pGPData)
            ->setRetrievalMethod($retrievalMethod)
            ->setSPKIData($sPKIData)
            ->setX509Data($x509Data)
            ->setAny($any)
            ->setId($id);
    }

    /**
     * Get KeyName value
     * @return string[]|null
     */
    public function getKeyName()
    {
        return isset($this->KeyName) ? $this->KeyName : null;
    }

    /**
     * This method is responsible for validating the values passed to the setKeyName method
     * This method is willingly generated in order to preserve the one-line inline validation within the setKeyName method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateKeyNameForArrayConstraintsFromSetKeyName(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $keyInfoTypeKeyNameItem) {
            // validation for constraint: itemType
            if (!is_string($keyInfoTypeKeyNameItem)) {
                $invalidValues[] = is_object($keyInfoTypeKeyNameItem) ? get_class($keyInfoTypeKeyNameItem) : sprintf('%s(%s)', gettype($keyInfoTypeKeyNameItem), var_export($keyInfoTypeKeyNameItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The KeyName property can only contain items of type string, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }

    /**
     * This method is responsible for validating the value passed to the setKeyName method
     * This method is willingly generated in order to preserve the one-line inline validation within the setKeyName method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateKeyNameForChoiceConstraintsFromSetKeyName($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'KeyValue',
            'MgmtData',
            'PGPData',
            'RetrievalMethod',
            'SPKIData',
            'X509Data',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new InvalidArgumentException(sprintf('The property KeyName can\'t be set as the property %s is already set. Only one property must be set among these properties: KeyName, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }

    /**
     * Set KeyName value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @param string[] $keyName
     * @return KeyInfoType
     * @throws InvalidArgumentException
     * @throws InvalidArgumentException
     */
    public function setKeyName(array $keyName = array())
    {
        // validation for constraint: array
        if ('' !== ($keyNameArrayErrorMessage = self::validateKeyNameForArrayConstraintsFromSetKeyName($keyName))) {
            throw new InvalidArgumentException($keyNameArrayErrorMessage, __LINE__);
        }
        // validation for constraint: choice(KeyName, KeyValue, MgmtData, PGPData, RetrievalMethod, SPKIData, X509Data, )
        if ('' !== ($keyNameChoiceErrorMessage = self::validateKeyNameForChoiceConstraintsFromSetKeyName($keyName))) {
            throw new InvalidArgumentException($keyNameChoiceErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(1)
        if (is_array($keyName) && count($keyName) > 1) {
            throw new InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 1', count($keyName)), __LINE__);
        }
        if (is_null($keyName) || (is_array($keyName) && empty($keyName))) {
            unset($this->KeyName);
        } else {
            $this->KeyName = $keyName;
        }
        return $this;
    }

    /**
     * This method is responsible for validating the value passed to the addToKeyName method
     * This method is willingly generated in order to preserve the one-line inline validation within the addToKeyName method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateItemForChoiceConstraintsFromAddToKeyName($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'KeyValue',
            'MgmtData',
            'PGPData',
            'RetrievalMethod',
            'SPKIData',
            'X509Data',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new InvalidArgumentException(sprintf('The property KeyName can\'t be set as the property %s is already set. Only one property must be set among these properties: KeyName, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }

    /**
     * Add item to KeyName value
     * @param string $item
     * @return KeyInfoType
     * @throws InvalidArgumentException
     */
    public function addToKeyName($item)
    {
        // validation for constraint: itemType
        if (!is_string($item)) {
            throw new InvalidArgumentException(sprintf('The KeyName property can only contain items of type string, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: choice(KeyName, KeyValue, MgmtData, PGPData, RetrievalMethod, SPKIData, X509Data, )
        if ('' !== ($itemChoiceErrorMessage = self::validateItemForChoiceConstraintsFromAddToKeyName($item))) {
            throw new InvalidArgumentException($itemChoiceErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(1)
        if (is_array($this->KeyName) && count($this->KeyName) >= 1) {
            throw new InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 1', count($this->KeyName)), __LINE__);
        }
        $this->KeyName[] = $item;
        return $this;
    }

    /**
     * Get KeyValue value
     * @return KeyValueType[]|null
     */
    public function getKeyValue()
    {
        return isset($this->KeyValue) ? $this->KeyValue : null;
    }

    /**
     * This method is responsible for validating the values passed to the setKeyValue method
     * This method is willingly generated in order to preserve the one-line inline validation within the setKeyValue method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateKeyValueForArrayConstraintsFromSetKeyValue(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $keyInfoTypeKeyValueItem) {
            // validation for constraint: itemType
            if (!$keyInfoTypeKeyValueItem instanceof KeyValueType) {
                $invalidValues[] = is_object($keyInfoTypeKeyValueItem) ? get_class($keyInfoTypeKeyValueItem) : sprintf('%s(%s)', gettype($keyInfoTypeKeyValueItem), var_export($keyInfoTypeKeyValueItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The KeyValue property can only contain items of type \Gek\UyumBahceGet\StructType\KeyValueType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }

    /**
     * This method is responsible for validating the value passed to the setKeyValue method
     * This method is willingly generated in order to preserve the one-line inline validation within the setKeyValue method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateKeyValueForChoiceConstraintsFromSetKeyValue($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'KeyName',
            'MgmtData',
            'PGPData',
            'RetrievalMethod',
            'SPKIData',
            'X509Data',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new InvalidArgumentException(sprintf('The property KeyValue can\'t be set as the property %s is already set. Only one property must be set among these properties: KeyValue, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }

    /**
     * Set KeyValue value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @param KeyValueType[] $keyValue
     * @return KeyInfoType
     * @throws InvalidArgumentException
     * @throws InvalidArgumentException
     */
    public function setKeyValue(array $keyValue = array())
    {
        // validation for constraint: array
        if ('' !== ($keyValueArrayErrorMessage = self::validateKeyValueForArrayConstraintsFromSetKeyValue($keyValue))) {
            throw new InvalidArgumentException($keyValueArrayErrorMessage, __LINE__);
        }
        // validation for constraint: choice(KeyName, KeyValue, MgmtData, PGPData, RetrievalMethod, SPKIData, X509Data, )
        if ('' !== ($keyValueChoiceErrorMessage = self::validateKeyValueForChoiceConstraintsFromSetKeyValue($keyValue))) {
            throw new InvalidArgumentException($keyValueChoiceErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(1)
        if (is_array($keyValue) && count($keyValue) > 1) {
            throw new InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 1', count($keyValue)), __LINE__);
        }
        if (is_null($keyValue) || (is_array($keyValue) && empty($keyValue))) {
            unset($this->KeyValue);
        } else {
            $this->KeyValue = $keyValue;
        }
        return $this;
    }

    /**
     * This method is responsible for validating the value passed to the addToKeyValue method
     * This method is willingly generated in order to preserve the one-line inline validation within the addToKeyValue method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateItemForChoiceConstraintsFromAddToKeyValue($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'KeyName',
            'MgmtData',
            'PGPData',
            'RetrievalMethod',
            'SPKIData',
            'X509Data',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new InvalidArgumentException(sprintf('The property KeyValue can\'t be set as the property %s is already set. Only one property must be set among these properties: KeyValue, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }

    /**
     * Add item to KeyValue value
     * @param KeyValueType $item
     * @return KeyInfoType
     * @throws InvalidArgumentException
     */
    public function addToKeyValue(KeyValueType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof KeyValueType) {
            throw new InvalidArgumentException(sprintf('The KeyValue property can only contain items of type \Gek\UyumBahceGet\StructType\KeyValueType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: choice(KeyName, KeyValue, MgmtData, PGPData, RetrievalMethod, SPKIData, X509Data, )
        if ('' !== ($itemChoiceErrorMessage = self::validateItemForChoiceConstraintsFromAddToKeyValue($item))) {
            throw new InvalidArgumentException($itemChoiceErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(1)
        if (is_array($this->KeyValue) && count($this->KeyValue) >= 1) {
            throw new InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 1', count($this->KeyValue)), __LINE__);
        }
        $this->KeyValue[] = $item;
        return $this;
    }

    /**
     * Get MgmtData value
     * @return string[]|null
     */
    public function getMgmtData()
    {
        return isset($this->MgmtData) ? $this->MgmtData : null;
    }

    /**
     * This method is responsible for validating the values passed to the setMgmtData method
     * This method is willingly generated in order to preserve the one-line inline validation within the setMgmtData method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateMgmtDataForArrayConstraintsFromSetMgmtData(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $keyInfoTypeMgmtDataItem) {
            // validation for constraint: itemType
            if (!is_string($keyInfoTypeMgmtDataItem)) {
                $invalidValues[] = is_object($keyInfoTypeMgmtDataItem) ? get_class($keyInfoTypeMgmtDataItem) : sprintf('%s(%s)', gettype($keyInfoTypeMgmtDataItem), var_export($keyInfoTypeMgmtDataItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The MgmtData property can only contain items of type string, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }

    /**
     * This method is responsible for validating the value passed to the setMgmtData method
     * This method is willingly generated in order to preserve the one-line inline validation within the setMgmtData method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateMgmtDataForChoiceConstraintsFromSetMgmtData($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'KeyName',
            'KeyValue',
            'PGPData',
            'RetrievalMethod',
            'SPKIData',
            'X509Data',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new InvalidArgumentException(sprintf('The property MgmtData can\'t be set as the property %s is already set. Only one property must be set among these properties: MgmtData, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }

    /**
     * Set MgmtData value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @param string[] $mgmtData
     * @return KeyInfoType
     * @throws InvalidArgumentException
     * @throws InvalidArgumentException
     */
    public function setMgmtData(array $mgmtData = array())
    {
        // validation for constraint: array
        if ('' !== ($mgmtDataArrayErrorMessage = self::validateMgmtDataForArrayConstraintsFromSetMgmtData($mgmtData))) {
            throw new InvalidArgumentException($mgmtDataArrayErrorMessage, __LINE__);
        }
        // validation for constraint: choice(KeyName, KeyValue, MgmtData, PGPData, RetrievalMethod, SPKIData, X509Data, )
        if ('' !== ($mgmtDataChoiceErrorMessage = self::validateMgmtDataForChoiceConstraintsFromSetMgmtData($mgmtData))) {
            throw new InvalidArgumentException($mgmtDataChoiceErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(1)
        if (is_array($mgmtData) && count($mgmtData) > 1) {
            throw new InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 1', count($mgmtData)), __LINE__);
        }
        if (is_null($mgmtData) || (is_array($mgmtData) && empty($mgmtData))) {
            unset($this->MgmtData);
        } else {
            $this->MgmtData = $mgmtData;
        }
        return $this;
    }

    /**
     * This method is responsible for validating the value passed to the addToMgmtData method
     * This method is willingly generated in order to preserve the one-line inline validation within the addToMgmtData method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateItemForChoiceConstraintsFromAddToMgmtData($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'KeyName',
            'KeyValue',
            'PGPData',
            'RetrievalMethod',
            'SPKIData',
            'X509Data',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new InvalidArgumentException(sprintf('The property MgmtData can\'t be set as the property %s is already set. Only one property must be set among these properties: MgmtData, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }

    /**
     * Add item to MgmtData value
     * @param string $item
     * @return KeyInfoType
     * @throws InvalidArgumentException
     */
    public function addToMgmtData($item)
    {
        // validation for constraint: itemType
        if (!is_string($item)) {
            throw new InvalidArgumentException(sprintf('The MgmtData property can only contain items of type string, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: choice(KeyName, KeyValue, MgmtData, PGPData, RetrievalMethod, SPKIData, X509Data, )
        if ('' !== ($itemChoiceErrorMessage = self::validateItemForChoiceConstraintsFromAddToMgmtData($item))) {
            throw new InvalidArgumentException($itemChoiceErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(1)
        if (is_array($this->MgmtData) && count($this->MgmtData) >= 1) {
            throw new InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 1', count($this->MgmtData)), __LINE__);
        }
        $this->MgmtData[] = $item;
        return $this;
    }

    /**
     * Get PGPData value
     * @return PGPDataType[]|null
     */
    public function getPGPData()
    {
        return isset($this->PGPData) ? $this->PGPData : null;
    }

    /**
     * This method is responsible for validating the values passed to the setPGPData method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPGPData method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validatePGPDataForArrayConstraintsFromSetPGPData(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $keyInfoTypePGPDataItem) {
            // validation for constraint: itemType
            if (!$keyInfoTypePGPDataItem instanceof PGPDataType) {
                $invalidValues[] = is_object($keyInfoTypePGPDataItem) ? get_class($keyInfoTypePGPDataItem) : sprintf('%s(%s)', gettype($keyInfoTypePGPDataItem), var_export($keyInfoTypePGPDataItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The PGPData property can only contain items of type \Gek\UyumBahceGet\StructType\PGPDataType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }

    /**
     * This method is responsible for validating the value passed to the setPGPData method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPGPData method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validatePGPDataForChoiceConstraintsFromSetPGPData($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'KeyName',
            'KeyValue',
            'MgmtData',
            'RetrievalMethod',
            'SPKIData',
            'X509Data',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new InvalidArgumentException(sprintf('The property PGPData can\'t be set as the property %s is already set. Only one property must be set among these properties: PGPData, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }

    /**
     * Set PGPData value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @param PGPDataType[] $pGPData
     * @return KeyInfoType
     * @throws InvalidArgumentException
     * @throws InvalidArgumentException
     */
    public function setPGPData(array $pGPData = array())
    {
        // validation for constraint: array
        if ('' !== ($pGPDataArrayErrorMessage = self::validatePGPDataForArrayConstraintsFromSetPGPData($pGPData))) {
            throw new InvalidArgumentException($pGPDataArrayErrorMessage, __LINE__);
        }
        // validation for constraint: choice(KeyName, KeyValue, MgmtData, PGPData, RetrievalMethod, SPKIData, X509Data, )
        if ('' !== ($pGPDataChoiceErrorMessage = self::validatePGPDataForChoiceConstraintsFromSetPGPData($pGPData))) {
            throw new InvalidArgumentException($pGPDataChoiceErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(1)
        if (is_array($pGPData) && count($pGPData) > 1) {
            throw new InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 1', count($pGPData)), __LINE__);
        }
        if (is_null($pGPData) || (is_array($pGPData) && empty($pGPData))) {
            unset($this->PGPData);
        } else {
            $this->PGPData = $pGPData;
        }
        return $this;
    }

    /**
     * This method is responsible for validating the value passed to the addToPGPData method
     * This method is willingly generated in order to preserve the one-line inline validation within the addToPGPData method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateItemForChoiceConstraintsFromAddToPGPData($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'KeyName',
            'KeyValue',
            'MgmtData',
            'RetrievalMethod',
            'SPKIData',
            'X509Data',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new InvalidArgumentException(sprintf('The property PGPData can\'t be set as the property %s is already set. Only one property must be set among these properties: PGPData, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }

    /**
     * Add item to PGPData value
     * @param PGPDataType $item
     * @return KeyInfoType
     * @throws InvalidArgumentException
     */
    public function addToPGPData(PGPDataType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof PGPDataType) {
            throw new InvalidArgumentException(sprintf('The PGPData property can only contain items of type \Gek\UyumBahceGet\StructType\PGPDataType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: choice(KeyName, KeyValue, MgmtData, PGPData, RetrievalMethod, SPKIData, X509Data, )
        if ('' !== ($itemChoiceErrorMessage = self::validateItemForChoiceConstraintsFromAddToPGPData($item))) {
            throw new InvalidArgumentException($itemChoiceErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(1)
        if (is_array($this->PGPData) && count($this->PGPData) >= 1) {
            throw new InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 1', count($this->PGPData)), __LINE__);
        }
        $this->PGPData[] = $item;
        return $this;
    }

    /**
     * Get RetrievalMethod value
     * @return RetrievalMethodType[]|null
     */
    public function getRetrievalMethod()
    {
        return isset($this->RetrievalMethod) ? $this->RetrievalMethod : null;
    }

    /**
     * This method is responsible for validating the values passed to the setRetrievalMethod method
     * This method is willingly generated in order to preserve the one-line inline validation within the setRetrievalMethod method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateRetrievalMethodForArrayConstraintsFromSetRetrievalMethod(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $keyInfoTypeRetrievalMethodItem) {
            // validation for constraint: itemType
            if (!$keyInfoTypeRetrievalMethodItem instanceof RetrievalMethodType) {
                $invalidValues[] = is_object($keyInfoTypeRetrievalMethodItem) ? get_class($keyInfoTypeRetrievalMethodItem) : sprintf('%s(%s)', gettype($keyInfoTypeRetrievalMethodItem), var_export($keyInfoTypeRetrievalMethodItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The RetrievalMethod property can only contain items of type \Gek\UyumBahceGet\StructType\RetrievalMethodType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }

    /**
     * This method is responsible for validating the value passed to the setRetrievalMethod method
     * This method is willingly generated in order to preserve the one-line inline validation within the setRetrievalMethod method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateRetrievalMethodForChoiceConstraintsFromSetRetrievalMethod($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'KeyName',
            'KeyValue',
            'MgmtData',
            'PGPData',
            'SPKIData',
            'X509Data',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new InvalidArgumentException(sprintf('The property RetrievalMethod can\'t be set as the property %s is already set. Only one property must be set among these properties: RetrievalMethod, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }

    /**
     * Set RetrievalMethod value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @param RetrievalMethodType[] $retrievalMethod
     * @return KeyInfoType
     * @throws InvalidArgumentException
     * @throws InvalidArgumentException
     */
    public function setRetrievalMethod(array $retrievalMethod = array())
    {
        // validation for constraint: array
        if ('' !== ($retrievalMethodArrayErrorMessage = self::validateRetrievalMethodForArrayConstraintsFromSetRetrievalMethod($retrievalMethod))) {
            throw new InvalidArgumentException($retrievalMethodArrayErrorMessage, __LINE__);
        }
        // validation for constraint: choice(KeyName, KeyValue, MgmtData, PGPData, RetrievalMethod, SPKIData, X509Data, )
        if ('' !== ($retrievalMethodChoiceErrorMessage = self::validateRetrievalMethodForChoiceConstraintsFromSetRetrievalMethod($retrievalMethod))) {
            throw new InvalidArgumentException($retrievalMethodChoiceErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(1)
        if (is_array($retrievalMethod) && count($retrievalMethod) > 1) {
            throw new InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 1', count($retrievalMethod)), __LINE__);
        }
        if (is_null($retrievalMethod) || (is_array($retrievalMethod) && empty($retrievalMethod))) {
            unset($this->RetrievalMethod);
        } else {
            $this->RetrievalMethod = $retrievalMethod;
        }
        return $this;
    }

    /**
     * This method is responsible for validating the value passed to the addToRetrievalMethod method
     * This method is willingly generated in order to preserve the one-line inline validation within the addToRetrievalMethod method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateItemForChoiceConstraintsFromAddToRetrievalMethod($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'KeyName',
            'KeyValue',
            'MgmtData',
            'PGPData',
            'SPKIData',
            'X509Data',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new InvalidArgumentException(sprintf('The property RetrievalMethod can\'t be set as the property %s is already set. Only one property must be set among these properties: RetrievalMethod, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }

    /**
     * Add item to RetrievalMethod value
     * @param RetrievalMethodType $item
     * @return KeyInfoType
     * @throws InvalidArgumentException
     */
    public function addToRetrievalMethod(RetrievalMethodType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof RetrievalMethodType) {
            throw new InvalidArgumentException(sprintf('The RetrievalMethod property can only contain items of type \Gek\UyumBahceGet\StructType\RetrievalMethodType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: choice(KeyName, KeyValue, MgmtData, PGPData, RetrievalMethod, SPKIData, X509Data, )
        if ('' !== ($itemChoiceErrorMessage = self::validateItemForChoiceConstraintsFromAddToRetrievalMethod($item))) {
            throw new InvalidArgumentException($itemChoiceErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(1)
        if (is_array($this->RetrievalMethod) && count($this->RetrievalMethod) >= 1) {
            throw new InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 1', count($this->RetrievalMethod)), __LINE__);
        }
        $this->RetrievalMethod[] = $item;
        return $this;
    }

    /**
     * Get SPKIData value
     * @return SPKIDataType[]|null
     */
    public function getSPKIData()
    {
        return isset($this->SPKIData) ? $this->SPKIData : null;
    }

    /**
     * This method is responsible for validating the values passed to the setSPKIData method
     * This method is willingly generated in order to preserve the one-line inline validation within the setSPKIData method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateSPKIDataForArrayConstraintsFromSetSPKIData(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $keyInfoTypeSPKIDataItem) {
            // validation for constraint: itemType
            if (!$keyInfoTypeSPKIDataItem instanceof SPKIDataType) {
                $invalidValues[] = is_object($keyInfoTypeSPKIDataItem) ? get_class($keyInfoTypeSPKIDataItem) : sprintf('%s(%s)', gettype($keyInfoTypeSPKIDataItem), var_export($keyInfoTypeSPKIDataItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The SPKIData property can only contain items of type \Gek\UyumBahceGet\StructType\SPKIDataType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }

    /**
     * This method is responsible for validating the value passed to the setSPKIData method
     * This method is willingly generated in order to preserve the one-line inline validation within the setSPKIData method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateSPKIDataForChoiceConstraintsFromSetSPKIData($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'KeyName',
            'KeyValue',
            'MgmtData',
            'PGPData',
            'RetrievalMethod',
            'X509Data',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new InvalidArgumentException(sprintf('The property SPKIData can\'t be set as the property %s is already set. Only one property must be set among these properties: SPKIData, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }

    /**
     * Set SPKIData value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @param SPKIDataType[] $sPKIData
     * @return KeyInfoType
     * @throws InvalidArgumentException
     * @throws InvalidArgumentException
     */
    public function setSPKIData(array $sPKIData = array())
    {
        // validation for constraint: array
        if ('' !== ($sPKIDataArrayErrorMessage = self::validateSPKIDataForArrayConstraintsFromSetSPKIData($sPKIData))) {
            throw new InvalidArgumentException($sPKIDataArrayErrorMessage, __LINE__);
        }
        // validation for constraint: choice(KeyName, KeyValue, MgmtData, PGPData, RetrievalMethod, SPKIData, X509Data, )
        if ('' !== ($sPKIDataChoiceErrorMessage = self::validateSPKIDataForChoiceConstraintsFromSetSPKIData($sPKIData))) {
            throw new InvalidArgumentException($sPKIDataChoiceErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(1)
        if (is_array($sPKIData) && count($sPKIData) > 1) {
            throw new InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 1', count($sPKIData)), __LINE__);
        }
        if (is_null($sPKIData) || (is_array($sPKIData) && empty($sPKIData))) {
            unset($this->SPKIData);
        } else {
            $this->SPKIData = $sPKIData;
        }
        return $this;
    }

    /**
     * This method is responsible for validating the value passed to the addToSPKIData method
     * This method is willingly generated in order to preserve the one-line inline validation within the addToSPKIData method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateItemForChoiceConstraintsFromAddToSPKIData($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'KeyName',
            'KeyValue',
            'MgmtData',
            'PGPData',
            'RetrievalMethod',
            'X509Data',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new InvalidArgumentException(sprintf('The property SPKIData can\'t be set as the property %s is already set. Only one property must be set among these properties: SPKIData, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }

    /**
     * Add item to SPKIData value
     * @param SPKIDataType $item
     * @return KeyInfoType
     * @throws InvalidArgumentException
     */
    public function addToSPKIData(SPKIDataType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof SPKIDataType) {
            throw new InvalidArgumentException(sprintf('The SPKIData property can only contain items of type \Gek\UyumBahceGet\StructType\SPKIDataType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: choice(KeyName, KeyValue, MgmtData, PGPData, RetrievalMethod, SPKIData, X509Data, )
        if ('' !== ($itemChoiceErrorMessage = self::validateItemForChoiceConstraintsFromAddToSPKIData($item))) {
            throw new InvalidArgumentException($itemChoiceErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(1)
        if (is_array($this->SPKIData) && count($this->SPKIData) >= 1) {
            throw new InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 1', count($this->SPKIData)), __LINE__);
        }
        $this->SPKIData[] = $item;
        return $this;
    }

    /**
     * Get X509Data value
     * @return X509DataType[]|null
     */
    public function getX509Data()
    {
        return isset($this->X509Data) ? $this->X509Data : null;
    }

    /**
     * This method is responsible for validating the values passed to the setX509Data method
     * This method is willingly generated in order to preserve the one-line inline validation within the setX509Data method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateX509DataForArrayConstraintsFromSetX509Data(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $keyInfoTypeX509DataItem) {
            // validation for constraint: itemType
            if (!$keyInfoTypeX509DataItem instanceof X509DataType) {
                $invalidValues[] = is_object($keyInfoTypeX509DataItem) ? get_class($keyInfoTypeX509DataItem) : sprintf('%s(%s)', gettype($keyInfoTypeX509DataItem), var_export($keyInfoTypeX509DataItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The X509Data property can only contain items of type \Gek\UyumBahceGet\StructType\X509DataType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }

    /**
     * This method is responsible for validating the value passed to the setX509Data method
     * This method is willingly generated in order to preserve the one-line inline validation within the setX509Data method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateX509DataForChoiceConstraintsFromSetX509Data($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'KeyName',
            'KeyValue',
            'MgmtData',
            'PGPData',
            'RetrievalMethod',
            'SPKIData',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new InvalidArgumentException(sprintf('The property X509Data can\'t be set as the property %s is already set. Only one property must be set among these properties: X509Data, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }

    /**
     * Set X509Data value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @param X509DataType[] $x509Data
     * @return KeyInfoType
     * @throws InvalidArgumentException
     * @throws InvalidArgumentException
     */
    public function setX509Data(array $x509Data = array())
    {
        // validation for constraint: array
        if ('' !== ($x509DataArrayErrorMessage = self::validateX509DataForArrayConstraintsFromSetX509Data($x509Data))) {
            throw new InvalidArgumentException($x509DataArrayErrorMessage, __LINE__);
        }
        // validation for constraint: choice(KeyName, KeyValue, MgmtData, PGPData, RetrievalMethod, SPKIData, X509Data, )
        if ('' !== ($x509DataChoiceErrorMessage = self::validateX509DataForChoiceConstraintsFromSetX509Data($x509Data))) {
            throw new InvalidArgumentException($x509DataChoiceErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(1)
        if (is_array($x509Data) && count($x509Data) > 1) {
            throw new InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 1', count($x509Data)), __LINE__);
        }
        if (is_null($x509Data) || (is_array($x509Data) && empty($x509Data))) {
            unset($this->X509Data);
        } else {
            $this->X509Data = $x509Data;
        }
        return $this;
    }

    /**
     * This method is responsible for validating the value passed to the addToX509Data method
     * This method is willingly generated in order to preserve the one-line inline validation within the addToX509Data method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateItemForChoiceConstraintsFromAddToX509Data($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'KeyName',
            'KeyValue',
            'MgmtData',
            'PGPData',
            'RetrievalMethod',
            'SPKIData',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new InvalidArgumentException(sprintf('The property X509Data can\'t be set as the property %s is already set. Only one property must be set among these properties: X509Data, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }

    /**
     * Add item to X509Data value
     * @param X509DataType $item
     * @return KeyInfoType
     * @throws InvalidArgumentException
     */
    public function addToX509Data(X509DataType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof X509DataType) {
            throw new InvalidArgumentException(sprintf('The X509Data property can only contain items of type \Gek\UyumBahceGet\StructType\X509DataType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: choice(KeyName, KeyValue, MgmtData, PGPData, RetrievalMethod, SPKIData, X509Data, )
        if ('' !== ($itemChoiceErrorMessage = self::validateItemForChoiceConstraintsFromAddToX509Data($item))) {
            throw new InvalidArgumentException($itemChoiceErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(1)
        if (is_array($this->X509Data) && count($this->X509Data) >= 1) {
            throw new InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 1', count($this->X509Data)), __LINE__);
        }
        $this->X509Data[] = $item;
        return $this;
    }

    /**
     * Get any value
     * @param bool $asString true: returns XML string, false: returns \DOMDocument
     * @return DOMDocument|null
     * @uses \DOMDocument::loadXML()
     */
    public function getAny($asString = true)
    {
        $domDocument = null;
        if (!empty($this->any) && !$asString) {
            $domDocument = new DOMDocument('1.0', 'UTF-8');
            $domDocument->loadXML($this->any);
        }
        return $asString ? $this->any : $domDocument;
    }

    /**
     * Set any value
     * @param DOMDocument $any
     * @return KeyInfoType
     * @uses \DOMNode::item()
     * @uses \DOMDocument::hasChildNodes()
     * @uses \DOMDocument::saveXML()
     */
    public function setAny(DOMDocument $any = null)
    {
        $this->any = ($any instanceof DOMDocument) && $any->hasChildNodes() ? $any->saveXML($any->childNodes->item(0)) : $any;
        return $this;
    }

    /**
     * Get Id value
     * @return string|null
     */
    public function getId()
    {
        return $this->Id;
    }

    /**
     * Set Id value
     * @param string $id
     * @return KeyInfoType
     */
    public function setId($id = null)
    {
        // validation for constraint: string
        if (!is_null($id) && !is_string($id)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($id, true), gettype($id)), __LINE__);
        }
        $this->Id = $id;
        return $this;
    }
}
