<?php

namespace Gek\UyumBahceGet\StructType;

use InvalidArgumentException;
use WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ItemPropertyType StructType
 * @subpackage Structs
 */
class ItemPropertyType extends AbstractStructBase
{
    /**
     * The ID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: s4:ID
     * @var IDType
     */
    public $ID;
    /**
     * The Name
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: s4:Name
     * @var NameType
     */
    public $Name;
    /**
     * The NameCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: s4:NameCode
     * @var NameCodeType
     */
    public $NameCode;
    /**
     * The TestMethod
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: s4:TestMethod
     * @var TestMethodType
     */
    public $TestMethod;
    /**
     * The Value
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: s4:Value
     * @var ValueType
     */
    public $Value;
    /**
     * The ValueQuantity
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: s4:ValueQuantity
     * @var ValueQuantityType
     */
    public $ValueQuantity;
    /**
     * The ValueQualifier
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - ref: s4:ValueQualifier
     * @var ValueQualifierType[]
     */
    public $ValueQualifier;
    /**
     * The ImportanceCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: s4:ImportanceCode
     * @var ImportanceCodeType
     */
    public $ImportanceCode;
    /**
     * The ListValue
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - ref: s4:ListValue
     * @var ListValueType[]
     */
    public $ListValue;
    /**
     * The UsabilityPeriod
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var PeriodType
     */
    public $UsabilityPeriod;
    /**
     * The ItemPropertyGroup
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var ItemPropertyGroupType[]
     */
    public $ItemPropertyGroup;
    /**
     * The RangeDimension
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var DimensionType
     */
    public $RangeDimension;
    /**
     * The ItemPropertyRange
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var ItemPropertyRangeType
     */
    public $ItemPropertyRange;

    /**
     * Constructor method for ItemPropertyType
     * @param IDType $iD
     * @param NameType $name
     * @param NameCodeType $nameCode
     * @param TestMethodType $testMethod
     * @param ValueType $value
     * @param ValueQuantityType $valueQuantity
     * @param ValueQualifierType[] $valueQualifier
     * @param ImportanceCodeType $importanceCode
     * @param ListValueType[] $listValue
     * @param PeriodType $usabilityPeriod
     * @param ItemPropertyGroupType[] $itemPropertyGroup
     * @param DimensionType $rangeDimension
     * @param ItemPropertyRangeType $itemPropertyRange
     * @uses ItemPropertyType::setID()
     * @uses ItemPropertyType::setName()
     * @uses ItemPropertyType::setNameCode()
     * @uses ItemPropertyType::setTestMethod()
     * @uses ItemPropertyType::setValue()
     * @uses ItemPropertyType::setValueQuantity()
     * @uses ItemPropertyType::setValueQualifier()
     * @uses ItemPropertyType::setImportanceCode()
     * @uses ItemPropertyType::setListValue()
     * @uses ItemPropertyType::setUsabilityPeriod()
     * @uses ItemPropertyType::setItemPropertyGroup()
     * @uses ItemPropertyType::setRangeDimension()
     * @uses ItemPropertyType::setItemPropertyRange()
     */
    public function __construct(IDType $iD = null, NameType $name = null, NameCodeType $nameCode = null, TestMethodType $testMethod = null, ValueType $value = null, ValueQuantityType $valueQuantity = null, array $valueQualifier = array(), ImportanceCodeType $importanceCode = null, array $listValue = array(), PeriodType $usabilityPeriod = null, array $itemPropertyGroup = array(), DimensionType $rangeDimension = null, ItemPropertyRangeType $itemPropertyRange = null)
    {
        $this
            ->setID($iD)
            ->setName($name)
            ->setNameCode($nameCode)
            ->setTestMethod($testMethod)
            ->setValue($value)
            ->setValueQuantity($valueQuantity)
            ->setValueQualifier($valueQualifier)
            ->setImportanceCode($importanceCode)
            ->setListValue($listValue)
            ->setUsabilityPeriod($usabilityPeriod)
            ->setItemPropertyGroup($itemPropertyGroup)
            ->setRangeDimension($rangeDimension)
            ->setItemPropertyRange($itemPropertyRange);
    }

    /**
     * Get ID value
     * @return IDType|null
     */
    public function getID()
    {
        return $this->ID;
    }

    /**
     * Set ID value
     * @param IDType $iD
     * @return ItemPropertyType
     */
    public function setID(IDType $iD = null)
    {
        $this->ID = $iD;
        return $this;
    }

    /**
     * Get Name value
     * @return NameType|null
     */
    public function getName()
    {
        return $this->Name;
    }

    /**
     * Set Name value
     * @param NameType $name
     * @return ItemPropertyType
     */
    public function setName(NameType $name = null)
    {
        $this->Name = $name;
        return $this;
    }

    /**
     * Get NameCode value
     * @return NameCodeType|null
     */
    public function getNameCode()
    {
        return $this->NameCode;
    }

    /**
     * Set NameCode value
     * @param NameCodeType $nameCode
     * @return ItemPropertyType
     */
    public function setNameCode(NameCodeType $nameCode = null)
    {
        $this->NameCode = $nameCode;
        return $this;
    }

    /**
     * Get TestMethod value
     * @return TestMethodType|null
     */
    public function getTestMethod()
    {
        return $this->TestMethod;
    }

    /**
     * Set TestMethod value
     * @param TestMethodType $testMethod
     * @return ItemPropertyType
     */
    public function setTestMethod(TestMethodType $testMethod = null)
    {
        $this->TestMethod = $testMethod;
        return $this;
    }

    /**
     * Get Value value
     * @return ValueType|null
     */
    public function getValue()
    {
        return $this->Value;
    }

    /**
     * Set Value value
     * @param ValueType $value
     * @return ItemPropertyType
     */
    public function setValue(ValueType $value = null)
    {
        $this->Value = $value;
        return $this;
    }

    /**
     * Get ValueQuantity value
     * @return ValueQuantityType|null
     */
    public function getValueQuantity()
    {
        return $this->ValueQuantity;
    }

    /**
     * Set ValueQuantity value
     * @param ValueQuantityType $valueQuantity
     * @return ItemPropertyType
     */
    public function setValueQuantity(ValueQuantityType $valueQuantity = null)
    {
        $this->ValueQuantity = $valueQuantity;
        return $this;
    }

    /**
     * Get ValueQualifier value
     * @return ValueQualifierType[]|null
     */
    public function getValueQualifier()
    {
        return $this->ValueQualifier;
    }

    /**
     * This method is responsible for validating the values passed to the setValueQualifier method
     * This method is willingly generated in order to preserve the one-line inline validation within the setValueQualifier method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateValueQualifierForArrayConstraintsFromSetValueQualifier(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $itemPropertyTypeValueQualifierItem) {
            // validation for constraint: itemType
            if (!$itemPropertyTypeValueQualifierItem instanceof ValueQualifierType) {
                $invalidValues[] = is_object($itemPropertyTypeValueQualifierItem) ? get_class($itemPropertyTypeValueQualifierItem) : sprintf('%s(%s)', gettype($itemPropertyTypeValueQualifierItem), var_export($itemPropertyTypeValueQualifierItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The ValueQualifier property can only contain items of type \Gek\UyumBahceGet\StructType\ValueQualifierType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }

    /**
     * Set ValueQualifier value
     * @param ValueQualifierType[] $valueQualifier
     * @return ItemPropertyType
     * @throws InvalidArgumentException
     */
    public function setValueQualifier(array $valueQualifier = array())
    {
        // validation for constraint: array
        if ('' !== ($valueQualifierArrayErrorMessage = self::validateValueQualifierForArrayConstraintsFromSetValueQualifier($valueQualifier))) {
            throw new InvalidArgumentException($valueQualifierArrayErrorMessage, __LINE__);
        }
        $this->ValueQualifier = $valueQualifier;
        return $this;
    }

    /**
     * Add item to ValueQualifier value
     * @param ValueQualifierType $item
     * @return ItemPropertyType
     * @throws InvalidArgumentException
     */
    public function addToValueQualifier(ValueQualifierType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof ValueQualifierType) {
            throw new InvalidArgumentException(sprintf('The ValueQualifier property can only contain items of type \Gek\UyumBahceGet\StructType\ValueQualifierType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->ValueQualifier[] = $item;
        return $this;
    }

    /**
     * Get ImportanceCode value
     * @return ImportanceCodeType|null
     */
    public function getImportanceCode()
    {
        return $this->ImportanceCode;
    }

    /**
     * Set ImportanceCode value
     * @param ImportanceCodeType $importanceCode
     * @return ItemPropertyType
     */
    public function setImportanceCode(ImportanceCodeType $importanceCode = null)
    {
        $this->ImportanceCode = $importanceCode;
        return $this;
    }

    /**
     * Get ListValue value
     * @return ListValueType[]|null
     */
    public function getListValue()
    {
        return $this->ListValue;
    }

    /**
     * This method is responsible for validating the values passed to the setListValue method
     * This method is willingly generated in order to preserve the one-line inline validation within the setListValue method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateListValueForArrayConstraintsFromSetListValue(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $itemPropertyTypeListValueItem) {
            // validation for constraint: itemType
            if (!$itemPropertyTypeListValueItem instanceof ListValueType) {
                $invalidValues[] = is_object($itemPropertyTypeListValueItem) ? get_class($itemPropertyTypeListValueItem) : sprintf('%s(%s)', gettype($itemPropertyTypeListValueItem), var_export($itemPropertyTypeListValueItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The ListValue property can only contain items of type \Gek\UyumBahceGet\StructType\ListValueType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }

    /**
     * Set ListValue value
     * @param ListValueType[] $listValue
     * @return ItemPropertyType
     * @throws InvalidArgumentException
     */
    public function setListValue(array $listValue = array())
    {
        // validation for constraint: array
        if ('' !== ($listValueArrayErrorMessage = self::validateListValueForArrayConstraintsFromSetListValue($listValue))) {
            throw new InvalidArgumentException($listValueArrayErrorMessage, __LINE__);
        }
        $this->ListValue = $listValue;
        return $this;
    }

    /**
     * Add item to ListValue value
     * @param ListValueType $item
     * @return ItemPropertyType
     * @throws InvalidArgumentException
     */
    public function addToListValue(ListValueType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof ListValueType) {
            throw new InvalidArgumentException(sprintf('The ListValue property can only contain items of type \Gek\UyumBahceGet\StructType\ListValueType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->ListValue[] = $item;
        return $this;
    }

    /**
     * Get UsabilityPeriod value
     * @return PeriodType|null
     */
    public function getUsabilityPeriod()
    {
        return $this->UsabilityPeriod;
    }

    /**
     * Set UsabilityPeriod value
     * @param PeriodType $usabilityPeriod
     * @return ItemPropertyType
     */
    public function setUsabilityPeriod(PeriodType $usabilityPeriod = null)
    {
        $this->UsabilityPeriod = $usabilityPeriod;
        return $this;
    }

    /**
     * Get ItemPropertyGroup value
     * @return ItemPropertyGroupType[]|null
     */
    public function getItemPropertyGroup()
    {
        return $this->ItemPropertyGroup;
    }

    /**
     * This method is responsible for validating the values passed to the setItemPropertyGroup method
     * This method is willingly generated in order to preserve the one-line inline validation within the setItemPropertyGroup method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateItemPropertyGroupForArrayConstraintsFromSetItemPropertyGroup(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $itemPropertyTypeItemPropertyGroupItem) {
            // validation for constraint: itemType
            if (!$itemPropertyTypeItemPropertyGroupItem instanceof ItemPropertyGroupType) {
                $invalidValues[] = is_object($itemPropertyTypeItemPropertyGroupItem) ? get_class($itemPropertyTypeItemPropertyGroupItem) : sprintf('%s(%s)', gettype($itemPropertyTypeItemPropertyGroupItem), var_export($itemPropertyTypeItemPropertyGroupItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The ItemPropertyGroup property can only contain items of type \Gek\UyumBahceGet\StructType\ItemPropertyGroupType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }

    /**
     * Set ItemPropertyGroup value
     * @param ItemPropertyGroupType[] $itemPropertyGroup
     * @return ItemPropertyType
     * @throws InvalidArgumentException
     */
    public function setItemPropertyGroup(array $itemPropertyGroup = array())
    {
        // validation for constraint: array
        if ('' !== ($itemPropertyGroupArrayErrorMessage = self::validateItemPropertyGroupForArrayConstraintsFromSetItemPropertyGroup($itemPropertyGroup))) {
            throw new InvalidArgumentException($itemPropertyGroupArrayErrorMessage, __LINE__);
        }
        $this->ItemPropertyGroup = $itemPropertyGroup;
        return $this;
    }

    /**
     * Add item to ItemPropertyGroup value
     * @param ItemPropertyGroupType $item
     * @return ItemPropertyType
     * @throws InvalidArgumentException
     */
    public function addToItemPropertyGroup(ItemPropertyGroupType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof ItemPropertyGroupType) {
            throw new InvalidArgumentException(sprintf('The ItemPropertyGroup property can only contain items of type \Gek\UyumBahceGet\StructType\ItemPropertyGroupType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->ItemPropertyGroup[] = $item;
        return $this;
    }

    /**
     * Get RangeDimension value
     * @return DimensionType|null
     */
    public function getRangeDimension()
    {
        return $this->RangeDimension;
    }

    /**
     * Set RangeDimension value
     * @param DimensionType $rangeDimension
     * @return ItemPropertyType
     */
    public function setRangeDimension(DimensionType $rangeDimension = null)
    {
        $this->RangeDimension = $rangeDimension;
        return $this;
    }

    /**
     * Get ItemPropertyRange value
     * @return ItemPropertyRangeType|null
     */
    public function getItemPropertyRange()
    {
        return $this->ItemPropertyRange;
    }

    /**
     * Set ItemPropertyRange value
     * @param ItemPropertyRangeType $itemPropertyRange
     * @return ItemPropertyType
     */
    public function setItemPropertyRange(ItemPropertyRangeType $itemPropertyRange = null)
    {
        $this->ItemPropertyRange = $itemPropertyRange;
        return $this;
    }
}
