<?php

namespace Gek\UyumBahceGet\StructType;

use InvalidArgumentException;
use WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ItemImageClass StructType
 * @subpackage Structs
 */
class ItemImageClass extends AbstractStructBase
{
    /**
     * The ItemId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $ItemId;
    /**
     * The Image
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Image;

    /**
     * Constructor method for ItemImageClass
     * @param int $itemId
     * @param string $image
     * @uses ItemImageClass::setItemId()
     * @uses ItemImageClass::setImage()
     */
    public function __construct($itemId = null, $image = null)
    {
        $this
            ->setItemId($itemId)
            ->setImage($image);
    }

    /**
     * Get ItemId value
     * @return int
     */
    public function getItemId()
    {
        return $this->ItemId;
    }

    /**
     * Set ItemId value
     * @param int $itemId
     * @return ItemImageClass
     */
    public function setItemId($itemId = null)
    {
        // validation for constraint: int
        if (!is_null($itemId) && !(is_int($itemId) || ctype_digit($itemId))) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($itemId, true), gettype($itemId)), __LINE__);
        }
        $this->ItemId = $itemId;
        return $this;
    }

    /**
     * Get Image value
     * @return string|null
     */
    public function getImage()
    {
        return $this->Image;
    }

    /**
     * Set Image value
     * @param string $image
     * @return ItemImageClass
     */
    public function setImage($image = null)
    {
        // validation for constraint: string
        if (!is_null($image) && !is_string($image)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($image, true), gettype($image)), __LINE__);
        }
        $this->Image = $image;
        return $this;
    }
}
