<?php

namespace Gek\UyumBahceGet\StructType;

use Gek\UyumBahceGet\EnumType\InvoiceStatus;
use InvalidArgumentException;
use WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for InvoiceStatusWithLogInfo StructType
 * @subpackage Structs
 */
class InvoiceStatusWithLogInfo extends AbstractStructBase
{
    /**
     * The EnvelopeStatusCode
     * Meta information extracted from the WSDL
     * - use: required
     * @var int
     */
    public $EnvelopeStatusCode;
    /**
     * The Status
     * Meta information extracted from the WSDL
     * - use: required
     * @var string
     */
    public $Status;
    /**
     * The StatusCode
     * Meta information extracted from the WSDL
     * - use: required
     * @var int
     */
    public $StatusCode;
    /**
     * The LocalDocumentId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $LocalDocumentId;
    /**
     * The Logs
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var InvoiceLogItem[]
     */
    public $Logs;
    /**
     * The Message
     * @var string
     */
    public $Message;
    /**
     * The InvoiceId
     * @var string
     */
    public $InvoiceId;

    /**
     * Constructor method for InvoiceStatusWithLogInfo
     * @param int $envelopeStatusCode
     * @param string $status
     * @param int $statusCode
     * @param string $localDocumentId
     * @param InvoiceLogItem[] $logs
     * @param string $message
     * @param string $invoiceId
     * @uses InvoiceStatusWithLogInfo::setEnvelopeStatusCode()
     * @uses InvoiceStatusWithLogInfo::setStatus()
     * @uses InvoiceStatusWithLogInfo::setStatusCode()
     * @uses InvoiceStatusWithLogInfo::setLocalDocumentId()
     * @uses InvoiceStatusWithLogInfo::setLogs()
     * @uses InvoiceStatusWithLogInfo::setMessage()
     * @uses InvoiceStatusWithLogInfo::setInvoiceId()
     */
    public function __construct($envelopeStatusCode = null, $status = null, $statusCode = null, $localDocumentId = null, array $logs = array(), $message = null, $invoiceId = null)
    {
        $this
            ->setEnvelopeStatusCode($envelopeStatusCode)
            ->setStatus($status)
            ->setStatusCode($statusCode)
            ->setLocalDocumentId($localDocumentId)
            ->setLogs($logs)
            ->setMessage($message)
            ->setInvoiceId($invoiceId);
    }

    /**
     * Get EnvelopeStatusCode value
     * @return int
     */
    public function getEnvelopeStatusCode()
    {
        return $this->EnvelopeStatusCode;
    }

    /**
     * Set EnvelopeStatusCode value
     * @param int $envelopeStatusCode
     * @return InvoiceStatusWithLogInfo
     */
    public function setEnvelopeStatusCode($envelopeStatusCode = null)
    {
        // validation for constraint: int
        if (!is_null($envelopeStatusCode) && !(is_int($envelopeStatusCode) || ctype_digit($envelopeStatusCode))) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($envelopeStatusCode, true), gettype($envelopeStatusCode)), __LINE__);
        }
        $this->EnvelopeStatusCode = $envelopeStatusCode;
        return $this;
    }

    /**
     * Get Status value
     * @return string
     */
    public function getStatus()
    {
        return $this->Status;
    }

    /**
     * Set Status value
     * @param string $status
     * @return InvoiceStatusWithLogInfo
     * @throws InvalidArgumentException
     * @uses \Gek\UyumBahceGet\EnumType\InvoiceStatus::getValidValues()
     * @uses \Gek\UyumBahceGet\EnumType\InvoiceStatus::valueIsValid()
     */
    public function setStatus($status = null)
    {
        // validation for constraint: enumeration
        if (!InvoiceStatus::valueIsValid($status)) {
            throw new InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \Gek\UyumBahceGet\EnumType\InvoiceStatus', is_array($status) ? implode(', ', $status) : var_export($status, true), implode(', ', InvoiceStatus::getValidValues())), __LINE__);
        }
        $this->Status = $status;
        return $this;
    }

    /**
     * Get StatusCode value
     * @return int
     */
    public function getStatusCode()
    {
        return $this->StatusCode;
    }

    /**
     * Set StatusCode value
     * @param int $statusCode
     * @return InvoiceStatusWithLogInfo
     */
    public function setStatusCode($statusCode = null)
    {
        // validation for constraint: int
        if (!is_null($statusCode) && !(is_int($statusCode) || ctype_digit($statusCode))) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($statusCode, true), gettype($statusCode)), __LINE__);
        }
        $this->StatusCode = $statusCode;
        return $this;
    }

    /**
     * Get LocalDocumentId value
     * @return string|null
     */
    public function getLocalDocumentId()
    {
        return $this->LocalDocumentId;
    }

    /**
     * Set LocalDocumentId value
     * @param string $localDocumentId
     * @return InvoiceStatusWithLogInfo
     */
    public function setLocalDocumentId($localDocumentId = null)
    {
        // validation for constraint: string
        if (!is_null($localDocumentId) && !is_string($localDocumentId)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($localDocumentId, true), gettype($localDocumentId)), __LINE__);
        }
        $this->LocalDocumentId = $localDocumentId;
        return $this;
    }

    /**
     * Get Logs value
     * @return InvoiceLogItem[]|null
     */
    public function getLogs()
    {
        return $this->Logs;
    }

    /**
     * This method is responsible for validating the values passed to the setLogs method
     * This method is willingly generated in order to preserve the one-line inline validation within the setLogs method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateLogsForArrayConstraintsFromSetLogs(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $invoiceStatusWithLogInfoLogsItem) {
            // validation for constraint: itemType
            if (!$invoiceStatusWithLogInfoLogsItem instanceof InvoiceLogItem) {
                $invalidValues[] = is_object($invoiceStatusWithLogInfoLogsItem) ? get_class($invoiceStatusWithLogInfoLogsItem) : sprintf('%s(%s)', gettype($invoiceStatusWithLogInfoLogsItem), var_export($invoiceStatusWithLogInfoLogsItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Logs property can only contain items of type \Gek\UyumBahceGet\StructType\InvoiceLogItem, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }

    /**
     * Set Logs value
     * @param InvoiceLogItem[] $logs
     * @return InvoiceStatusWithLogInfo
     * @throws InvalidArgumentException
     */
    public function setLogs(array $logs = array())
    {
        // validation for constraint: array
        if ('' !== ($logsArrayErrorMessage = self::validateLogsForArrayConstraintsFromSetLogs($logs))) {
            throw new InvalidArgumentException($logsArrayErrorMessage, __LINE__);
        }
        $this->Logs = $logs;
        return $this;
    }

    /**
     * Add item to Logs value
     * @param InvoiceLogItem $item
     * @return InvoiceStatusWithLogInfo
     * @throws InvalidArgumentException
     */
    public function addToLogs(InvoiceLogItem $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof InvoiceLogItem) {
            throw new InvalidArgumentException(sprintf('The Logs property can only contain items of type \Gek\UyumBahceGet\StructType\InvoiceLogItem, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Logs[] = $item;
        return $this;
    }

    /**
     * Get Message value
     * @return string|null
     */
    public function getMessage()
    {
        return $this->Message;
    }

    /**
     * Set Message value
     * @param string $message
     * @return InvoiceStatusWithLogInfo
     */
    public function setMessage($message = null)
    {
        // validation for constraint: string
        if (!is_null($message) && !is_string($message)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($message, true), gettype($message)), __LINE__);
        }
        $this->Message = $message;
        return $this;
    }

    /**
     * Get InvoiceId value
     * @return string|null
     */
    public function getInvoiceId()
    {
        return $this->InvoiceId;
    }

    /**
     * Set InvoiceId value
     * @param string $invoiceId
     * @return InvoiceStatusWithLogInfo
     */
    public function setInvoiceId($invoiceId = null)
    {
        // validation for constraint: string
        if (!is_null($invoiceId) && !is_string($invoiceId)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($invoiceId, true), gettype($invoiceId)), __LINE__);
        }
        $this->InvoiceId = $invoiceId;
        return $this;
    }
}
