<?php /** @noinspection PhpMissingParentConstructorInspection */

namespace Gek\UyumBahceGet\StructType;

use InvalidArgumentException;

/**
 * This class stands for InvoiceStatusResponse StructType
 * @subpackage Structs
 */
class InvoiceStatusResponse extends Response
{
    /**
     * The Value
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var InvoiceStatusInfo[]
     */
    public $Value;

    /**
     * Constructor method for InvoiceStatusResponse
     * @param InvoiceStatusInfo[] $value
     * @uses InvoiceStatusResponse::setValue()
     */
    public function __construct(array $value = array())
    {
        $this
            ->setValue($value);
    }

    /**
     * Get Value value
     * @return InvoiceStatusInfo[]|null
     */
    public function getValue()
    {
        return $this->Value;
    }

    /**
     * This method is responsible for validating the values passed to the setValue method
     * This method is willingly generated in order to preserve the one-line inline validation within the setValue method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateValueForArrayConstraintsFromSetValue(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $invoiceStatusResponseValueItem) {
            // validation for constraint: itemType
            if (!$invoiceStatusResponseValueItem instanceof InvoiceStatusInfo) {
                $invalidValues[] = is_object($invoiceStatusResponseValueItem) ? get_class($invoiceStatusResponseValueItem) : sprintf('%s(%s)', gettype($invoiceStatusResponseValueItem), var_export($invoiceStatusResponseValueItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Value property can only contain items of type \Gek\UyumBahceGet\StructType\InvoiceStatusInfo, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }

    /**
     * Set Value value
     * @param InvoiceStatusInfo[] $value
     * @return InvoiceStatusResponse
     * @throws InvalidArgumentException
     */
    public function setValue(array $value = array())
    {
        // validation for constraint: array
        if ('' !== ($valueArrayErrorMessage = self::validateValueForArrayConstraintsFromSetValue($value))) {
            throw new InvalidArgumentException($valueArrayErrorMessage, __LINE__);
        }
        $this->Value = $value;
        return $this;
    }

    /**
     * Add item to Value value
     * @param InvoiceStatusInfo $item
     * @return InvoiceStatusResponse
     * @throws InvalidArgumentException
     */
    public function addToValue(InvoiceStatusInfo $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof InvoiceStatusInfo) {
            throw new InvalidArgumentException(sprintf('The Value property can only contain items of type \Gek\UyumBahceGet\StructType\InvoiceStatusInfo, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Value[] = $item;
        return $this;
    }
}
