<?php

namespace Gek\UyumBahceGet\StructType;

use Gek\UyumBahceGet\EnumType\InvoiceStatus;
use InvalidArgumentException;
use WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for InvoiceStatusInfo StructType
 * @subpackage Structs
 */
class InvoiceStatusInfo extends AbstractStructBase
{
    /**
     * The Status
     * Meta information extracted from the WSDL
     * - use: required
     * @var string
     */
    public $Status;
    /**
     * The StatusCode
     * Meta information extracted from the WSDL
     * - use: required
     * @var int
     */
    public $StatusCode;
    /**
     * The InvoiceId
     * @var string
     */
    public $InvoiceId;
    /**
     * The Message
     * @var string
     */
    public $Message;

    /**
     * Constructor method for InvoiceStatusInfo
     * @param string $status
     * @param int $statusCode
     * @param string $invoiceId
     * @param string $message
     * @uses InvoiceStatusInfo::setStatus()
     * @uses InvoiceStatusInfo::setStatusCode()
     * @uses InvoiceStatusInfo::setInvoiceId()
     * @uses InvoiceStatusInfo::setMessage()
     */
    public function __construct($status = null, $statusCode = null, $invoiceId = null, $message = null)
    {
        $this
            ->setStatus($status)
            ->setStatusCode($statusCode)
            ->setInvoiceId($invoiceId)
            ->setMessage($message);
    }

    /**
     * Get Status value
     * @return string
     */
    public function getStatus()
    {
        return $this->Status;
    }

    /**
     * Set Status value
     * @param string $status
     * @return InvoiceStatusInfo
     * @throws InvalidArgumentException
     * @uses \Gek\UyumBahceGet\EnumType\InvoiceStatus::getValidValues()
     * @uses \Gek\UyumBahceGet\EnumType\InvoiceStatus::valueIsValid()
     */
    public function setStatus($status = null)
    {
        // validation for constraint: enumeration
        if (!InvoiceStatus::valueIsValid($status)) {
            throw new InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \Gek\UyumBahceGet\EnumType\InvoiceStatus', is_array($status) ? implode(', ', $status) : var_export($status, true), implode(', ', InvoiceStatus::getValidValues())), __LINE__);
        }
        $this->Status = $status;
        return $this;
    }

    /**
     * Get StatusCode value
     * @return int
     */
    public function getStatusCode()
    {
        return $this->StatusCode;
    }

    /**
     * Set StatusCode value
     * @param int $statusCode
     * @return InvoiceStatusInfo
     */
    public function setStatusCode($statusCode = null)
    {
        // validation for constraint: int
        if (!is_null($statusCode) && !(is_int($statusCode) || ctype_digit($statusCode))) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($statusCode, true), gettype($statusCode)), __LINE__);
        }
        $this->StatusCode = $statusCode;
        return $this;
    }

    /**
     * Get InvoiceId value
     * @return string|null
     */
    public function getInvoiceId()
    {
        return $this->InvoiceId;
    }

    /**
     * Set InvoiceId value
     * @param string $invoiceId
     * @return InvoiceStatusInfo
     */
    public function setInvoiceId($invoiceId = null)
    {
        // validation for constraint: string
        if (!is_null($invoiceId) && !is_string($invoiceId)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($invoiceId, true), gettype($invoiceId)), __LINE__);
        }
        $this->InvoiceId = $invoiceId;
        return $this;
    }

    /**
     * Get Message value
     * @return string|null
     */
    public function getMessage()
    {
        return $this->Message;
    }

    /**
     * Set Message value
     * @param string $message
     * @return InvoiceStatusInfo
     */
    public function setMessage($message = null)
    {
        // validation for constraint: string
        if (!is_null($message) && !is_string($message)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($message, true), gettype($message)), __LINE__);
        }
        $this->Message = $message;
        return $this;
    }
}
