<?php

namespace Gek\UyumBahceGet\StructType;

use Gek\UyumBahceGet\EnumType\EnvelopeStatus;
use Gek\UyumBahceGet\EnumType\InvoiceStatus;
use Gek\UyumBahceGet\EnumType\InvoiceTypes;
use InvalidArgumentException;
use WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for InvoiceListItemBase StructType
 * @subpackage Structs
 */
class InvoiceListItemBase extends AbstractStructBase
{
    /**
     * The Type
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $Type;
    /**
     * The TypeCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $TypeCode;
    /**
     * The Status
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $Status;
    /**
     * The StatusCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $StatusCode;
    /**
     * The EnvelopeStatus
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $EnvelopeStatus;
    /**
     * The EnvelopeStatusCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $EnvelopeStatusCode;
    /**
     * The CreateDateUtc
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $CreateDateUtc;
    /**
     * The ExecutionDate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $ExecutionDate;
    /**
     * The PayableAmount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $PayableAmount;
    /**
     * The TaxTotal
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $TaxTotal;
    /**
     * The TaxExclusiveAmount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $TaxExclusiveAmount;
    /**
     * The ExchangeRate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $ExchangeRate;
    /**
     * The Vat1
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $Vat1;
    /**
     * The Vat8
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $Vat8;
    /**
     * The Vat18
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $Vat18;
    /**
     * The Vat0TaxableAmount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $Vat0TaxableAmount;
    /**
     * The Vat1TaxableAmount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $Vat1TaxableAmount;
    /**
     * The Vat8TaxableAmount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $Vat8TaxableAmount;
    /**
     * The Vat18TaxableAmount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $Vat18TaxableAmount;
    /**
     * The IsArchived
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $IsArchived;
    /**
     * The InvoiceId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $InvoiceId;
    /**
     * The DocumentId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $DocumentId;
    /**
     * The TargetTcknVkn
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $TargetTcknVkn;
    /**
     * The TargetTitle
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $TargetTitle;
    /**
     * The EnvelopeIdentifier
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $EnvelopeIdentifier;
    /**
     * The Message
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Message;
    /**
     * The DocumentCurrencyCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $DocumentCurrencyCode;
    /**
     * The OrderDocumentId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $OrderDocumentId;

    /**
     * Constructor method for InvoiceListItemBase
     * @param string $type
     * @param int $typeCode
     * @param string $status
     * @param int $statusCode
     * @param string $envelopeStatus
     * @param int $envelopeStatusCode
     * @param string $createDateUtc
     * @param string $executionDate
     * @param float $payableAmount
     * @param float $taxTotal
     * @param float $taxExclusiveAmount
     * @param float $exchangeRate
     * @param float $vat1
     * @param float $vat8
     * @param float $vat18
     * @param float $vat0TaxableAmount
     * @param float $vat1TaxableAmount
     * @param float $vat8TaxableAmount
     * @param float $vat18TaxableAmount
     * @param bool $isArchived
     * @param string $invoiceId
     * @param string $documentId
     * @param string $targetTcknVkn
     * @param string $targetTitle
     * @param string $envelopeIdentifier
     * @param string $message
     * @param string $documentCurrencyCode
     * @param string $orderDocumentId
     * @uses InvoiceListItemBase::setType()
     * @uses InvoiceListItemBase::setTypeCode()
     * @uses InvoiceListItemBase::setStatus()
     * @uses InvoiceListItemBase::setStatusCode()
     * @uses InvoiceListItemBase::setEnvelopeStatus()
     * @uses InvoiceListItemBase::setEnvelopeStatusCode()
     * @uses InvoiceListItemBase::setCreateDateUtc()
     * @uses InvoiceListItemBase::setExecutionDate()
     * @uses InvoiceListItemBase::setPayableAmount()
     * @uses InvoiceListItemBase::setTaxTotal()
     * @uses InvoiceListItemBase::setTaxExclusiveAmount()
     * @uses InvoiceListItemBase::setExchangeRate()
     * @uses InvoiceListItemBase::setVat1()
     * @uses InvoiceListItemBase::setVat8()
     * @uses InvoiceListItemBase::setVat18()
     * @uses InvoiceListItemBase::setVat0TaxableAmount()
     * @uses InvoiceListItemBase::setVat1TaxableAmount()
     * @uses InvoiceListItemBase::setVat8TaxableAmount()
     * @uses InvoiceListItemBase::setVat18TaxableAmount()
     * @uses InvoiceListItemBase::setIsArchived()
     * @uses InvoiceListItemBase::setInvoiceId()
     * @uses InvoiceListItemBase::setDocumentId()
     * @uses InvoiceListItemBase::setTargetTcknVkn()
     * @uses InvoiceListItemBase::setTargetTitle()
     * @uses InvoiceListItemBase::setEnvelopeIdentifier()
     * @uses InvoiceListItemBase::setMessage()
     * @uses InvoiceListItemBase::setDocumentCurrencyCode()
     * @uses InvoiceListItemBase::setOrderDocumentId()
     */
    public function __construct($type = null, $typeCode = null, $status = null, $statusCode = null, $envelopeStatus = null, $envelopeStatusCode = null, $createDateUtc = null, $executionDate = null, $payableAmount = null, $taxTotal = null, $taxExclusiveAmount = null, $exchangeRate = null, $vat1 = null, $vat8 = null, $vat18 = null, $vat0TaxableAmount = null, $vat1TaxableAmount = null, $vat8TaxableAmount = null, $vat18TaxableAmount = null, $isArchived = null, $invoiceId = null, $documentId = null, $targetTcknVkn = null, $targetTitle = null, $envelopeIdentifier = null, $message = null, $documentCurrencyCode = null, $orderDocumentId = null)
    {
        $this
            ->setType($type)
            ->setTypeCode($typeCode)
            ->setStatus($status)
            ->setStatusCode($statusCode)
            ->setEnvelopeStatus($envelopeStatus)
            ->setEnvelopeStatusCode($envelopeStatusCode)
            ->setCreateDateUtc($createDateUtc)
            ->setExecutionDate($executionDate)
            ->setPayableAmount($payableAmount)
            ->setTaxTotal($taxTotal)
            ->setTaxExclusiveAmount($taxExclusiveAmount)
            ->setExchangeRate($exchangeRate)
            ->setVat1($vat1)
            ->setVat8($vat8)
            ->setVat18($vat18)
            ->setVat0TaxableAmount($vat0TaxableAmount)
            ->setVat1TaxableAmount($vat1TaxableAmount)
            ->setVat8TaxableAmount($vat8TaxableAmount)
            ->setVat18TaxableAmount($vat18TaxableAmount)
            ->setIsArchived($isArchived)
            ->setInvoiceId($invoiceId)
            ->setDocumentId($documentId)
            ->setTargetTcknVkn($targetTcknVkn)
            ->setTargetTitle($targetTitle)
            ->setEnvelopeIdentifier($envelopeIdentifier)
            ->setMessage($message)
            ->setDocumentCurrencyCode($documentCurrencyCode)
            ->setOrderDocumentId($orderDocumentId);
    }

    /**
     * Get Type value
     * @return string
     */
    public function getType()
    {
        return $this->Type;
    }

    /**
     * Set Type value
     * @param string $type
     * @return InvoiceListItemBase
     * @throws InvalidArgumentException
     * @uses \Gek\UyumBahceGet\EnumType\InvoiceTypes::getValidValues()
     * @uses \Gek\UyumBahceGet\EnumType\InvoiceTypes::valueIsValid()
     */
    public function setType($type = null)
    {
        // validation for constraint: enumeration
        if (!InvoiceTypes::valueIsValid($type)) {
            throw new InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \Gek\UyumBahceGet\EnumType\InvoiceTypes', is_array($type) ? implode(', ', $type) : var_export($type, true), implode(', ', InvoiceTypes::getValidValues())), __LINE__);
        }
        $this->Type = $type;
        return $this;
    }

    /**
     * Get TypeCode value
     * @return int
     */
    public function getTypeCode()
    {
        return $this->TypeCode;
    }

    /**
     * Set TypeCode value
     * @param int $typeCode
     * @return InvoiceListItemBase
     */
    public function setTypeCode($typeCode = null)
    {
        // validation for constraint: int
        if (!is_null($typeCode) && !(is_int($typeCode) || ctype_digit($typeCode))) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($typeCode, true), gettype($typeCode)), __LINE__);
        }
        $this->TypeCode = $typeCode;
        return $this;
    }

    /**
     * Get Status value
     * @return string
     */
    public function getStatus()
    {
        return $this->Status;
    }

    /**
     * Set Status value
     * @param string $status
     * @return InvoiceListItemBase
     * @throws InvalidArgumentException
     * @uses \Gek\UyumBahceGet\EnumType\InvoiceStatus::getValidValues()
     * @uses \Gek\UyumBahceGet\EnumType\InvoiceStatus::valueIsValid()
     */
    public function setStatus($status = null)
    {
        // validation for constraint: enumeration
        if (!InvoiceStatus::valueIsValid($status)) {
            throw new InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \Gek\UyumBahceGet\EnumType\InvoiceStatus', is_array($status) ? implode(', ', $status) : var_export($status, true), implode(', ', InvoiceStatus::getValidValues())), __LINE__);
        }
        $this->Status = $status;
        return $this;
    }

    /**
     * Get StatusCode value
     * @return int
     */
    public function getStatusCode()
    {
        return $this->StatusCode;
    }

    /**
     * Set StatusCode value
     * @param int $statusCode
     * @return InvoiceListItemBase
     */
    public function setStatusCode($statusCode = null)
    {
        // validation for constraint: int
        if (!is_null($statusCode) && !(is_int($statusCode) || ctype_digit($statusCode))) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($statusCode, true), gettype($statusCode)), __LINE__);
        }
        $this->StatusCode = $statusCode;
        return $this;
    }

    /**
     * Get EnvelopeStatus value
     * @return string
     */
    public function getEnvelopeStatus()
    {
        return $this->EnvelopeStatus;
    }

    /**
     * Set EnvelopeStatus value
     * @param string $envelopeStatus
     * @return InvoiceListItemBase
     * @throws InvalidArgumentException
     * @uses \Gek\UyumBahceGet\EnumType\EnvelopeStatus::getValidValues()
     * @uses \Gek\UyumBahceGet\EnumType\EnvelopeStatus::valueIsValid()
     */
    public function setEnvelopeStatus($envelopeStatus = null)
    {
        // validation for constraint: enumeration
        if (!EnvelopeStatus::valueIsValid($envelopeStatus)) {
            throw new InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \Gek\UyumBahceGet\EnumType\EnvelopeStatus', is_array($envelopeStatus) ? implode(', ', $envelopeStatus) : var_export($envelopeStatus, true), implode(', ', EnvelopeStatus::getValidValues())), __LINE__);
        }
        $this->EnvelopeStatus = $envelopeStatus;
        return $this;
    }

    /**
     * Get EnvelopeStatusCode value
     * @return int
     */
    public function getEnvelopeStatusCode()
    {
        return $this->EnvelopeStatusCode;
    }

    /**
     * Set EnvelopeStatusCode value
     * @param int $envelopeStatusCode
     * @return InvoiceListItemBase
     */
    public function setEnvelopeStatusCode($envelopeStatusCode = null)
    {
        // validation for constraint: int
        if (!is_null($envelopeStatusCode) && !(is_int($envelopeStatusCode) || ctype_digit($envelopeStatusCode))) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($envelopeStatusCode, true), gettype($envelopeStatusCode)), __LINE__);
        }
        $this->EnvelopeStatusCode = $envelopeStatusCode;
        return $this;
    }

    /**
     * Get CreateDateUtc value
     * @return string
     */
    public function getCreateDateUtc()
    {
        return $this->CreateDateUtc;
    }

    /**
     * Set CreateDateUtc value
     * @param string $createDateUtc
     * @return InvoiceListItemBase
     */
    public function setCreateDateUtc($createDateUtc = null)
    {
        // validation for constraint: string
        if (!is_null($createDateUtc) && !is_string($createDateUtc)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($createDateUtc, true), gettype($createDateUtc)), __LINE__);
        }
        $this->CreateDateUtc = $createDateUtc;
        return $this;
    }

    /**
     * Get ExecutionDate value
     * @return string
     */
    public function getExecutionDate()
    {
        return $this->ExecutionDate;
    }

    /**
     * Set ExecutionDate value
     * @param string $executionDate
     * @return InvoiceListItemBase
     */
    public function setExecutionDate($executionDate = null)
    {
        // validation for constraint: string
        if (!is_null($executionDate) && !is_string($executionDate)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($executionDate, true), gettype($executionDate)), __LINE__);
        }
        $this->ExecutionDate = $executionDate;
        return $this;
    }

    /**
     * Get PayableAmount value
     * @return float
     */
    public function getPayableAmount()
    {
        return $this->PayableAmount;
    }

    /**
     * Set PayableAmount value
     * @param float $payableAmount
     * @return InvoiceListItemBase
     */
    public function setPayableAmount($payableAmount = null)
    {
        // validation for constraint: float
        if (!is_null($payableAmount) && !(is_float($payableAmount) || is_numeric($payableAmount))) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($payableAmount, true), gettype($payableAmount)), __LINE__);
        }
        $this->PayableAmount = $payableAmount;
        return $this;
    }

    /**
     * Get TaxTotal value
     * @return float
     */
    public function getTaxTotal()
    {
        return $this->TaxTotal;
    }

    /**
     * Set TaxTotal value
     * @param float $taxTotal
     * @return InvoiceListItemBase
     */
    public function setTaxTotal($taxTotal = null)
    {
        // validation for constraint: float
        if (!is_null($taxTotal) && !(is_float($taxTotal) || is_numeric($taxTotal))) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($taxTotal, true), gettype($taxTotal)), __LINE__);
        }
        $this->TaxTotal = $taxTotal;
        return $this;
    }

    /**
     * Get TaxExclusiveAmount value
     * @return float
     */
    public function getTaxExclusiveAmount()
    {
        return $this->TaxExclusiveAmount;
    }

    /**
     * Set TaxExclusiveAmount value
     * @param float $taxExclusiveAmount
     * @return InvoiceListItemBase
     */
    public function setTaxExclusiveAmount($taxExclusiveAmount = null)
    {
        // validation for constraint: float
        if (!is_null($taxExclusiveAmount) && !(is_float($taxExclusiveAmount) || is_numeric($taxExclusiveAmount))) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($taxExclusiveAmount, true), gettype($taxExclusiveAmount)), __LINE__);
        }
        $this->TaxExclusiveAmount = $taxExclusiveAmount;
        return $this;
    }

    /**
     * Get ExchangeRate value
     * @return float
     */
    public function getExchangeRate()
    {
        return $this->ExchangeRate;
    }

    /**
     * Set ExchangeRate value
     * @param float $exchangeRate
     * @return InvoiceListItemBase
     */
    public function setExchangeRate($exchangeRate = null)
    {
        // validation for constraint: float
        if (!is_null($exchangeRate) && !(is_float($exchangeRate) || is_numeric($exchangeRate))) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($exchangeRate, true), gettype($exchangeRate)), __LINE__);
        }
        $this->ExchangeRate = $exchangeRate;
        return $this;
    }

    /**
     * Get Vat1 value
     * @return float
     */
    public function getVat1()
    {
        return $this->Vat1;
    }

    /**
     * Set Vat1 value
     * @param float $vat1
     * @return InvoiceListItemBase
     */
    public function setVat1($vat1 = null)
    {
        // validation for constraint: float
        if (!is_null($vat1) && !(is_float($vat1) || is_numeric($vat1))) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($vat1, true), gettype($vat1)), __LINE__);
        }
        $this->Vat1 = $vat1;
        return $this;
    }

    /**
     * Get Vat8 value
     * @return float
     */
    public function getVat8()
    {
        return $this->Vat8;
    }

    /**
     * Set Vat8 value
     * @param float $vat8
     * @return InvoiceListItemBase
     */
    public function setVat8($vat8 = null)
    {
        // validation for constraint: float
        if (!is_null($vat8) && !(is_float($vat8) || is_numeric($vat8))) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($vat8, true), gettype($vat8)), __LINE__);
        }
        $this->Vat8 = $vat8;
        return $this;
    }

    /**
     * Get Vat18 value
     * @return float
     */
    public function getVat18()
    {
        return $this->Vat18;
    }

    /**
     * Set Vat18 value
     * @param float $vat18
     * @return InvoiceListItemBase
     */
    public function setVat18($vat18 = null)
    {
        // validation for constraint: float
        if (!is_null($vat18) && !(is_float($vat18) || is_numeric($vat18))) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($vat18, true), gettype($vat18)), __LINE__);
        }
        $this->Vat18 = $vat18;
        return $this;
    }

    /**
     * Get Vat0TaxableAmount value
     * @return float
     */
    public function getVat0TaxableAmount()
    {
        return $this->Vat0TaxableAmount;
    }

    /**
     * Set Vat0TaxableAmount value
     * @param float $vat0TaxableAmount
     * @return InvoiceListItemBase
     */
    public function setVat0TaxableAmount($vat0TaxableAmount = null)
    {
        // validation for constraint: float
        if (!is_null($vat0TaxableAmount) && !(is_float($vat0TaxableAmount) || is_numeric($vat0TaxableAmount))) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($vat0TaxableAmount, true), gettype($vat0TaxableAmount)), __LINE__);
        }
        $this->Vat0TaxableAmount = $vat0TaxableAmount;
        return $this;
    }

    /**
     * Get Vat1TaxableAmount value
     * @return float
     */
    public function getVat1TaxableAmount()
    {
        return $this->Vat1TaxableAmount;
    }

    /**
     * Set Vat1TaxableAmount value
     * @param float $vat1TaxableAmount
     * @return InvoiceListItemBase
     */
    public function setVat1TaxableAmount($vat1TaxableAmount = null)
    {
        // validation for constraint: float
        if (!is_null($vat1TaxableAmount) && !(is_float($vat1TaxableAmount) || is_numeric($vat1TaxableAmount))) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($vat1TaxableAmount, true), gettype($vat1TaxableAmount)), __LINE__);
        }
        $this->Vat1TaxableAmount = $vat1TaxableAmount;
        return $this;
    }

    /**
     * Get Vat8TaxableAmount value
     * @return float
     */
    public function getVat8TaxableAmount()
    {
        return $this->Vat8TaxableAmount;
    }

    /**
     * Set Vat8TaxableAmount value
     * @param float $vat8TaxableAmount
     * @return InvoiceListItemBase
     */
    public function setVat8TaxableAmount($vat8TaxableAmount = null)
    {
        // validation for constraint: float
        if (!is_null($vat8TaxableAmount) && !(is_float($vat8TaxableAmount) || is_numeric($vat8TaxableAmount))) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($vat8TaxableAmount, true), gettype($vat8TaxableAmount)), __LINE__);
        }
        $this->Vat8TaxableAmount = $vat8TaxableAmount;
        return $this;
    }

    /**
     * Get Vat18TaxableAmount value
     * @return float
     */
    public function getVat18TaxableAmount()
    {
        return $this->Vat18TaxableAmount;
    }

    /**
     * Set Vat18TaxableAmount value
     * @param float $vat18TaxableAmount
     * @return InvoiceListItemBase
     */
    public function setVat18TaxableAmount($vat18TaxableAmount = null)
    {
        // validation for constraint: float
        if (!is_null($vat18TaxableAmount) && !(is_float($vat18TaxableAmount) || is_numeric($vat18TaxableAmount))) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($vat18TaxableAmount, true), gettype($vat18TaxableAmount)), __LINE__);
        }
        $this->Vat18TaxableAmount = $vat18TaxableAmount;
        return $this;
    }

    /**
     * Get IsArchived value
     * @return bool
     */
    public function getIsArchived()
    {
        return $this->IsArchived;
    }

    /**
     * Set IsArchived value
     * @param bool $isArchived
     * @return InvoiceListItemBase
     */
    public function setIsArchived($isArchived = null)
    {
        // validation for constraint: boolean
        if (!is_null($isArchived) && !is_bool($isArchived)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isArchived, true), gettype($isArchived)), __LINE__);
        }
        $this->IsArchived = $isArchived;
        return $this;
    }

    /**
     * Get InvoiceId value
     * @return string|null
     */
    public function getInvoiceId()
    {
        return $this->InvoiceId;
    }

    /**
     * Set InvoiceId value
     * @param string $invoiceId
     * @return InvoiceListItemBase
     */
    public function setInvoiceId($invoiceId = null)
    {
        // validation for constraint: string
        if (!is_null($invoiceId) && !is_string($invoiceId)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($invoiceId, true), gettype($invoiceId)), __LINE__);
        }
        $this->InvoiceId = $invoiceId;
        return $this;
    }

    /**
     * Get DocumentId value
     * @return string|null
     */
    public function getDocumentId()
    {
        return $this->DocumentId;
    }

    /**
     * Set DocumentId value
     * @param string $documentId
     * @return InvoiceListItemBase
     */
    public function setDocumentId($documentId = null)
    {
        // validation for constraint: string
        if (!is_null($documentId) && !is_string($documentId)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($documentId, true), gettype($documentId)), __LINE__);
        }
        $this->DocumentId = $documentId;
        return $this;
    }

    /**
     * Get TargetTcknVkn value
     * @return string|null
     */
    public function getTargetTcknVkn()
    {
        return $this->TargetTcknVkn;
    }

    /**
     * Set TargetTcknVkn value
     * @param string $targetTcknVkn
     * @return InvoiceListItemBase
     */
    public function setTargetTcknVkn($targetTcknVkn = null)
    {
        // validation for constraint: string
        if (!is_null($targetTcknVkn) && !is_string($targetTcknVkn)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($targetTcknVkn, true), gettype($targetTcknVkn)), __LINE__);
        }
        $this->TargetTcknVkn = $targetTcknVkn;
        return $this;
    }

    /**
     * Get TargetTitle value
     * @return string|null
     */
    public function getTargetTitle()
    {
        return $this->TargetTitle;
    }

    /**
     * Set TargetTitle value
     * @param string $targetTitle
     * @return InvoiceListItemBase
     */
    public function setTargetTitle($targetTitle = null)
    {
        // validation for constraint: string
        if (!is_null($targetTitle) && !is_string($targetTitle)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($targetTitle, true), gettype($targetTitle)), __LINE__);
        }
        $this->TargetTitle = $targetTitle;
        return $this;
    }

    /**
     * Get EnvelopeIdentifier value
     * @return string|null
     */
    public function getEnvelopeIdentifier()
    {
        return $this->EnvelopeIdentifier;
    }

    /**
     * Set EnvelopeIdentifier value
     * @param string $envelopeIdentifier
     * @return InvoiceListItemBase
     */
    public function setEnvelopeIdentifier($envelopeIdentifier = null)
    {
        // validation for constraint: string
        if (!is_null($envelopeIdentifier) && !is_string($envelopeIdentifier)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($envelopeIdentifier, true), gettype($envelopeIdentifier)), __LINE__);
        }
        $this->EnvelopeIdentifier = $envelopeIdentifier;
        return $this;
    }

    /**
     * Get Message value
     * @return string|null
     */
    public function getMessage()
    {
        return $this->Message;
    }

    /**
     * Set Message value
     * @param string $message
     * @return InvoiceListItemBase
     */
    public function setMessage($message = null)
    {
        // validation for constraint: string
        if (!is_null($message) && !is_string($message)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($message, true), gettype($message)), __LINE__);
        }
        $this->Message = $message;
        return $this;
    }

    /**
     * Get DocumentCurrencyCode value
     * @return string|null
     */
    public function getDocumentCurrencyCode()
    {
        return $this->DocumentCurrencyCode;
    }

    /**
     * Set DocumentCurrencyCode value
     * @param string $documentCurrencyCode
     * @return InvoiceListItemBase
     */
    public function setDocumentCurrencyCode($documentCurrencyCode = null)
    {
        // validation for constraint: string
        if (!is_null($documentCurrencyCode) && !is_string($documentCurrencyCode)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($documentCurrencyCode, true), gettype($documentCurrencyCode)), __LINE__);
        }
        $this->DocumentCurrencyCode = $documentCurrencyCode;
        return $this;
    }

    /**
     * Get OrderDocumentId value
     * @return string|null
     */
    public function getOrderDocumentId()
    {
        return $this->OrderDocumentId;
    }

    /**
     * Set OrderDocumentId value
     * @param string $orderDocumentId
     * @return InvoiceListItemBase
     */
    public function setOrderDocumentId($orderDocumentId = null)
    {
        // validation for constraint: string
        if (!is_null($orderDocumentId) && !is_string($orderDocumentId)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($orderDocumentId, true), gettype($orderDocumentId)), __LINE__);
        }
        $this->OrderDocumentId = $orderDocumentId;
        return $this;
    }
}
