<?php

namespace Gek\UyumBahceGet\StructType;

use InvalidArgumentException;
use WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for InvoiceLineType StructType
 * @subpackage Structs
 */
class InvoiceLineType extends AbstractStructBase
{
    /**
     * The ID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: s4:ID
     * @var IDType
     */
    public $ID;
    /**
     * The Note
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - ref: s4:Note
     * @var NoteType[]
     */
    public $Note;
    /**
     * The InvoicedQuantity
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: s4:InvoicedQuantity
     * @var InvoicedQuantityType
     */
    public $InvoicedQuantity;
    /**
     * The LineExtensionAmount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: s4:LineExtensionAmount
     * @var LineExtensionAmountType
     */
    public $LineExtensionAmount;
    /**
     * The OrderLineReference
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var OrderLineReferenceType[]
     */
    public $OrderLineReference;
    /**
     * The DespatchLineReference
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var LineReferenceType[]
     */
    public $DespatchLineReference;
    /**
     * The ReceiptLineReference
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var LineReferenceType[]
     */
    public $ReceiptLineReference;
    /**
     * The Delivery
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var DeliveryType[]
     */
    public $Delivery;
    /**
     * The AllowanceCharge
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var AllowanceChargeType[]
     */
    public $AllowanceCharge;
    /**
     * The TaxTotal
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var TaxTotalType
     */
    public $TaxTotal;
    /**
     * The WithholdingTaxTotal
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var TaxTotalType[]
     */
    public $WithholdingTaxTotal;
    /**
     * The Item
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var ItemType
     */
    public $Item;
    /**
     * The Price
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var PriceType
     */
    public $Price;
    /**
     * The SubInvoiceLine
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var InvoiceLineType[]
     */
    public $SubInvoiceLine;

    /**
     * Constructor method for InvoiceLineType
     * @param IDType $iD
     * @param NoteType[] $note
     * @param InvoicedQuantityType $invoicedQuantity
     * @param LineExtensionAmountType $lineExtensionAmount
     * @param OrderLineReferenceType[] $orderLineReference
     * @param LineReferenceType[] $despatchLineReference
     * @param LineReferenceType[] $receiptLineReference
     * @param DeliveryType[] $delivery
     * @param AllowanceChargeType[] $allowanceCharge
     * @param TaxTotalType $taxTotal
     * @param TaxTotalType[] $withholdingTaxTotal
     * @param ItemType $item
     * @param PriceType $price
     * @param InvoiceLineType[] $subInvoiceLine
     * @uses InvoiceLineType::setID()
     * @uses InvoiceLineType::setNote()
     * @uses InvoiceLineType::setInvoicedQuantity()
     * @uses InvoiceLineType::setLineExtensionAmount()
     * @uses InvoiceLineType::setOrderLineReference()
     * @uses InvoiceLineType::setDespatchLineReference()
     * @uses InvoiceLineType::setReceiptLineReference()
     * @uses InvoiceLineType::setDelivery()
     * @uses InvoiceLineType::setAllowanceCharge()
     * @uses InvoiceLineType::setTaxTotal()
     * @uses InvoiceLineType::setWithholdingTaxTotal()
     * @uses InvoiceLineType::setItem()
     * @uses InvoiceLineType::setPrice()
     * @uses InvoiceLineType::setSubInvoiceLine()
     */
    public function __construct(IDType $iD = null, array $note = array(), InvoicedQuantityType $invoicedQuantity = null, LineExtensionAmountType $lineExtensionAmount = null, array $orderLineReference = array(), array $despatchLineReference = array(), array $receiptLineReference = array(), array $delivery = array(), array $allowanceCharge = array(), TaxTotalType $taxTotal = null, array $withholdingTaxTotal = array(), ItemType $item = null, PriceType $price = null, array $subInvoiceLine = array())
    {
        $this
            ->setID($iD)
            ->setNote($note)
            ->setInvoicedQuantity($invoicedQuantity)
            ->setLineExtensionAmount($lineExtensionAmount)
            ->setOrderLineReference($orderLineReference)
            ->setDespatchLineReference($despatchLineReference)
            ->setReceiptLineReference($receiptLineReference)
            ->setDelivery($delivery)
            ->setAllowanceCharge($allowanceCharge)
            ->setTaxTotal($taxTotal)
            ->setWithholdingTaxTotal($withholdingTaxTotal)
            ->setItem($item)
            ->setPrice($price)
            ->setSubInvoiceLine($subInvoiceLine);
    }

    /**
     * Get ID value
     * @return IDType|null
     */
    public function getID()
    {
        return $this->ID;
    }

    /**
     * Set ID value
     * @param IDType $iD
     * @return InvoiceLineType
     */
    public function setID(IDType $iD = null)
    {
        $this->ID = $iD;
        return $this;
    }

    /**
     * Get Note value
     * @return NoteType[]|null
     */
    public function getNote()
    {
        return $this->Note;
    }

    /**
     * This method is responsible for validating the values passed to the setNote method
     * This method is willingly generated in order to preserve the one-line inline validation within the setNote method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateNoteForArrayConstraintsFromSetNote(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $invoiceLineTypeNoteItem) {
            // validation for constraint: itemType
            if (!$invoiceLineTypeNoteItem instanceof NoteType) {
                $invalidValues[] = is_object($invoiceLineTypeNoteItem) ? get_class($invoiceLineTypeNoteItem) : sprintf('%s(%s)', gettype($invoiceLineTypeNoteItem), var_export($invoiceLineTypeNoteItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Note property can only contain items of type \Gek\UyumBahceGet\StructType\NoteType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }

    /**
     * Set Note value
     * @param NoteType[] $note
     * @return InvoiceLineType
     * @throws InvalidArgumentException
     */
    public function setNote(array $note = array())
    {
        // validation for constraint: array
        if ('' !== ($noteArrayErrorMessage = self::validateNoteForArrayConstraintsFromSetNote($note))) {
            throw new InvalidArgumentException($noteArrayErrorMessage, __LINE__);
        }
        $this->Note = $note;
        return $this;
    }

    /**
     * Add item to Note value
     * @param NoteType $item
     * @return InvoiceLineType
     * @throws InvalidArgumentException
     */
    public function addToNote(NoteType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof NoteType) {
            throw new InvalidArgumentException(sprintf('The Note property can only contain items of type \Gek\UyumBahceGet\StructType\NoteType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Note[] = $item;
        return $this;
    }

    /**
     * Get InvoicedQuantity value
     * @return InvoicedQuantityType|null
     */
    public function getInvoicedQuantity()
    {
        return $this->InvoicedQuantity;
    }

    /**
     * Set InvoicedQuantity value
     * @param InvoicedQuantityType $invoicedQuantity
     * @return InvoiceLineType
     */
    public function setInvoicedQuantity(InvoicedQuantityType $invoicedQuantity = null)
    {
        $this->InvoicedQuantity = $invoicedQuantity;
        return $this;
    }

    /**
     * Get LineExtensionAmount value
     * @return LineExtensionAmountType|null
     */
    public function getLineExtensionAmount()
    {
        return $this->LineExtensionAmount;
    }

    /**
     * Set LineExtensionAmount value
     * @param LineExtensionAmountType $lineExtensionAmount
     * @return InvoiceLineType
     */
    public function setLineExtensionAmount(LineExtensionAmountType $lineExtensionAmount = null)
    {
        $this->LineExtensionAmount = $lineExtensionAmount;
        return $this;
    }

    /**
     * Get OrderLineReference value
     * @return OrderLineReferenceType[]|null
     */
    public function getOrderLineReference()
    {
        return $this->OrderLineReference;
    }

    /**
     * This method is responsible for validating the values passed to the setOrderLineReference method
     * This method is willingly generated in order to preserve the one-line inline validation within the setOrderLineReference method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateOrderLineReferenceForArrayConstraintsFromSetOrderLineReference(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $invoiceLineTypeOrderLineReferenceItem) {
            // validation for constraint: itemType
            if (!$invoiceLineTypeOrderLineReferenceItem instanceof OrderLineReferenceType) {
                $invalidValues[] = is_object($invoiceLineTypeOrderLineReferenceItem) ? get_class($invoiceLineTypeOrderLineReferenceItem) : sprintf('%s(%s)', gettype($invoiceLineTypeOrderLineReferenceItem), var_export($invoiceLineTypeOrderLineReferenceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The OrderLineReference property can only contain items of type \Gek\UyumBahceGet\StructType\OrderLineReferenceType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }

    /**
     * Set OrderLineReference value
     * @param OrderLineReferenceType[] $orderLineReference
     * @return InvoiceLineType
     * @throws InvalidArgumentException
     */
    public function setOrderLineReference(array $orderLineReference = array())
    {
        // validation for constraint: array
        if ('' !== ($orderLineReferenceArrayErrorMessage = self::validateOrderLineReferenceForArrayConstraintsFromSetOrderLineReference($orderLineReference))) {
            throw new InvalidArgumentException($orderLineReferenceArrayErrorMessage, __LINE__);
        }
        $this->OrderLineReference = $orderLineReference;
        return $this;
    }

    /**
     * Add item to OrderLineReference value
     * @param OrderLineReferenceType $item
     * @return InvoiceLineType
     * @throws InvalidArgumentException
     */
    public function addToOrderLineReference(OrderLineReferenceType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof OrderLineReferenceType) {
            throw new InvalidArgumentException(sprintf('The OrderLineReference property can only contain items of type \Gek\UyumBahceGet\StructType\OrderLineReferenceType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->OrderLineReference[] = $item;
        return $this;
    }

    /**
     * Get DespatchLineReference value
     * @return LineReferenceType[]|null
     */
    public function getDespatchLineReference()
    {
        return $this->DespatchLineReference;
    }

    /**
     * This method is responsible for validating the values passed to the setDespatchLineReference method
     * This method is willingly generated in order to preserve the one-line inline validation within the setDespatchLineReference method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateDespatchLineReferenceForArrayConstraintsFromSetDespatchLineReference(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $invoiceLineTypeDespatchLineReferenceItem) {
            // validation for constraint: itemType
            if (!$invoiceLineTypeDespatchLineReferenceItem instanceof LineReferenceType) {
                $invalidValues[] = is_object($invoiceLineTypeDespatchLineReferenceItem) ? get_class($invoiceLineTypeDespatchLineReferenceItem) : sprintf('%s(%s)', gettype($invoiceLineTypeDespatchLineReferenceItem), var_export($invoiceLineTypeDespatchLineReferenceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The DespatchLineReference property can only contain items of type \Gek\UyumBahceGet\StructType\LineReferenceType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }

    /**
     * Set DespatchLineReference value
     * @param LineReferenceType[] $despatchLineReference
     * @return InvoiceLineType
     * @throws InvalidArgumentException
     */
    public function setDespatchLineReference(array $despatchLineReference = array())
    {
        // validation for constraint: array
        if ('' !== ($despatchLineReferenceArrayErrorMessage = self::validateDespatchLineReferenceForArrayConstraintsFromSetDespatchLineReference($despatchLineReference))) {
            throw new InvalidArgumentException($despatchLineReferenceArrayErrorMessage, __LINE__);
        }
        $this->DespatchLineReference = $despatchLineReference;
        return $this;
    }

    /**
     * Add item to DespatchLineReference value
     * @param LineReferenceType $item
     * @return InvoiceLineType
     * @throws InvalidArgumentException
     */
    public function addToDespatchLineReference(LineReferenceType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof LineReferenceType) {
            throw new InvalidArgumentException(sprintf('The DespatchLineReference property can only contain items of type \Gek\UyumBahceGet\StructType\LineReferenceType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->DespatchLineReference[] = $item;
        return $this;
    }

    /**
     * Get ReceiptLineReference value
     * @return LineReferenceType[]|null
     */
    public function getReceiptLineReference()
    {
        return $this->ReceiptLineReference;
    }

    /**
     * This method is responsible for validating the values passed to the setReceiptLineReference method
     * This method is willingly generated in order to preserve the one-line inline validation within the setReceiptLineReference method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateReceiptLineReferenceForArrayConstraintsFromSetReceiptLineReference(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $invoiceLineTypeReceiptLineReferenceItem) {
            // validation for constraint: itemType
            if (!$invoiceLineTypeReceiptLineReferenceItem instanceof LineReferenceType) {
                $invalidValues[] = is_object($invoiceLineTypeReceiptLineReferenceItem) ? get_class($invoiceLineTypeReceiptLineReferenceItem) : sprintf('%s(%s)', gettype($invoiceLineTypeReceiptLineReferenceItem), var_export($invoiceLineTypeReceiptLineReferenceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The ReceiptLineReference property can only contain items of type \Gek\UyumBahceGet\StructType\LineReferenceType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }

    /**
     * Set ReceiptLineReference value
     * @param LineReferenceType[] $receiptLineReference
     * @return InvoiceLineType
     * @throws InvalidArgumentException
     */
    public function setReceiptLineReference(array $receiptLineReference = array())
    {
        // validation for constraint: array
        if ('' !== ($receiptLineReferenceArrayErrorMessage = self::validateReceiptLineReferenceForArrayConstraintsFromSetReceiptLineReference($receiptLineReference))) {
            throw new InvalidArgumentException($receiptLineReferenceArrayErrorMessage, __LINE__);
        }
        $this->ReceiptLineReference = $receiptLineReference;
        return $this;
    }

    /**
     * Add item to ReceiptLineReference value
     * @param LineReferenceType $item
     * @return InvoiceLineType
     * @throws InvalidArgumentException
     */
    public function addToReceiptLineReference(LineReferenceType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof LineReferenceType) {
            throw new InvalidArgumentException(sprintf('The ReceiptLineReference property can only contain items of type \Gek\UyumBahceGet\StructType\LineReferenceType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->ReceiptLineReference[] = $item;
        return $this;
    }

    /**
     * Get Delivery value
     * @return DeliveryType[]|null
     */
    public function getDelivery()
    {
        return $this->Delivery;
    }

    /**
     * This method is responsible for validating the values passed to the setDelivery method
     * This method is willingly generated in order to preserve the one-line inline validation within the setDelivery method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateDeliveryForArrayConstraintsFromSetDelivery(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $invoiceLineTypeDeliveryItem) {
            // validation for constraint: itemType
            if (!$invoiceLineTypeDeliveryItem instanceof DeliveryType) {
                $invalidValues[] = is_object($invoiceLineTypeDeliveryItem) ? get_class($invoiceLineTypeDeliveryItem) : sprintf('%s(%s)', gettype($invoiceLineTypeDeliveryItem), var_export($invoiceLineTypeDeliveryItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Delivery property can only contain items of type \Gek\UyumBahceGet\StructType\DeliveryType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }

    /**
     * Set Delivery value
     * @param DeliveryType[] $delivery
     * @return InvoiceLineType
     * @throws InvalidArgumentException
     */
    public function setDelivery(array $delivery = array())
    {
        // validation for constraint: array
        if ('' !== ($deliveryArrayErrorMessage = self::validateDeliveryForArrayConstraintsFromSetDelivery($delivery))) {
            throw new InvalidArgumentException($deliveryArrayErrorMessage, __LINE__);
        }
        $this->Delivery = $delivery;
        return $this;
    }

    /**
     * Add item to Delivery value
     * @param DeliveryType $item
     * @return InvoiceLineType
     * @throws InvalidArgumentException
     */
    public function addToDelivery(DeliveryType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof DeliveryType) {
            throw new InvalidArgumentException(sprintf('The Delivery property can only contain items of type \Gek\UyumBahceGet\StructType\DeliveryType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Delivery[] = $item;
        return $this;
    }

    /**
     * Get AllowanceCharge value
     * @return AllowanceChargeType[]|null
     */
    public function getAllowanceCharge()
    {
        return $this->AllowanceCharge;
    }

    /**
     * This method is responsible for validating the values passed to the setAllowanceCharge method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAllowanceCharge method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateAllowanceChargeForArrayConstraintsFromSetAllowanceCharge(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $invoiceLineTypeAllowanceChargeItem) {
            // validation for constraint: itemType
            if (!$invoiceLineTypeAllowanceChargeItem instanceof AllowanceChargeType) {
                $invalidValues[] = is_object($invoiceLineTypeAllowanceChargeItem) ? get_class($invoiceLineTypeAllowanceChargeItem) : sprintf('%s(%s)', gettype($invoiceLineTypeAllowanceChargeItem), var_export($invoiceLineTypeAllowanceChargeItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The AllowanceCharge property can only contain items of type \Gek\UyumBahceGet\StructType\AllowanceChargeType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }

    /**
     * Set AllowanceCharge value
     * @param AllowanceChargeType[] $allowanceCharge
     * @return InvoiceLineType
     * @throws InvalidArgumentException
     */
    public function setAllowanceCharge(array $allowanceCharge = array())
    {
        // validation for constraint: array
        if ('' !== ($allowanceChargeArrayErrorMessage = self::validateAllowanceChargeForArrayConstraintsFromSetAllowanceCharge($allowanceCharge))) {
            throw new InvalidArgumentException($allowanceChargeArrayErrorMessage, __LINE__);
        }
        $this->AllowanceCharge = $allowanceCharge;
        return $this;
    }

    /**
     * Add item to AllowanceCharge value
     * @param AllowanceChargeType $item
     * @return InvoiceLineType
     * @throws InvalidArgumentException
     */
    public function addToAllowanceCharge(AllowanceChargeType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof AllowanceChargeType) {
            throw new InvalidArgumentException(sprintf('The AllowanceCharge property can only contain items of type \Gek\UyumBahceGet\StructType\AllowanceChargeType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->AllowanceCharge[] = $item;
        return $this;
    }

    /**
     * Get TaxTotal value
     * @return TaxTotalType|null
     */
    public function getTaxTotal()
    {
        return $this->TaxTotal;
    }

    /**
     * Set TaxTotal value
     * @param TaxTotalType $taxTotal
     * @return InvoiceLineType
     */
    public function setTaxTotal(TaxTotalType $taxTotal = null)
    {
        $this->TaxTotal = $taxTotal;
        return $this;
    }

    /**
     * Get WithholdingTaxTotal value
     * @return TaxTotalType[]|null
     */
    public function getWithholdingTaxTotal()
    {
        return $this->WithholdingTaxTotal;
    }

    /**
     * This method is responsible for validating the values passed to the setWithholdingTaxTotal method
     * This method is willingly generated in order to preserve the one-line inline validation within the setWithholdingTaxTotal method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateWithholdingTaxTotalForArrayConstraintsFromSetWithholdingTaxTotal(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $invoiceLineTypeWithholdingTaxTotalItem) {
            // validation for constraint: itemType
            if (!$invoiceLineTypeWithholdingTaxTotalItem instanceof TaxTotalType) {
                $invalidValues[] = is_object($invoiceLineTypeWithholdingTaxTotalItem) ? get_class($invoiceLineTypeWithholdingTaxTotalItem) : sprintf('%s(%s)', gettype($invoiceLineTypeWithholdingTaxTotalItem), var_export($invoiceLineTypeWithholdingTaxTotalItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The WithholdingTaxTotal property can only contain items of type \Gek\UyumBahceGet\StructType\TaxTotalType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }

    /**
     * Set WithholdingTaxTotal value
     * @param TaxTotalType[] $withholdingTaxTotal
     * @return InvoiceLineType
     * @throws InvalidArgumentException
     */
    public function setWithholdingTaxTotal(array $withholdingTaxTotal = array())
    {
        // validation for constraint: array
        if ('' !== ($withholdingTaxTotalArrayErrorMessage = self::validateWithholdingTaxTotalForArrayConstraintsFromSetWithholdingTaxTotal($withholdingTaxTotal))) {
            throw new InvalidArgumentException($withholdingTaxTotalArrayErrorMessage, __LINE__);
        }
        $this->WithholdingTaxTotal = $withholdingTaxTotal;
        return $this;
    }

    /**
     * Add item to WithholdingTaxTotal value
     * @param TaxTotalType $item
     * @return InvoiceLineType
     * @throws InvalidArgumentException
     */
    public function addToWithholdingTaxTotal(TaxTotalType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof TaxTotalType) {
            throw new InvalidArgumentException(sprintf('The WithholdingTaxTotal property can only contain items of type \Gek\UyumBahceGet\StructType\TaxTotalType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->WithholdingTaxTotal[] = $item;
        return $this;
    }

    /**
     * Get Item value
     * @return ItemType|null
     */
    public function getItem()
    {
        return $this->Item;
    }

    /**
     * Set Item value
     * @param ItemType $item
     * @return InvoiceLineType
     */
    public function setItem(ItemType $item = null)
    {
        $this->Item = $item;
        return $this;
    }

    /**
     * Get Price value
     * @return PriceType|null
     */
    public function getPrice()
    {
        return $this->Price;
    }

    /**
     * Set Price value
     * @param PriceType $price
     * @return InvoiceLineType
     */
    public function setPrice(PriceType $price = null)
    {
        $this->Price = $price;
        return $this;
    }

    /**
     * Get SubInvoiceLine value
     * @return InvoiceLineType[]|null
     */
    public function getSubInvoiceLine()
    {
        return $this->SubInvoiceLine;
    }

    /**
     * This method is responsible for validating the values passed to the setSubInvoiceLine method
     * This method is willingly generated in order to preserve the one-line inline validation within the setSubInvoiceLine method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateSubInvoiceLineForArrayConstraintsFromSetSubInvoiceLine(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $invoiceLineTypeSubInvoiceLineItem) {
            // validation for constraint: itemType
            if (!$invoiceLineTypeSubInvoiceLineItem instanceof InvoiceLineType) {
                $invalidValues[] = is_object($invoiceLineTypeSubInvoiceLineItem) ? get_class($invoiceLineTypeSubInvoiceLineItem) : sprintf('%s(%s)', gettype($invoiceLineTypeSubInvoiceLineItem), var_export($invoiceLineTypeSubInvoiceLineItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The SubInvoiceLine property can only contain items of type \Gek\UyumBahceGet\StructType\InvoiceLineType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }

    /**
     * Set SubInvoiceLine value
     * @param InvoiceLineType[] $subInvoiceLine
     * @return InvoiceLineType
     * @throws InvalidArgumentException
     */
    public function setSubInvoiceLine(array $subInvoiceLine = array())
    {
        // validation for constraint: array
        if ('' !== ($subInvoiceLineArrayErrorMessage = self::validateSubInvoiceLineForArrayConstraintsFromSetSubInvoiceLine($subInvoiceLine))) {
            throw new InvalidArgumentException($subInvoiceLineArrayErrorMessage, __LINE__);
        }
        $this->SubInvoiceLine = $subInvoiceLine;
        return $this;
    }

    /**
     * Add item to SubInvoiceLine value
     * @param InvoiceLineType $item
     * @return InvoiceLineType
     * @throws InvalidArgumentException
     */
    public function addToSubInvoiceLine(InvoiceLineType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof InvoiceLineType) {
            throw new InvalidArgumentException(sprintf('The SubInvoiceLine property can only contain items of type \Gek\UyumBahceGet\StructType\InvoiceLineType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->SubInvoiceLine[] = $item;
        return $this;
    }
}
