<?php

namespace Gek\UyumBahceGet\StructType;

use InvalidArgumentException;
use WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for InvoiceData StructType
 * @subpackage Structs
 */
class InvoiceData extends AbstractStructBase
{
    /**
     * The Data
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Data;
    /**
     * The InvoiceId
     * @var string
     */
    public $InvoiceId;
    /**
     * The ExtraInformation
     * @var string
     */
    public $ExtraInformation;
    /**
     * The LocalDocumentId
     * @var string
     */
    public $LocalDocumentId;

    /**
     * Constructor method for InvoiceData
     * @param string $data
     * @param string $invoiceId
     * @param string $extraInformation
     * @param string $localDocumentId
     * @uses InvoiceData::setData()
     * @uses InvoiceData::setInvoiceId()
     * @uses InvoiceData::setExtraInformation()
     * @uses InvoiceData::setLocalDocumentId()
     */
    public function __construct($data = null, $invoiceId = null, $extraInformation = null, $localDocumentId = null)
    {
        $this
            ->setData($data)
            ->setInvoiceId($invoiceId)
            ->setExtraInformation($extraInformation)
            ->setLocalDocumentId($localDocumentId);
    }

    /**
     * Get Data value
     * @return string|null
     */
    public function getData()
    {
        return $this->Data;
    }

    /**
     * Set Data value
     * @param string $data
     * @return InvoiceData
     */
    public function setData($data = null)
    {
        // validation for constraint: string
        if (!is_null($data) && !is_string($data)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($data, true), gettype($data)), __LINE__);
        }
        $this->Data = $data;
        return $this;
    }

    /**
     * Get InvoiceId value
     * @return string|null
     */
    public function getInvoiceId()
    {
        return $this->InvoiceId;
    }

    /**
     * Set InvoiceId value
     * @param string $invoiceId
     * @return InvoiceData
     */
    public function setInvoiceId($invoiceId = null)
    {
        // validation for constraint: string
        if (!is_null($invoiceId) && !is_string($invoiceId)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($invoiceId, true), gettype($invoiceId)), __LINE__);
        }
        $this->InvoiceId = $invoiceId;
        return $this;
    }

    /**
     * Get ExtraInformation value
     * @return string|null
     */
    public function getExtraInformation()
    {
        return $this->ExtraInformation;
    }

    /**
     * Set ExtraInformation value
     * @param string $extraInformation
     * @return InvoiceData
     */
    public function setExtraInformation($extraInformation = null)
    {
        // validation for constraint: string
        if (!is_null($extraInformation) && !is_string($extraInformation)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($extraInformation, true), gettype($extraInformation)), __LINE__);
        }
        $this->ExtraInformation = $extraInformation;
        return $this;
    }

    /**
     * Get LocalDocumentId value
     * @return string|null
     */
    public function getLocalDocumentId()
    {
        return $this->LocalDocumentId;
    }

    /**
     * Set LocalDocumentId value
     * @param string $localDocumentId
     * @return InvoiceData
     */
    public function setLocalDocumentId($localDocumentId = null)
    {
        // validation for constraint: string
        if (!is_null($localDocumentId) && !is_string($localDocumentId)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($localDocumentId, true), gettype($localDocumentId)), __LINE__);
        }
        $this->LocalDocumentId = $localDocumentId;
        return $this;
    }
}
