<?php

namespace Gek\UyumBahceGet\StructType;

use WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for HazardousGoodsTransitType StructType
 * @subpackage Structs
 */
class HazardousGoodsTransitType extends AbstractStructBase
{
    /**
     * The TransportEmergencyCardCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: s4:TransportEmergencyCardCode
     * @var TransportEmergencyCardCodeType
     */
    public $TransportEmergencyCardCode;
    /**
     * The PackingCriteriaCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: s4:PackingCriteriaCode
     * @var PackingCriteriaCodeType
     */
    public $PackingCriteriaCode;
    /**
     * The HazardousRegulationCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: s4:HazardousRegulationCode
     * @var HazardousRegulationCodeType
     */
    public $HazardousRegulationCode;
    /**
     * The InhalationToxicityZoneCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: s4:InhalationToxicityZoneCode
     * @var InhalationToxicityZoneCodeType
     */
    public $InhalationToxicityZoneCode;
    /**
     * The TransportAuthorizationCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: s4:TransportAuthorizationCode
     * @var TransportAuthorizationCodeType
     */
    public $TransportAuthorizationCode;
    /**
     * The MaximumTemperature
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var TemperatureType
     */
    public $MaximumTemperature;
    /**
     * The MinimumTemperature
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var TemperatureType
     */
    public $MinimumTemperature;

    /**
     * Constructor method for HazardousGoodsTransitType
     * @param TransportEmergencyCardCodeType $transportEmergencyCardCode
     * @param PackingCriteriaCodeType $packingCriteriaCode
     * @param HazardousRegulationCodeType $hazardousRegulationCode
     * @param InhalationToxicityZoneCodeType $inhalationToxicityZoneCode
     * @param TransportAuthorizationCodeType $transportAuthorizationCode
     * @param TemperatureType $maximumTemperature
     * @param TemperatureType $minimumTemperature
     * @uses HazardousGoodsTransitType::setTransportEmergencyCardCode()
     * @uses HazardousGoodsTransitType::setPackingCriteriaCode()
     * @uses HazardousGoodsTransitType::setHazardousRegulationCode()
     * @uses HazardousGoodsTransitType::setInhalationToxicityZoneCode()
     * @uses HazardousGoodsTransitType::setTransportAuthorizationCode()
     * @uses HazardousGoodsTransitType::setMaximumTemperature()
     * @uses HazardousGoodsTransitType::setMinimumTemperature()
     */
    public function __construct(TransportEmergencyCardCodeType $transportEmergencyCardCode = null, PackingCriteriaCodeType $packingCriteriaCode = null, HazardousRegulationCodeType $hazardousRegulationCode = null, InhalationToxicityZoneCodeType $inhalationToxicityZoneCode = null, TransportAuthorizationCodeType $transportAuthorizationCode = null, TemperatureType $maximumTemperature = null, TemperatureType $minimumTemperature = null)
    {
        $this
            ->setTransportEmergencyCardCode($transportEmergencyCardCode)
            ->setPackingCriteriaCode($packingCriteriaCode)
            ->setHazardousRegulationCode($hazardousRegulationCode)
            ->setInhalationToxicityZoneCode($inhalationToxicityZoneCode)
            ->setTransportAuthorizationCode($transportAuthorizationCode)
            ->setMaximumTemperature($maximumTemperature)
            ->setMinimumTemperature($minimumTemperature);
    }

    /**
     * Get TransportEmergencyCardCode value
     * @return TransportEmergencyCardCodeType|null
     */
    public function getTransportEmergencyCardCode()
    {
        return $this->TransportEmergencyCardCode;
    }

    /**
     * Set TransportEmergencyCardCode value
     * @param TransportEmergencyCardCodeType $transportEmergencyCardCode
     * @return HazardousGoodsTransitType
     */
    public function setTransportEmergencyCardCode(TransportEmergencyCardCodeType $transportEmergencyCardCode = null)
    {
        $this->TransportEmergencyCardCode = $transportEmergencyCardCode;
        return $this;
    }

    /**
     * Get PackingCriteriaCode value
     * @return PackingCriteriaCodeType|null
     */
    public function getPackingCriteriaCode()
    {
        return $this->PackingCriteriaCode;
    }

    /**
     * Set PackingCriteriaCode value
     * @param PackingCriteriaCodeType $packingCriteriaCode
     * @return HazardousGoodsTransitType
     */
    public function setPackingCriteriaCode(PackingCriteriaCodeType $packingCriteriaCode = null)
    {
        $this->PackingCriteriaCode = $packingCriteriaCode;
        return $this;
    }

    /**
     * Get HazardousRegulationCode value
     * @return HazardousRegulationCodeType|null
     */
    public function getHazardousRegulationCode()
    {
        return $this->HazardousRegulationCode;
    }

    /**
     * Set HazardousRegulationCode value
     * @param HazardousRegulationCodeType $hazardousRegulationCode
     * @return HazardousGoodsTransitType
     */
    public function setHazardousRegulationCode(HazardousRegulationCodeType $hazardousRegulationCode = null)
    {
        $this->HazardousRegulationCode = $hazardousRegulationCode;
        return $this;
    }

    /**
     * Get InhalationToxicityZoneCode value
     * @return InhalationToxicityZoneCodeType|null
     */
    public function getInhalationToxicityZoneCode()
    {
        return $this->InhalationToxicityZoneCode;
    }

    /**
     * Set InhalationToxicityZoneCode value
     * @param InhalationToxicityZoneCodeType $inhalationToxicityZoneCode
     * @return HazardousGoodsTransitType
     */
    public function setInhalationToxicityZoneCode(InhalationToxicityZoneCodeType $inhalationToxicityZoneCode = null)
    {
        $this->InhalationToxicityZoneCode = $inhalationToxicityZoneCode;
        return $this;
    }

    /**
     * Get TransportAuthorizationCode value
     * @return TransportAuthorizationCodeType|null
     */
    public function getTransportAuthorizationCode()
    {
        return $this->TransportAuthorizationCode;
    }

    /**
     * Set TransportAuthorizationCode value
     * @param TransportAuthorizationCodeType $transportAuthorizationCode
     * @return HazardousGoodsTransitType
     */
    public function setTransportAuthorizationCode(TransportAuthorizationCodeType $transportAuthorizationCode = null)
    {
        $this->TransportAuthorizationCode = $transportAuthorizationCode;
        return $this;
    }

    /**
     * Get MaximumTemperature value
     * @return TemperatureType|null
     */
    public function getMaximumTemperature()
    {
        return $this->MaximumTemperature;
    }

    /**
     * Set MaximumTemperature value
     * @param TemperatureType $maximumTemperature
     * @return HazardousGoodsTransitType
     */
    public function setMaximumTemperature(TemperatureType $maximumTemperature = null)
    {
        $this->MaximumTemperature = $maximumTemperature;
        return $this;
    }

    /**
     * Get MinimumTemperature value
     * @return TemperatureType|null
     */
    public function getMinimumTemperature()
    {
        return $this->MinimumTemperature;
    }

    /**
     * Set MinimumTemperature value
     * @param TemperatureType $minimumTemperature
     * @return HazardousGoodsTransitType
     */
    public function setMinimumTemperature(TemperatureType $minimumTemperature = null)
    {
        $this->MinimumTemperature = $minimumTemperature;
        return $this;
    }
}
