<?php

namespace Gek\UyumBahceGet\StructType;

use InvalidArgumentException;
use WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GoodsItemType StructType
 * @subpackage Structs
 */
class GoodsItemType extends AbstractStructBase
{
    /**
     * The ID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: s4:ID
     * @var IDType
     */
    public $ID;
    /**
     * The Description
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - ref: s4:Description
     * @var DescriptionType[]
     */
    public $Description;
    /**
     * The HazardousRiskIndicator
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: s4:HazardousRiskIndicator
     * @var HazardousRiskIndicatorType
     */
    public $HazardousRiskIndicator;
    /**
     * The DeclaredCustomsValueAmount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: s4:DeclaredCustomsValueAmount
     * @var DeclaredCustomsValueAmountType
     */
    public $DeclaredCustomsValueAmount;
    /**
     * The DeclaredForCarriageValueAmount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: s4:DeclaredForCarriageValueAmount
     * @var DeclaredForCarriageValueAmountType
     */
    public $DeclaredForCarriageValueAmount;
    /**
     * The DeclaredStatisticsValueAmount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: s4:DeclaredStatisticsValueAmount
     * @var DeclaredStatisticsValueAmountType
     */
    public $DeclaredStatisticsValueAmount;
    /**
     * The FreeOnBoardValueAmount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: s4:FreeOnBoardValueAmount
     * @var FreeOnBoardValueAmountType
     */
    public $FreeOnBoardValueAmount;
    /**
     * The InsuranceValueAmount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: s4:InsuranceValueAmount
     * @var InsuranceValueAmountType
     */
    public $InsuranceValueAmount;
    /**
     * The ValueAmount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: s4:ValueAmount
     * @var ValueAmountType
     */
    public $ValueAmount;
    /**
     * The GrossWeightMeasure
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: s4:GrossWeightMeasure
     * @var GrossWeightMeasureType
     */
    public $GrossWeightMeasure;
    /**
     * The NetWeightMeasure
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: s4:NetWeightMeasure
     * @var NetWeightMeasureType
     */
    public $NetWeightMeasure;
    /**
     * The ChargeableWeightMeasure
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: s4:ChargeableWeightMeasure
     * @var ChargeableWeightMeasureType
     */
    public $ChargeableWeightMeasure;
    /**
     * The GrossVolumeMeasure
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: s4:GrossVolumeMeasure
     * @var GrossVolumeMeasureType
     */
    public $GrossVolumeMeasure;
    /**
     * The NetVolumeMeasure
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: s4:NetVolumeMeasure
     * @var NetVolumeMeasureType
     */
    public $NetVolumeMeasure;
    /**
     * The Quantity
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: s4:Quantity
     * @var QuantityType
     */
    public $Quantity;
    /**
     * The RequiredCustomsID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: s4:RequiredCustomsID
     * @var RequiredCustomsIDType
     */
    public $RequiredCustomsID;
    /**
     * The CustomsStatusCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: s4:CustomsStatusCode
     * @var CustomsStatusCodeType
     */
    public $CustomsStatusCode;
    /**
     * The CustomsTariffQuantity
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: s4:CustomsTariffQuantity
     * @var CustomsTariffQuantityType
     */
    public $CustomsTariffQuantity;
    /**
     * The CustomsImportClassifiedIndicator
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: s4:CustomsImportClassifiedIndicator
     * @var CustomsImportClassifiedIndicatorType
     */
    public $CustomsImportClassifiedIndicator;
    /**
     * The ChargeableQuantity
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: s4:ChargeableQuantity
     * @var ChargeableQuantityType
     */
    public $ChargeableQuantity;
    /**
     * The ReturnableQuantity
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: s4:ReturnableQuantity
     * @var ReturnableQuantityType
     */
    public $ReturnableQuantity;
    /**
     * The TraceID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: s4:TraceID
     * @var TraceIDType
     */
    public $TraceID;
    /**
     * The Item
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var ItemType[]
     */
    public $Item;
    /**
     * The FreightAllowanceCharge
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var AllowanceChargeType[]
     */
    public $FreightAllowanceCharge;
    /**
     * The InvoiceLine
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var InvoiceLineType[]
     */
    public $InvoiceLine;
    /**
     * The Temperature
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var TemperatureType[]
     */
    public $Temperature;
    /**
     * The OriginAddress
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var AddressType
     */
    public $OriginAddress;
    /**
     * The MeasurementDimension
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var DimensionType[]
     */
    public $MeasurementDimension;

    /**
     * Constructor method for GoodsItemType
     * @param IDType $iD
     * @param DescriptionType[] $description
     * @param HazardousRiskIndicatorType $hazardousRiskIndicator
     * @param DeclaredCustomsValueAmountType $declaredCustomsValueAmount
     * @param DeclaredForCarriageValueAmountType $declaredForCarriageValueAmount
     * @param DeclaredStatisticsValueAmountType $declaredStatisticsValueAmount
     * @param FreeOnBoardValueAmountType $freeOnBoardValueAmount
     * @param InsuranceValueAmountType $insuranceValueAmount
     * @param ValueAmountType $valueAmount
     * @param GrossWeightMeasureType $grossWeightMeasure
     * @param NetWeightMeasureType $netWeightMeasure
     * @param ChargeableWeightMeasureType $chargeableWeightMeasure
     * @param GrossVolumeMeasureType $grossVolumeMeasure
     * @param NetVolumeMeasureType $netVolumeMeasure
     * @param QuantityType $quantity
     * @param RequiredCustomsIDType $requiredCustomsID
     * @param CustomsStatusCodeType $customsStatusCode
     * @param CustomsTariffQuantityType $customsTariffQuantity
     * @param CustomsImportClassifiedIndicatorType $customsImportClassifiedIndicator
     * @param ChargeableQuantityType $chargeableQuantity
     * @param ReturnableQuantityType $returnableQuantity
     * @param TraceIDType $traceID
     * @param ItemType[] $item
     * @param AllowanceChargeType[] $freightAllowanceCharge
     * @param InvoiceLineType[] $invoiceLine
     * @param TemperatureType[] $temperature
     * @param AddressType $originAddress
     * @param DimensionType[] $measurementDimension
     * @uses GoodsItemType::setID()
     * @uses GoodsItemType::setDescription()
     * @uses GoodsItemType::setHazardousRiskIndicator()
     * @uses GoodsItemType::setDeclaredCustomsValueAmount()
     * @uses GoodsItemType::setDeclaredForCarriageValueAmount()
     * @uses GoodsItemType::setDeclaredStatisticsValueAmount()
     * @uses GoodsItemType::setFreeOnBoardValueAmount()
     * @uses GoodsItemType::setInsuranceValueAmount()
     * @uses GoodsItemType::setValueAmount()
     * @uses GoodsItemType::setGrossWeightMeasure()
     * @uses GoodsItemType::setNetWeightMeasure()
     * @uses GoodsItemType::setChargeableWeightMeasure()
     * @uses GoodsItemType::setGrossVolumeMeasure()
     * @uses GoodsItemType::setNetVolumeMeasure()
     * @uses GoodsItemType::setQuantity()
     * @uses GoodsItemType::setRequiredCustomsID()
     * @uses GoodsItemType::setCustomsStatusCode()
     * @uses GoodsItemType::setCustomsTariffQuantity()
     * @uses GoodsItemType::setCustomsImportClassifiedIndicator()
     * @uses GoodsItemType::setChargeableQuantity()
     * @uses GoodsItemType::setReturnableQuantity()
     * @uses GoodsItemType::setTraceID()
     * @uses GoodsItemType::setItem()
     * @uses GoodsItemType::setFreightAllowanceCharge()
     * @uses GoodsItemType::setInvoiceLine()
     * @uses GoodsItemType::setTemperature()
     * @uses GoodsItemType::setOriginAddress()
     * @uses GoodsItemType::setMeasurementDimension()
     */
    public function __construct(IDType $iD = null, array $description = array(), HazardousRiskIndicatorType $hazardousRiskIndicator = null, DeclaredCustomsValueAmountType $declaredCustomsValueAmount = null, DeclaredForCarriageValueAmountType $declaredForCarriageValueAmount = null, DeclaredStatisticsValueAmountType $declaredStatisticsValueAmount = null, FreeOnBoardValueAmountType $freeOnBoardValueAmount = null, InsuranceValueAmountType $insuranceValueAmount = null, ValueAmountType $valueAmount = null, GrossWeightMeasureType $grossWeightMeasure = null, NetWeightMeasureType $netWeightMeasure = null, ChargeableWeightMeasureType $chargeableWeightMeasure = null, GrossVolumeMeasureType $grossVolumeMeasure = null, NetVolumeMeasureType $netVolumeMeasure = null, QuantityType $quantity = null, RequiredCustomsIDType $requiredCustomsID = null, CustomsStatusCodeType $customsStatusCode = null, CustomsTariffQuantityType $customsTariffQuantity = null, CustomsImportClassifiedIndicatorType $customsImportClassifiedIndicator = null, ChargeableQuantityType $chargeableQuantity = null, ReturnableQuantityType $returnableQuantity = null, TraceIDType $traceID = null, array $item = array(), array $freightAllowanceCharge = array(), array $invoiceLine = array(), array $temperature = array(), AddressType $originAddress = null, array $measurementDimension = array())
    {
        $this
            ->setID($iD)
            ->setDescription($description)
            ->setHazardousRiskIndicator($hazardousRiskIndicator)
            ->setDeclaredCustomsValueAmount($declaredCustomsValueAmount)
            ->setDeclaredForCarriageValueAmount($declaredForCarriageValueAmount)
            ->setDeclaredStatisticsValueAmount($declaredStatisticsValueAmount)
            ->setFreeOnBoardValueAmount($freeOnBoardValueAmount)
            ->setInsuranceValueAmount($insuranceValueAmount)
            ->setValueAmount($valueAmount)
            ->setGrossWeightMeasure($grossWeightMeasure)
            ->setNetWeightMeasure($netWeightMeasure)
            ->setChargeableWeightMeasure($chargeableWeightMeasure)
            ->setGrossVolumeMeasure($grossVolumeMeasure)
            ->setNetVolumeMeasure($netVolumeMeasure)
            ->setQuantity($quantity)
            ->setRequiredCustomsID($requiredCustomsID)
            ->setCustomsStatusCode($customsStatusCode)
            ->setCustomsTariffQuantity($customsTariffQuantity)
            ->setCustomsImportClassifiedIndicator($customsImportClassifiedIndicator)
            ->setChargeableQuantity($chargeableQuantity)
            ->setReturnableQuantity($returnableQuantity)
            ->setTraceID($traceID)
            ->setItem($item)
            ->setFreightAllowanceCharge($freightAllowanceCharge)
            ->setInvoiceLine($invoiceLine)
            ->setTemperature($temperature)
            ->setOriginAddress($originAddress)
            ->setMeasurementDimension($measurementDimension);
    }

    /**
     * Get ID value
     * @return IDType|null
     */
    public function getID()
    {
        return $this->ID;
    }

    /**
     * Set ID value
     * @param IDType $iD
     * @return GoodsItemType
     */
    public function setID(IDType $iD = null)
    {
        $this->ID = $iD;
        return $this;
    }

    /**
     * Get Description value
     * @return DescriptionType[]|null
     */
    public function getDescription()
    {
        return $this->Description;
    }

    /**
     * This method is responsible for validating the values passed to the setDescription method
     * This method is willingly generated in order to preserve the one-line inline validation within the setDescription method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateDescriptionForArrayConstraintsFromSetDescription(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $goodsItemTypeDescriptionItem) {
            // validation for constraint: itemType
            if (!$goodsItemTypeDescriptionItem instanceof DescriptionType) {
                $invalidValues[] = is_object($goodsItemTypeDescriptionItem) ? get_class($goodsItemTypeDescriptionItem) : sprintf('%s(%s)', gettype($goodsItemTypeDescriptionItem), var_export($goodsItemTypeDescriptionItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Description property can only contain items of type \Gek\UyumBahceGet\StructType\DescriptionType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }

    /**
     * Set Description value
     * @param DescriptionType[] $description
     * @return GoodsItemType
     * @throws InvalidArgumentException
     */
    public function setDescription(array $description = array())
    {
        // validation for constraint: array
        if ('' !== ($descriptionArrayErrorMessage = self::validateDescriptionForArrayConstraintsFromSetDescription($description))) {
            throw new InvalidArgumentException($descriptionArrayErrorMessage, __LINE__);
        }
        $this->Description = $description;
        return $this;
    }

    /**
     * Add item to Description value
     * @param DescriptionType $item
     * @return GoodsItemType
     * @throws InvalidArgumentException
     */
    public function addToDescription(DescriptionType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof DescriptionType) {
            throw new InvalidArgumentException(sprintf('The Description property can only contain items of type \Gek\UyumBahceGet\StructType\DescriptionType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Description[] = $item;
        return $this;
    }

    /**
     * Get HazardousRiskIndicator value
     * @return HazardousRiskIndicatorType|null
     */
    public function getHazardousRiskIndicator()
    {
        return $this->HazardousRiskIndicator;
    }

    /**
     * Set HazardousRiskIndicator value
     * @param HazardousRiskIndicatorType $hazardousRiskIndicator
     * @return GoodsItemType
     */
    public function setHazardousRiskIndicator(HazardousRiskIndicatorType $hazardousRiskIndicator = null)
    {
        $this->HazardousRiskIndicator = $hazardousRiskIndicator;
        return $this;
    }

    /**
     * Get DeclaredCustomsValueAmount value
     * @return DeclaredCustomsValueAmountType|null
     */
    public function getDeclaredCustomsValueAmount()
    {
        return $this->DeclaredCustomsValueAmount;
    }

    /**
     * Set DeclaredCustomsValueAmount value
     * @param DeclaredCustomsValueAmountType $declaredCustomsValueAmount
     * @return GoodsItemType
     */
    public function setDeclaredCustomsValueAmount(DeclaredCustomsValueAmountType $declaredCustomsValueAmount = null)
    {
        $this->DeclaredCustomsValueAmount = $declaredCustomsValueAmount;
        return $this;
    }

    /**
     * Get DeclaredForCarriageValueAmount value
     * @return DeclaredForCarriageValueAmountType|null
     */
    public function getDeclaredForCarriageValueAmount()
    {
        return $this->DeclaredForCarriageValueAmount;
    }

    /**
     * Set DeclaredForCarriageValueAmount value
     * @param DeclaredForCarriageValueAmountType $declaredForCarriageValueAmount
     * @return GoodsItemType
     */
    public function setDeclaredForCarriageValueAmount(DeclaredForCarriageValueAmountType $declaredForCarriageValueAmount = null)
    {
        $this->DeclaredForCarriageValueAmount = $declaredForCarriageValueAmount;
        return $this;
    }

    /**
     * Get DeclaredStatisticsValueAmount value
     * @return DeclaredStatisticsValueAmountType|null
     */
    public function getDeclaredStatisticsValueAmount()
    {
        return $this->DeclaredStatisticsValueAmount;
    }

    /**
     * Set DeclaredStatisticsValueAmount value
     * @param DeclaredStatisticsValueAmountType $declaredStatisticsValueAmount
     * @return GoodsItemType
     */
    public function setDeclaredStatisticsValueAmount(DeclaredStatisticsValueAmountType $declaredStatisticsValueAmount = null)
    {
        $this->DeclaredStatisticsValueAmount = $declaredStatisticsValueAmount;
        return $this;
    }

    /**
     * Get FreeOnBoardValueAmount value
     * @return FreeOnBoardValueAmountType|null
     */
    public function getFreeOnBoardValueAmount()
    {
        return $this->FreeOnBoardValueAmount;
    }

    /**
     * Set FreeOnBoardValueAmount value
     * @param FreeOnBoardValueAmountType $freeOnBoardValueAmount
     * @return GoodsItemType
     */
    public function setFreeOnBoardValueAmount(FreeOnBoardValueAmountType $freeOnBoardValueAmount = null)
    {
        $this->FreeOnBoardValueAmount = $freeOnBoardValueAmount;
        return $this;
    }

    /**
     * Get InsuranceValueAmount value
     * @return InsuranceValueAmountType|null
     */
    public function getInsuranceValueAmount()
    {
        return $this->InsuranceValueAmount;
    }

    /**
     * Set InsuranceValueAmount value
     * @param InsuranceValueAmountType $insuranceValueAmount
     * @return GoodsItemType
     */
    public function setInsuranceValueAmount(InsuranceValueAmountType $insuranceValueAmount = null)
    {
        $this->InsuranceValueAmount = $insuranceValueAmount;
        return $this;
    }

    /**
     * Get ValueAmount value
     * @return ValueAmountType|null
     */
    public function getValueAmount()
    {
        return $this->ValueAmount;
    }

    /**
     * Set ValueAmount value
     * @param ValueAmountType $valueAmount
     * @return GoodsItemType
     */
    public function setValueAmount(ValueAmountType $valueAmount = null)
    {
        $this->ValueAmount = $valueAmount;
        return $this;
    }

    /**
     * Get GrossWeightMeasure value
     * @return GrossWeightMeasureType|null
     */
    public function getGrossWeightMeasure()
    {
        return $this->GrossWeightMeasure;
    }

    /**
     * Set GrossWeightMeasure value
     * @param GrossWeightMeasureType $grossWeightMeasure
     * @return GoodsItemType
     */
    public function setGrossWeightMeasure(GrossWeightMeasureType $grossWeightMeasure = null)
    {
        $this->GrossWeightMeasure = $grossWeightMeasure;
        return $this;
    }

    /**
     * Get NetWeightMeasure value
     * @return NetWeightMeasureType|null
     */
    public function getNetWeightMeasure()
    {
        return $this->NetWeightMeasure;
    }

    /**
     * Set NetWeightMeasure value
     * @param NetWeightMeasureType $netWeightMeasure
     * @return GoodsItemType
     */
    public function setNetWeightMeasure(NetWeightMeasureType $netWeightMeasure = null)
    {
        $this->NetWeightMeasure = $netWeightMeasure;
        return $this;
    }

    /**
     * Get ChargeableWeightMeasure value
     * @return ChargeableWeightMeasureType|null
     */
    public function getChargeableWeightMeasure()
    {
        return $this->ChargeableWeightMeasure;
    }

    /**
     * Set ChargeableWeightMeasure value
     * @param ChargeableWeightMeasureType $chargeableWeightMeasure
     * @return GoodsItemType
     */
    public function setChargeableWeightMeasure(ChargeableWeightMeasureType $chargeableWeightMeasure = null)
    {
        $this->ChargeableWeightMeasure = $chargeableWeightMeasure;
        return $this;
    }

    /**
     * Get GrossVolumeMeasure value
     * @return GrossVolumeMeasureType|null
     */
    public function getGrossVolumeMeasure()
    {
        return $this->GrossVolumeMeasure;
    }

    /**
     * Set GrossVolumeMeasure value
     * @param GrossVolumeMeasureType $grossVolumeMeasure
     * @return GoodsItemType
     */
    public function setGrossVolumeMeasure(GrossVolumeMeasureType $grossVolumeMeasure = null)
    {
        $this->GrossVolumeMeasure = $grossVolumeMeasure;
        return $this;
    }

    /**
     * Get NetVolumeMeasure value
     * @return NetVolumeMeasureType|null
     */
    public function getNetVolumeMeasure()
    {
        return $this->NetVolumeMeasure;
    }

    /**
     * Set NetVolumeMeasure value
     * @param NetVolumeMeasureType $netVolumeMeasure
     * @return GoodsItemType
     */
    public function setNetVolumeMeasure(NetVolumeMeasureType $netVolumeMeasure = null)
    {
        $this->NetVolumeMeasure = $netVolumeMeasure;
        return $this;
    }

    /**
     * Get Quantity value
     * @return QuantityType|null
     */
    public function getQuantity()
    {
        return $this->Quantity;
    }

    /**
     * Set Quantity value
     * @param QuantityType $quantity
     * @return GoodsItemType
     */
    public function setQuantity(QuantityType $quantity = null)
    {
        $this->Quantity = $quantity;
        return $this;
    }

    /**
     * Get RequiredCustomsID value
     * @return RequiredCustomsIDType|null
     */
    public function getRequiredCustomsID()
    {
        return $this->RequiredCustomsID;
    }

    /**
     * Set RequiredCustomsID value
     * @param RequiredCustomsIDType $requiredCustomsID
     * @return GoodsItemType
     */
    public function setRequiredCustomsID(RequiredCustomsIDType $requiredCustomsID = null)
    {
        $this->RequiredCustomsID = $requiredCustomsID;
        return $this;
    }

    /**
     * Get CustomsStatusCode value
     * @return CustomsStatusCodeType|null
     */
    public function getCustomsStatusCode()
    {
        return $this->CustomsStatusCode;
    }

    /**
     * Set CustomsStatusCode value
     * @param CustomsStatusCodeType $customsStatusCode
     * @return GoodsItemType
     */
    public function setCustomsStatusCode(CustomsStatusCodeType $customsStatusCode = null)
    {
        $this->CustomsStatusCode = $customsStatusCode;
        return $this;
    }

    /**
     * Get CustomsTariffQuantity value
     * @return CustomsTariffQuantityType|null
     */
    public function getCustomsTariffQuantity()
    {
        return $this->CustomsTariffQuantity;
    }

    /**
     * Set CustomsTariffQuantity value
     * @param CustomsTariffQuantityType $customsTariffQuantity
     * @return GoodsItemType
     */
    public function setCustomsTariffQuantity(CustomsTariffQuantityType $customsTariffQuantity = null)
    {
        $this->CustomsTariffQuantity = $customsTariffQuantity;
        return $this;
    }

    /**
     * Get CustomsImportClassifiedIndicator value
     * @return CustomsImportClassifiedIndicatorType|null
     */
    public function getCustomsImportClassifiedIndicator()
    {
        return $this->CustomsImportClassifiedIndicator;
    }

    /**
     * Set CustomsImportClassifiedIndicator value
     * @param CustomsImportClassifiedIndicatorType $customsImportClassifiedIndicator
     * @return GoodsItemType
     */
    public function setCustomsImportClassifiedIndicator(CustomsImportClassifiedIndicatorType $customsImportClassifiedIndicator = null)
    {
        $this->CustomsImportClassifiedIndicator = $customsImportClassifiedIndicator;
        return $this;
    }

    /**
     * Get ChargeableQuantity value
     * @return ChargeableQuantityType|null
     */
    public function getChargeableQuantity()
    {
        return $this->ChargeableQuantity;
    }

    /**
     * Set ChargeableQuantity value
     * @param ChargeableQuantityType $chargeableQuantity
     * @return GoodsItemType
     */
    public function setChargeableQuantity(ChargeableQuantityType $chargeableQuantity = null)
    {
        $this->ChargeableQuantity = $chargeableQuantity;
        return $this;
    }

    /**
     * Get ReturnableQuantity value
     * @return ReturnableQuantityType|null
     */
    public function getReturnableQuantity()
    {
        return $this->ReturnableQuantity;
    }

    /**
     * Set ReturnableQuantity value
     * @param ReturnableQuantityType $returnableQuantity
     * @return GoodsItemType
     */
    public function setReturnableQuantity(ReturnableQuantityType $returnableQuantity = null)
    {
        $this->ReturnableQuantity = $returnableQuantity;
        return $this;
    }

    /**
     * Get TraceID value
     * @return TraceIDType|null
     */
    public function getTraceID()
    {
        return $this->TraceID;
    }

    /**
     * Set TraceID value
     * @param TraceIDType $traceID
     * @return GoodsItemType
     */
    public function setTraceID(TraceIDType $traceID = null)
    {
        $this->TraceID = $traceID;
        return $this;
    }

    /**
     * Get Item value
     * @return ItemType[]|null
     */
    public function getItem()
    {
        return $this->Item;
    }

    /**
     * This method is responsible for validating the values passed to the setItem method
     * This method is willingly generated in order to preserve the one-line inline validation within the setItem method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateItemForArrayConstraintsFromSetItem(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $goodsItemTypeItemItem) {
            // validation for constraint: itemType
            if (!$goodsItemTypeItemItem instanceof ItemType) {
                $invalidValues[] = is_object($goodsItemTypeItemItem) ? get_class($goodsItemTypeItemItem) : sprintf('%s(%s)', gettype($goodsItemTypeItemItem), var_export($goodsItemTypeItemItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Item property can only contain items of type \Gek\UyumBahceGet\StructType\ItemType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }

    /**
     * Set Item value
     * @param ItemType[] $item
     * @return GoodsItemType
     * @throws InvalidArgumentException
     */
    public function setItem(array $item = array())
    {
        // validation for constraint: array
        if ('' !== ($itemArrayErrorMessage = self::validateItemForArrayConstraintsFromSetItem($item))) {
            throw new InvalidArgumentException($itemArrayErrorMessage, __LINE__);
        }
        $this->Item = $item;
        return $this;
    }

    /**
     * Add item to Item value
     * @param ItemType $item
     * @return GoodsItemType
     * @throws InvalidArgumentException
     */
    public function addToItem(ItemType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof ItemType) {
            throw new InvalidArgumentException(sprintf('The Item property can only contain items of type \Gek\UyumBahceGet\StructType\ItemType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Item[] = $item;
        return $this;
    }

    /**
     * Get FreightAllowanceCharge value
     * @return AllowanceChargeType[]|null
     */
    public function getFreightAllowanceCharge()
    {
        return $this->FreightAllowanceCharge;
    }

    /**
     * This method is responsible for validating the values passed to the setFreightAllowanceCharge method
     * This method is willingly generated in order to preserve the one-line inline validation within the setFreightAllowanceCharge method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateFreightAllowanceChargeForArrayConstraintsFromSetFreightAllowanceCharge(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $goodsItemTypeFreightAllowanceChargeItem) {
            // validation for constraint: itemType
            if (!$goodsItemTypeFreightAllowanceChargeItem instanceof AllowanceChargeType) {
                $invalidValues[] = is_object($goodsItemTypeFreightAllowanceChargeItem) ? get_class($goodsItemTypeFreightAllowanceChargeItem) : sprintf('%s(%s)', gettype($goodsItemTypeFreightAllowanceChargeItem), var_export($goodsItemTypeFreightAllowanceChargeItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The FreightAllowanceCharge property can only contain items of type \Gek\UyumBahceGet\StructType\AllowanceChargeType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }

    /**
     * Set FreightAllowanceCharge value
     * @param AllowanceChargeType[] $freightAllowanceCharge
     * @return GoodsItemType
     * @throws InvalidArgumentException
     */
    public function setFreightAllowanceCharge(array $freightAllowanceCharge = array())
    {
        // validation for constraint: array
        if ('' !== ($freightAllowanceChargeArrayErrorMessage = self::validateFreightAllowanceChargeForArrayConstraintsFromSetFreightAllowanceCharge($freightAllowanceCharge))) {
            throw new InvalidArgumentException($freightAllowanceChargeArrayErrorMessage, __LINE__);
        }
        $this->FreightAllowanceCharge = $freightAllowanceCharge;
        return $this;
    }

    /**
     * Add item to FreightAllowanceCharge value
     * @param AllowanceChargeType $item
     * @return GoodsItemType
     * @throws InvalidArgumentException
     */
    public function addToFreightAllowanceCharge(AllowanceChargeType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof AllowanceChargeType) {
            throw new InvalidArgumentException(sprintf('The FreightAllowanceCharge property can only contain items of type \Gek\UyumBahceGet\StructType\AllowanceChargeType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->FreightAllowanceCharge[] = $item;
        return $this;
    }

    /**
     * Get InvoiceLine value
     * @return InvoiceLineType[]|null
     */
    public function getInvoiceLine()
    {
        return $this->InvoiceLine;
    }

    /**
     * This method is responsible for validating the values passed to the setInvoiceLine method
     * This method is willingly generated in order to preserve the one-line inline validation within the setInvoiceLine method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateInvoiceLineForArrayConstraintsFromSetInvoiceLine(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $goodsItemTypeInvoiceLineItem) {
            // validation for constraint: itemType
            if (!$goodsItemTypeInvoiceLineItem instanceof InvoiceLineType) {
                $invalidValues[] = is_object($goodsItemTypeInvoiceLineItem) ? get_class($goodsItemTypeInvoiceLineItem) : sprintf('%s(%s)', gettype($goodsItemTypeInvoiceLineItem), var_export($goodsItemTypeInvoiceLineItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The InvoiceLine property can only contain items of type \Gek\UyumBahceGet\StructType\InvoiceLineType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }

    /**
     * Set InvoiceLine value
     * @param InvoiceLineType[] $invoiceLine
     * @return GoodsItemType
     * @throws InvalidArgumentException
     */
    public function setInvoiceLine(array $invoiceLine = array())
    {
        // validation for constraint: array
        if ('' !== ($invoiceLineArrayErrorMessage = self::validateInvoiceLineForArrayConstraintsFromSetInvoiceLine($invoiceLine))) {
            throw new InvalidArgumentException($invoiceLineArrayErrorMessage, __LINE__);
        }
        $this->InvoiceLine = $invoiceLine;
        return $this;
    }

    /**
     * Add item to InvoiceLine value
     * @param InvoiceLineType $item
     * @return GoodsItemType
     * @throws InvalidArgumentException
     */
    public function addToInvoiceLine(InvoiceLineType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof InvoiceLineType) {
            throw new InvalidArgumentException(sprintf('The InvoiceLine property can only contain items of type \Gek\UyumBahceGet\StructType\InvoiceLineType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->InvoiceLine[] = $item;
        return $this;
    }

    /**
     * Get Temperature value
     * @return TemperatureType[]|null
     */
    public function getTemperature()
    {
        return $this->Temperature;
    }

    /**
     * This method is responsible for validating the values passed to the setTemperature method
     * This method is willingly generated in order to preserve the one-line inline validation within the setTemperature method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateTemperatureForArrayConstraintsFromSetTemperature(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $goodsItemTypeTemperatureItem) {
            // validation for constraint: itemType
            if (!$goodsItemTypeTemperatureItem instanceof TemperatureType) {
                $invalidValues[] = is_object($goodsItemTypeTemperatureItem) ? get_class($goodsItemTypeTemperatureItem) : sprintf('%s(%s)', gettype($goodsItemTypeTemperatureItem), var_export($goodsItemTypeTemperatureItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Temperature property can only contain items of type \Gek\UyumBahceGet\StructType\TemperatureType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }

    /**
     * Set Temperature value
     * @param TemperatureType[] $temperature
     * @return GoodsItemType
     * @throws InvalidArgumentException
     */
    public function setTemperature(array $temperature = array())
    {
        // validation for constraint: array
        if ('' !== ($temperatureArrayErrorMessage = self::validateTemperatureForArrayConstraintsFromSetTemperature($temperature))) {
            throw new InvalidArgumentException($temperatureArrayErrorMessage, __LINE__);
        }
        $this->Temperature = $temperature;
        return $this;
    }

    /**
     * Add item to Temperature value
     * @param TemperatureType $item
     * @return GoodsItemType
     * @throws InvalidArgumentException
     */
    public function addToTemperature(TemperatureType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof TemperatureType) {
            throw new InvalidArgumentException(sprintf('The Temperature property can only contain items of type \Gek\UyumBahceGet\StructType\TemperatureType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Temperature[] = $item;
        return $this;
    }

    /**
     * Get OriginAddress value
     * @return AddressType|null
     */
    public function getOriginAddress()
    {
        return $this->OriginAddress;
    }

    /**
     * Set OriginAddress value
     * @param AddressType $originAddress
     * @return GoodsItemType
     */
    public function setOriginAddress(AddressType $originAddress = null)
    {
        $this->OriginAddress = $originAddress;
        return $this;
    }

    /**
     * Get MeasurementDimension value
     * @return DimensionType[]|null
     */
    public function getMeasurementDimension()
    {
        return $this->MeasurementDimension;
    }

    /**
     * This method is responsible for validating the values passed to the setMeasurementDimension method
     * This method is willingly generated in order to preserve the one-line inline validation within the setMeasurementDimension method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateMeasurementDimensionForArrayConstraintsFromSetMeasurementDimension(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $goodsItemTypeMeasurementDimensionItem) {
            // validation for constraint: itemType
            if (!$goodsItemTypeMeasurementDimensionItem instanceof DimensionType) {
                $invalidValues[] = is_object($goodsItemTypeMeasurementDimensionItem) ? get_class($goodsItemTypeMeasurementDimensionItem) : sprintf('%s(%s)', gettype($goodsItemTypeMeasurementDimensionItem), var_export($goodsItemTypeMeasurementDimensionItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The MeasurementDimension property can only contain items of type \Gek\UyumBahceGet\StructType\DimensionType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }

    /**
     * Set MeasurementDimension value
     * @param DimensionType[] $measurementDimension
     * @return GoodsItemType
     * @throws InvalidArgumentException
     */
    public function setMeasurementDimension(array $measurementDimension = array())
    {
        // validation for constraint: array
        if ('' !== ($measurementDimensionArrayErrorMessage = self::validateMeasurementDimensionForArrayConstraintsFromSetMeasurementDimension($measurementDimension))) {
            throw new InvalidArgumentException($measurementDimensionArrayErrorMessage, __LINE__);
        }
        $this->MeasurementDimension = $measurementDimension;
        return $this;
    }

    /**
     * Add item to MeasurementDimension value
     * @param DimensionType $item
     * @return GoodsItemType
     * @throws InvalidArgumentException
     */
    public function addToMeasurementDimension(DimensionType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof DimensionType) {
            throw new InvalidArgumentException(sprintf('The MeasurementDimension property can only contain items of type \Gek\UyumBahceGet\StructType\DimensionType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->MeasurementDimension[] = $item;
        return $this;
    }
}
