<?php

namespace Gek\UyumBahceGet\StructType;

use Gek\UyumBahceGet\ArrayType\ArrayOfString;
use Gek\UyumBahceGet\GekDateTime;
use InvalidArgumentException;
use WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetSrvItemContext StructType
 * @subpackage Structs
 */
class GetSrvItemContext extends AbstractStructBase
{
    /**
     * The PriceListStartDate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $PriceListStartDate = "1.01.0001 00:00:00";
    /**
     * The PriceListEndDate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $PriceListEndDate = "1.01.0001 00:00:00";
    /**
     * The ItemStartDate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $ItemStartDate = "1.01.0001 00:00:00";
    /**
     * The ItemEndDate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $ItemEndDate = "1.01.0001 00:00:00";
    /**
     * The BranchCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $BranchCode = null;
    /**
     * The WhouseCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $WhouseCode = null;
    /**
     * The ItemCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ItemCode = null;
    /**
     * The PriceListCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var ArrayOfString
     */
    public $PriceListCode;
    /**
     * The DontWants
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $DontWants = null;

    /**
     * Constructor method for GetSrvItemContext
     * @param string $priceListStartDate
     * @param string $priceListEndDate
     * @param string $itemStartDate
     * @param string $itemEndDate
     * @param string $branchCode
     * @param string $whouseCode
     * @param string $itemCode
     * @param ArrayOfString $priceListCode
     * @param string $dontWants
     * @uses GetSrvItemContext::setPriceListStartDate()
     * @uses GetSrvItemContext::setPriceListEndDate()
     * @uses GetSrvItemContext::setItemStartDate()
     * @uses GetSrvItemContext::setItemEndDate()
     * @uses GetSrvItemContext::setBranchCode()
     * @uses GetSrvItemContext::setWhouseCode()
     * @uses GetSrvItemContext::setItemCode()
     * @uses GetSrvItemContext::setPriceListCode()
     * @uses GetSrvItemContext::setDontWants()
     */
    public function __construct($priceListStartDate = null, $priceListEndDate = null, $itemStartDate = null, $itemEndDate = null, $branchCode = null, $whouseCode = null, $itemCode = null, ArrayOfString $priceListCode = null, $dontWants = null)
    {
        $this
            ->setPriceListStartDate($priceListStartDate)
            ->setPriceListEndDate($priceListEndDate)
            ->setItemStartDate($itemStartDate)
            ->setItemEndDate($itemEndDate)
            ->setBranchCode($branchCode)
            ->setWhouseCode($whouseCode)
            ->setItemCode($itemCode)
            ->setPriceListCode($priceListCode)
            ->setDontWants($dontWants);
    }

    /**
     * Get PriceListStartDate value
     * @return string
     */
    public function getPriceListStartDate()
    {
        return $this->PriceListStartDate;
    }

    /**
     * Set PriceListStartDate value
     * @param string $priceListStartDate
     * @return GetSrvItemContext
     */
    public function setPriceListStartDate($priceListStartDate = null)
    {
        // validation for constraint: string
        if (!is_null($priceListStartDate) && !is_string($priceListStartDate) && !($priceListStartDate instanceof GekDateTime)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($priceListStartDate, true), gettype($priceListStartDate)), __LINE__);
        }
        if ($priceListStartDate instanceof GekDateTime) {
            $priceListStartDate = $priceListStartDate->toServiceString();
        }
        $this->PriceListStartDate = $priceListStartDate;
        return $this;
    }

    /**
     * Get PriceListEndDate value
     * @return string
     */
    public function getPriceListEndDate()
    {
        return $this->PriceListEndDate;
    }

    /**
     * Set PriceListEndDate value
     * @param string $priceListEndDate
     * @return GetSrvItemContext
     */
    public function setPriceListEndDate($priceListEndDate = null)
    {

        // validation for constraint: string
        if (!is_null($priceListEndDate) && !is_string($priceListEndDate) && !($priceListEndDate instanceof GekDateTime)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($priceListEndDate, true), gettype($priceListEndDate)), __LINE__);
        }
        if ($priceListEndDate instanceof GekDateTime) {
            $priceListEndDate = $priceListEndDate->toServiceString();
        }
        $this->PriceListEndDate = $priceListEndDate;
        return $this;
    }

    /**
     * Get ItemStartDate value
     * @return string
     */
    public function getItemStartDate()
    {
        return $this->ItemStartDate;
    }

    /**
     * Set ItemStartDate value
     * @param string $itemStartDate
     * @return GetSrvItemContext
     */
    public function setItemStartDate($itemStartDate = null)
    {
        // validation for constraint: string
        if (!is_null($itemStartDate) && !is_string($itemStartDate) && !($itemStartDate instanceof GekDateTime)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($itemStartDate, true), gettype($itemStartDate)), __LINE__);
        }
        if ($itemStartDate instanceof GekDateTime) {
            $itemStartDate = $itemStartDate->toServiceString();
        }
        $this->ItemStartDate = $itemStartDate;
        return $this;
    }

    /**
     * Get ItemEndDate value
     * @return string
     */
    public function getItemEndDate()
    {
        return $this->ItemEndDate;
    }

    /**
     * Set ItemEndDate value
     * @param string $itemEndDate
     * @return GetSrvItemContext
     */
    public function setItemEndDate($itemEndDate = null)
    {
        // validation for constraint: string
        if (!is_null($itemEndDate) && !is_string($itemEndDate) && !($itemEndDate instanceof GekDateTime)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($itemEndDate, true), gettype($itemEndDate)), __LINE__);
        }
        if ($itemEndDate instanceof GekDateTime) {
            $itemEndDate = $itemEndDate->toServiceString();
        }
        $this->ItemEndDate = $itemEndDate;
        return $this;
    }

    /**
     * Get BranchCode value
     * @return string|null
     */
    public function getBranchCode()
    {
        return $this->BranchCode;
    }

    /**
     * Set BranchCode value
     * @param string $branchCode
     * @return GetSrvItemContext
     */
    public function setBranchCode($branchCode = null)
    {
        // validation for constraint: string
        if (!is_null($branchCode) && !is_string($branchCode)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($branchCode, true), gettype($branchCode)), __LINE__);
        }
        $this->BranchCode = $branchCode;
        return $this;
    }

    /**
     * Get WhouseCode value
     * @return string|null
     */
    public function getWhouseCode()
    {
        return $this->WhouseCode;
    }

    /**
     * Set WhouseCode value
     * @param string $whouseCode
     * @return GetSrvItemContext
     */
    public function setWhouseCode($whouseCode = null)
    {
        // validation for constraint: string
        if (!is_null($whouseCode) && !is_string($whouseCode)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($whouseCode, true), gettype($whouseCode)), __LINE__);
        }
        $this->WhouseCode = $whouseCode;
        return $this;
    }

    /**
     * Get ItemCode value
     * @return string|null
     */
    public function getItemCode()
    {
        return $this->ItemCode;
    }

    /**
     * Set ItemCode value
     * @param string $itemCode
     * @return GetSrvItemContext
     */
    public function setItemCode($itemCode = null)
    {
        // validation for constraint: string
        if (!is_null($itemCode) && !is_string($itemCode)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($itemCode, true), gettype($itemCode)), __LINE__);
        }
        $this->ItemCode = $itemCode;
        return $this;
    }

    /**
     * Get PriceListCode value
     * @return ArrayOfString|null
     */
    public function getPriceListCode()
    {
        return $this->PriceListCode;
    }

    /**
     * Set PriceListCode value
     * @param ArrayOfString $priceListCode
     * @return GetSrvItemContext
     */
    public function setPriceListCode(ArrayOfString $priceListCode = null)
    {
        $this->PriceListCode = $priceListCode;
        return $this;
    }

    /**
     * Get DontWants value
     * @return string|null
     */
    public function getDontWants()
    {
        return $this->DontWants;
    }

    /**
     * Set DontWants value
     * @param string $dontWants
     * @return GetSrvItemContext
     */
    public function setDontWants($dontWants = null)
    {
        // validation for constraint: string
        if (!is_null($dontWants) && !is_string($dontWants)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dontWants, true), gettype($dontWants)), __LINE__);
        }
        $this->DontWants = $dontWants;
        return $this;
    }
}
