<?php

namespace Gek\UyumBahceGet\StructType;

use Gek\UyumBahceGet\ArrayType\ArrayOfInt;
use Gek\UyumBahceGet\GekDateTime;
use InvalidArgumentException;
use WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetServiceDef StructType
 * @subpackage Structs
 */
class GetServiceDef extends AbstractStructBase
{
    /**
     * The Id
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $Id;
    /**
     * The CoId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $CoId;
    /**
     * The BranchId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $BranchId;
    /**
     * The StartDate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $StartDate;
    /**
     * The EndDate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $EndDate;
    /**
     * The ItemId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $ItemId;
    /**
     * The SourceMId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $SourceMId;
    /**
     * The SourceApp
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $SourceApp;
    /**
     * The IsPassive
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $IsPassive;
    /**
     * The EntityId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $EntityId;
    /**
     * The WhouseId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $WhouseId;
    /**
     * The OrderStatus
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $OrderStatus;
    /**
     * The Code
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Code;
    /**
     * The CoCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CoCode;
    /**
     * The BranchCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $BranchCode;
    /**
     * The DocNo
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $DocNo;
    /**
     * The EntityCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $EntityCode;
    /**
     * The TIds
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var ArrayOfInt
     */
    public $TIds;
    /**
     * The VknTckn
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $VknTckn;
    /**
     * The PurcSalesList
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var ArrayOfInt
     */
    public $PurcSalesList;
    /**
     * The ETTN
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ETTN;

    /**
     * Constructor method for GetServiceDef
     * @param int $id
     * @param int $coId
     * @param int $branchId
     * @param string|GekDateTime $startDate
     * @param string|GekDateTime $endDate
     * @param int $itemId
     * @param int $sourceMId
     * @param int $sourceApp
     * @param bool $isPassive
     * @param int $entityId
     * @param int $whouseId
     * @param int $orderStatus
     * @param string $code
     * @param string $coCode
     * @param string $branchCode
     * @param string $docNo
     * @param string $entityCode
     * @param ArrayOfInt $tIds
     * @param string $vknTckn
     * @param ArrayOfInt $purcSalesList
     * @param string $eTTN
     * @uses GetServiceDef::setId()
     * @uses GetServiceDef::setCoId()
     * @uses GetServiceDef::setBranchId()
     * @uses GetServiceDef::setStartDate()
     * @uses GetServiceDef::setEndDate()
     * @uses GetServiceDef::setItemId()
     * @uses GetServiceDef::setSourceMId()
     * @uses GetServiceDef::setSourceApp()
     * @uses GetServiceDef::setIsPassive()
     * @uses GetServiceDef::setEntityId()
     * @uses GetServiceDef::setWhouseId()
     * @uses GetServiceDef::setOrderStatus()
     * @uses GetServiceDef::setCode()
     * @uses GetServiceDef::setCoCode()
     * @uses GetServiceDef::setBranchCode()
     * @uses GetServiceDef::setDocNo()
     * @uses GetServiceDef::setEntityCode()
     * @uses GetServiceDef::setTIds()
     * @uses GetServiceDef::setVknTckn()
     * @uses GetServiceDef::setPurcSalesList()
     * @uses GetServiceDef::setETTN()
     */
    public function __construct($id = 0, $coId = 0, $branchId = 0, $startDate = "", $endDate = null, $itemId = null, $sourceMId = null, $sourceApp = null, $isPassive = null, $entityId = null, $whouseId = null, $orderStatus = null, $code = null, $coCode = null, $branchCode = null, $docNo = null, $entityCode = null, ArrayOfInt $tIds = null, $vknTckn = null, ArrayOfInt $purcSalesList = null, $eTTN = null)
    {
        $this
            ->setId($id)
            ->setCoId($coId)
            ->setBranchId($branchId)
            ->setStartDate($startDate)
            ->setEndDate($endDate)
            ->setItemId($itemId)
            ->setSourceMId($sourceMId)
            ->setSourceApp($sourceApp)
            ->setIsPassive($isPassive)
            ->setEntityId($entityId)
            ->setWhouseId($whouseId)
            ->setOrderStatus($orderStatus)
            ->setCode($code)
            ->setCoCode($coCode)
            ->setBranchCode($branchCode)
            ->setDocNo($docNo)
            ->setEntityCode($entityCode)
            ->setTIds($tIds)
            ->setVknTckn($vknTckn)
            ->setPurcSalesList($purcSalesList)
            ->setETTN($eTTN);
    }

    /**
     * Get Id value
     * @return int
     */
    public function getId()
    {
        return $this->Id;
    }

    /**
     * Set Id value
     * @param int $id
     * @return GetServiceDef
     */
    public function setId($id = null)
    {
        // validation for constraint: int
        if (!is_null($id) && !(is_int($id) || ctype_digit($id))) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($id, true), gettype($id)), __LINE__);
        }
        $this->Id = $id;
        return $this;
    }

    /**
     * Get CoId value
     * @return int
     */
    public function getCoId()
    {
        return $this->CoId;
    }

    /**
     * Set CoId value
     * @param int $coId
     * @return GetServiceDef
     */
    public function setCoId($coId = null)
    {
        // validation for constraint: int
        if (!is_null($coId) && !(is_int($coId) || ctype_digit($coId))) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($coId, true), gettype($coId)), __LINE__);
        }
        $this->CoId = $coId;
        return $this;
    }

    /**
     * Get BranchId value
     * @return int
     */
    public function getBranchId()
    {
        return $this->BranchId;
    }

    /**
     * Set BranchId value
     * @param int $branchId
     * @return GetServiceDef
     */
    public function setBranchId($branchId = null)
    {
        // validation for constraint: int
        if (!is_null($branchId) && !(is_int($branchId) || ctype_digit($branchId))) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($branchId, true), gettype($branchId)), __LINE__);
        }
        $this->BranchId = $branchId;
        return $this;
    }

    /**
     * Get StartDate value
     * @return string
     */
    public function getStartDate()
    {
        return $this->StartDate;
    }

    /**
     * Set StartDate value
     * @param string|GekDateTime|null $startDate
     * @return GetServiceDef
     */
    public function setStartDate($startDate = null)
    {
        // validation for constraint: string
        if (!is_null($startDate) && !is_string($startDate) && !($startDate instanceof GekDateTime)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($startDate, true), gettype($startDate)), __LINE__);
        }
        if ($startDate instanceof GekDateTime) {
            $startDate = $startDate->toServiceString();
        }
        $this->StartDate = $startDate;
        return $this;
    }

    /**
     * Get EndDate value
     * @return string
     */
    public function getEndDate()
    {
        return $this->EndDate;
    }

    /**
     * Set EndDate value
     * @param string|GekDateTime|null $endDate
     * @return GetServiceDef
     */
    public function setEndDate($endDate = null)
    {
        // validation for constraint: string
        if (!is_null($endDate) && !is_string($endDate) && !($endDate instanceof GekDateTime)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($endDate, true), gettype($endDate)), __LINE__);
        }
        if ($endDate instanceof GekDateTime) {
            $endDate = $endDate->toServiceString();
        }
        $this->EndDate = $endDate;
        return $this;
    }

    /**
     * Get ItemId value
     * @return int
     */
    public function getItemId()
    {
        return $this->ItemId;
    }

    /**
     * Set ItemId value
     * @param int $itemId
     * @return GetServiceDef
     */
    public function setItemId($itemId = null)
    {
        // validation for constraint: int
        if (!is_null($itemId) && !(is_int($itemId) || ctype_digit($itemId))) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($itemId, true), gettype($itemId)), __LINE__);
        }
        $this->ItemId = $itemId;
        return $this;
    }

    /**
     * Get SourceMId value
     * @return int
     */
    public function getSourceMId()
    {
        return $this->SourceMId;
    }

    /**
     * Set SourceMId value
     * @param int $sourceMId
     * @return GetServiceDef
     */
    public function setSourceMId($sourceMId = null)
    {
        // validation for constraint: int
        if (!is_null($sourceMId) && !(is_int($sourceMId) || ctype_digit($sourceMId))) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($sourceMId, true), gettype($sourceMId)), __LINE__);
        }
        $this->SourceMId = $sourceMId;
        return $this;
    }

    /**
     * Get SourceApp value
     * @return int
     */
    public function getSourceApp()
    {
        return $this->SourceApp;
    }

    /**
     * Set SourceApp value
     * @param int $sourceApp
     * @return GetServiceDef
     */
    public function setSourceApp($sourceApp = null)
    {
        // validation for constraint: int
        if (!is_null($sourceApp) && !(is_int($sourceApp) || ctype_digit($sourceApp))) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($sourceApp, true), gettype($sourceApp)), __LINE__);
        }
        $this->SourceApp = $sourceApp;
        return $this;
    }

    /**
     * Get IsPassive value
     * @return bool
     */
    public function getIsPassive()
    {
        return $this->IsPassive;
    }

    /**
     * Set IsPassive value
     * @param bool $isPassive
     * @return GetServiceDef
     */
    public function setIsPassive($isPassive = null)
    {
        // validation for constraint: boolean
        if (!is_null($isPassive) && !is_bool($isPassive)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isPassive, true), gettype($isPassive)), __LINE__);
        }
        $this->IsPassive = $isPassive;
        return $this;
    }

    /**
     * Get EntityId value
     * @return int
     */
    public function getEntityId()
    {
        return $this->EntityId;
    }

    /**
     * Set EntityId value
     * @param int $entityId
     * @return GetServiceDef
     */
    public function setEntityId($entityId = null)
    {
        // validation for constraint: int
        if (!is_null($entityId) && !(is_int($entityId) || ctype_digit($entityId))) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($entityId, true), gettype($entityId)), __LINE__);
        }
        $this->EntityId = $entityId;
        return $this;
    }

    /**
     * Get WhouseId value
     * @return int
     */
    public function getWhouseId()
    {
        return $this->WhouseId;
    }

    /**
     * Set WhouseId value
     * @param int $whouseId
     * @return GetServiceDef
     */
    public function setWhouseId($whouseId = null)
    {
        // validation for constraint: int
        if (!is_null($whouseId) && !(is_int($whouseId) || ctype_digit($whouseId))) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($whouseId, true), gettype($whouseId)), __LINE__);
        }
        $this->WhouseId = $whouseId;
        return $this;
    }

    /**
     * Get OrderStatus value
     * @return int
     */
    public function getOrderStatus()
    {
        return $this->OrderStatus;
    }

    /**
     * Set OrderStatus value
     * @param int $orderStatus
     * @return GetServiceDef
     */
    public function setOrderStatus($orderStatus = null)
    {
        // validation for constraint: int
        if (!is_null($orderStatus) && !(is_int($orderStatus) || ctype_digit($orderStatus))) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($orderStatus, true), gettype($orderStatus)), __LINE__);
        }
        $this->OrderStatus = $orderStatus;
        return $this;
    }

    /**
     * Get Code value
     * @return string|null
     */
    public function getCode()
    {
        return $this->Code;
    }

    /**
     * Set Code value
     * @param string $code
     * @return GetServiceDef
     */
    public function setCode($code = null)
    {
        // validation for constraint: string
        if (!is_null($code) && !is_string($code)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($code, true), gettype($code)), __LINE__);
        }
        $this->Code = $code;
        return $this;
    }

    /**
     * Get CoCode value
     * @return string|null
     */
    public function getCoCode()
    {
        return $this->CoCode;
    }

    /**
     * Set CoCode value
     * @param string $coCode
     * @return GetServiceDef
     */
    public function setCoCode($coCode = null)
    {
        // validation for constraint: string
        if (!is_null($coCode) && !is_string($coCode)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($coCode, true), gettype($coCode)), __LINE__);
        }
        $this->CoCode = $coCode;
        return $this;
    }

    /**
     * Get BranchCode value
     * @return string|null
     */
    public function getBranchCode()
    {
        return $this->BranchCode;
    }

    /**
     * Set BranchCode value
     * @param string $branchCode
     * @return GetServiceDef
     */
    public function setBranchCode($branchCode = null)
    {
        // validation for constraint: string
        if (!is_null($branchCode) && !is_string($branchCode)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($branchCode, true), gettype($branchCode)), __LINE__);
        }
        $this->BranchCode = $branchCode;
        return $this;
    }

    /**
     * Get DocNo value
     * @return string|null
     */
    public function getDocNo()
    {
        return $this->DocNo;
    }

    /**
     * Set DocNo value
     * @param string $docNo
     * @return GetServiceDef
     */
    public function setDocNo($docNo = null)
    {
        // validation for constraint: string
        if (!is_null($docNo) && !is_string($docNo)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($docNo, true), gettype($docNo)), __LINE__);
        }
        $this->DocNo = $docNo;
        return $this;
    }

    /**
     * Get EntityCode value
     * @return string|null
     */
    public function getEntityCode()
    {
        return $this->EntityCode;
    }

    /**
     * Set EntityCode value
     * @param string $entityCode
     * @return GetServiceDef
     */
    public function setEntityCode($entityCode = null)
    {
        // validation for constraint: string
        if (!is_null($entityCode) && !is_string($entityCode)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($entityCode, true), gettype($entityCode)), __LINE__);
        }
        $this->EntityCode = $entityCode;
        return $this;
    }

    /**
     * Get TIds value
     * @return ArrayOfInt|null
     */
    public function getTIds()
    {
        return $this->TIds;
    }

    /**
     * Set TIds value
     * @param ArrayOfInt $tIds
     * @return GetServiceDef
     */
    public function setTIds(ArrayOfInt $tIds = null)
    {
        $this->TIds = $tIds;
        return $this;
    }

    /**
     * Get VknTckn value
     * @return string|null
     */
    public function getVknTckn()
    {
        return $this->VknTckn;
    }

    /**
     * Set VknTckn value
     * @param string $vknTckn
     * @return GetServiceDef
     */
    public function setVknTckn($vknTckn = null)
    {
        // validation for constraint: string
        if (!is_null($vknTckn) && !is_string($vknTckn)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($vknTckn, true), gettype($vknTckn)), __LINE__);
        }
        $this->VknTckn = $vknTckn;
        return $this;
    }

    /**
     * Get PurcSalesList value
     * @return ArrayOfInt|null
     */
    public function getPurcSalesList()
    {
        return $this->PurcSalesList;
    }

    /**
     * Set PurcSalesList value
     * @param ArrayOfInt $purcSalesList
     * @return GetServiceDef
     */
    public function setPurcSalesList(ArrayOfInt $purcSalesList = null)
    {
        $this->PurcSalesList = $purcSalesList;
        return $this;
    }

    /**
     * Get ETTN value
     * @return string|null
     */
    public function getETTN()
    {
        return $this->ETTN;
    }

    /**
     * Set ETTN value
     * @param string $eTTN
     * @return GetServiceDef
     */
    public function setETTN($eTTN = null)
    {
        // validation for constraint: string
        if (!is_null($eTTN) && !is_string($eTTN)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($eTTN, true), gettype($eTTN)), __LINE__);
        }
        $this->ETTN = $eTTN;
        return $this;
    }
}
